/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.Locale;
import java.util.Optional;

public class LocaleParser {
    public static Optional<Locale> parseLocale(String locale) {
        if (locale == null) {
            return Optional.empty();
        }
        String[] split = locale.split("_");
        if (split.length == 1) {
            return Optional.of(new Locale(split[0]));
        }
        if (split.length == 2) {
            return Optional.of(new Locale(split[0], split[1]));
        }
        return Optional.empty();
    }

    public static Locale parseLocaleStrict(String locale) {
        String[] split = locale.split("_");
        if (split.length == 1) {
            return new Locale(split[0]);
        }
        if (split.length == 2) {
            return new Locale(split[0], split[1]);
        }
        throw new IllegalArgumentException("Invalid locale: " + locale);
    }
}

