/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge;

import com.google.inject.Injector;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.bstats.sponge.Metrics;
import net.skinsrestorer.shadow.javax.annotation.PostConstruct;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.gui.SharedGUI;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.Tristate;
import net.skinsrestorer.sponge.gui.SkinsGUI;
import net.skinsrestorer.sponge.listeners.ForceAliveListener;
import net.skinsrestorer.sponge.wrapper.WrapperSponge;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.ConstructPluginEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.model.PluginContributor;

public class SRSpongeAdapter
implements SRServerAdapter<PluginContainer> {
    private static final GsonComponentSerializer GSON = GsonComponentSerializer.gson();
    private final net.skinsrestorer.shadow.injector.Injector injector;
    private final PluginContainer pluginContainer;
    private final Game game;
    private final MetricsConfigManager metricsConfigManager;
    private final Set<SRRegisterPayload<SRCommandSender>> commands = new HashSet<SRRegisterPayload<SRCommandSender>>();

    @PostConstruct
    public void init() {
        this.game.eventManager().registerListeners(this.pluginContainer, (Object)this);
    }

    @Override
    public Object createMetricsInstance() {
        Metrics metrics = ((Metrics.Factory)this.injector.getSingleton(Injector.class).getInstance(Metrics.Factory.class)).make(11500);
        metrics.startup(null);
        return metrics;
    }

    @Override
    public boolean isPluginEnabled(String pluginName) {
        return this.game.pluginManager().plugin(pluginName).isPresent();
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.game.asyncScheduler().executor(this.pluginContainer).execute(runnable);
    }

    @Override
    public void runSync(Runnable runnable) {
        this.game.server().scheduler().executor(this.pluginContainer).execute(runnable);
    }

    @Override
    public void runSyncToPlayer(SRPlayer player, Runnable runnable) {
        this.runSync(runnable);
    }

    @Override
    public boolean determineProxy() {
        PluginContainer sponge = (PluginContainer)this.game.pluginManager().plugin("sponge").orElseThrow(IllegalStateException::new);
        try {
            String mode = ((CommentedConfigurationNode)((CommentedConfigurationNode)this.game.configManager().pluginConfig(sponge).config().load()).node(new Object[]{"ip-forwarding", "mode"})).getString();
            if (mode == null) {
                throw new IllegalStateException("Invalid config");
            }
            return !mode.equals("NONE");
        }
        catch (ConfigurateException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void openServerGUI(SRPlayer player, int page) {
        InventoryMenu inventory = (InventoryMenu)this.injector.getSingleton(SharedGUI.class).createGUI(this.injector.getSingleton(SkinsGUI.class), this.injector.getSingleton(SharedGUI.ServerGUIActions.class), player, page);
        this.runSyncToPlayer(player, () -> inventory.open(player.getAs(ServerPlayer.class)));
    }

    @Override
    public void openProxyGUI(SRPlayer player, int page, Map<String, String> skinList) {
        InventoryMenu inventory = this.injector.getSingleton(SkinsGUI.class).createGUI((Consumer<ClickEventInfo>)this.injector.getSingleton(SharedGUI.ProxyGUIActions.class), (SRForeign)player, page, skinList);
        this.runSyncToPlayer(player, () -> inventory.open(player.getAs(ServerPlayer.class)));
    }

    @Override
    public Optional<SRPlayer> getPlayer(String name) {
        return this.game.server().player(name).map(p -> this.injector.getSingleton(WrapperSponge.class).player((ServerPlayer)p));
    }

    @Override
    public void sendMessageToChannel(SRPlayer player, byte[] data) {
        ((RawDataChannel)this.game.channelManager().ofType(ResourceKey.of((String)"sr", (String)"messagechannel"), RawDataChannel.class)).play().sendTo(player.getAs(ServerPlayer.class), buf -> buf.writeBytes(data));
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.game.asyncScheduler().executor(this.pluginContainer).scheduleAtFixedRate(runnable, (long)delay, (long)interval, timeUnit);
    }

    @Override
    public void extendLifeTime(PluginContainer plugin, Object object) {
        this.game.eventManager().registerListener(EventListenerRegistration.builder(ConstructPluginEvent.class).order(Order.POST).plugin(plugin).listener((EventListener)new ForceAliveListener(object)).build());
    }

    @Override
    public Tristate getMetricsState() {
        Boolean collectionState = this.metricsConfigManager.effectiveCollectionState(this.pluginContainer).asNullableBoolean();
        if (collectionState == null) {
            return Tristate.UNDEFINED;
        }
        return collectionState != false ? Tristate.TRUE : Tristate.FALSE;
    }

    @Override
    public String getPlatformVersion() {
        return this.game.platform().minecraftVersion().name();
    }

    @Override
    public String getPlatformName() {
        return this.game.platform().container(Platform.Component.IMPLEMENTATION).metadata().name().orElse("N/A");
    }

    @Override
    public String getPlatformVendor() {
        return "N/A";
    }

    @Override
    public Platform getPlatform() {
        return Platform.SPONGE;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return this.game.pluginManager().plugins().stream().map(p -> new PluginInfo(p.instance() != null, p.metadata().name().orElseGet(() -> p.metadata().id()), p.metadata().version().getQualifier(), p.metadata().entrypoint(), (String[])p.metadata().contributors().stream().map(PluginContributor::name).toArray(String[]::new))).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return player.getAs(Player.class).profile().properties().stream().filter(property -> property.name().equals("textures")).filter(ProfileProperty::hasSignature).map(property -> SkinProperty.of(property.value(), (String)property.signature().orElseThrow(() -> new IllegalStateException("Signature is missing")))).findFirst();
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers() {
        WrapperSponge wrapper = this.injector.getSingleton(WrapperSponge.class);
        return this.game.server().onlinePlayers().stream().map(wrapper::player).collect(Collectors.toList());
    }

    @Override
    public void registerCommand(SRRegisterPayload<SRCommandSender> payload) {
        this.commands.add(payload);
    }

    @Listener
    public void onCommandRegister(RegisterCommandEvent<Command.Raw> event) {
        final WrapperSponge wrapper = this.injector.getSingleton(WrapperSponge.class);
        final SkinsRestorerLocale locale = this.injector.getSingleton(SkinsRestorerLocale.class);
        final LegacyComponentSerializer serializer = LegacyComponentSerializer.legacySection();
        for (final SRRegisterPayload<SRCommandSender> payload : this.commands) {
            event.register(this.pluginContainer, (Object)new Command.Raw(){

                public CommandResult process(CommandCause cause, ArgumentReader.Mutable arguments) {
                    String argumentsString = arguments.remaining();
                    String command = payload.getMeta().getRootName() + (String)(argumentsString.isEmpty() ? "" : " " + argumentsString);
                    payload.getExecutor().execute(wrapper.commandSender(cause), command);
                    return CommandResult.builder().build();
                }

                public List<CommandCompletion> complete(CommandCause cause, ArgumentReader.Mutable arguments) {
                    return (List)((CompletableFuture)payload.getExecutor().tabComplete(wrapper.commandSender(cause), arguments.remaining()).thenApply(list -> list.stream().map(CommandCompletion::of).collect(Collectors.toList()))).join();
                }

                public boolean canExecute(CommandCause cause) {
                    return payload.getExecutor().hasPermission(wrapper.commandSender(cause));
                }

                public Optional<Component> shortDescription(CommandCause cause) {
                    SRCommandSender sender = wrapper.commandSender(cause);
                    return Optional.of(GSON.deserialize((Object)locale.getMessage(sender, payload.getMeta().getRootHelp().getCommandDescription())));
                }

                public Optional<Component> extendedDescription(CommandCause cause) {
                    SRCommandSender sender = wrapper.commandSender(cause);
                    return Optional.of(serializer.deserialize(String.join((CharSequence)"\n", payload.getExecutor().getManager().getHelpMessage(payload.getMeta().getRootName(), sender))));
                }

                public Component usage(CommandCause cause) {
                    return Component.empty();
                }
            }, payload.getMeta().getRootName(), payload.getMeta().getAliases());
        }
    }

    @Inject
    public SRSpongeAdapter(net.skinsrestorer.shadow.injector.Injector injector, PluginContainer pluginContainer, Game game, MetricsConfigManager metricsConfigManager) {
        this.injector = injector;
        this.pluginContainer = pluginContainer;
        this.game = game;
        this.metricsConfigManager = metricsConfigManager;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }
}

