/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.subjects.SRServerPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.Tristate;
import net.skinsrestorer.sponge.SRSpongeAdapter;
import net.skinsrestorer.sponge.wrapper.WrapperSponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;

public class MetricsJoinListener
implements EventListener<ServerSideConnectionEvent.Join> {
    private final SRSpongeAdapter adapter;
    private final SkinsRestorerLocale locale;
    private final WrapperSponge wrapper;
    private final GsonComponentSerializer gsonSerializer = GsonComponentSerializer.gson();

    public void handle(ServerSideConnectionEvent.Join event) {
        ServerPlayer player = event.player();
        SRServerPlayer srPlayer = this.wrapper.player(player);
        if (player.hasPermission("sponge.command.metrics") && this.adapter.getMetricsState() == Tristate.UNDEFINED) {
            Component component = this.gsonSerializer.deserialize((Object)this.locale.getMessage(srPlayer, Message.SPONGE_METRICS_CONSENT));
            Component hoverComponent = this.gsonSerializer.deserialize((Object)this.locale.getMessage(srPlayer, Message.SPONGE_METRICS_HOVER));
            component = component.clickEvent(ClickEvent.runCommand((String)"/srmetricsenable"));
            component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent));
            player.sendMessage(component);
        }
    }

    @Inject
    public MetricsJoinListener(SRSpongeAdapter adapter, SkinsRestorerLocale locale, WrapperSponge wrapper) {
        this.adapter = adapter;
        this.locale = locale;
        this.wrapper = wrapper;
    }
}

