/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.action;

import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClickAction {
    private ActionType type;
    private String executable;
    private String delay;
    private String chance;

    public ClickAction(@NotNull ActionType type, @NotNull String executable) {
        this.type = type;
        this.executable = executable;
        this.delay = null;
        this.chance = null;
    }

    @NotNull
    public ActionType getType() {
        return this.type;
    }

    public void setType(@NotNull ActionType type) {
        this.type = type;
    }

    @NotNull
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(@NotNull String executable) {
        this.executable = executable;
    }

    public boolean hasDelay() {
        return this.delay != null;
    }

    public void setDelay(@Nullable String delay) {
        this.delay = delay;
    }

    @Nullable
    public String getChance() {
        return this.chance;
    }

    public void setChance(@Nullable String chance) {
        this.chance = chance;
    }

    public long getDelay(@NotNull MenuHolder holder) {
        if (this.delay == null || this.delay.isEmpty()) {
            return 0L;
        }
        Long parsed = Longs.tryParse((String)holder.setPlaceholders(this.delay));
        return parsed == null ? 0L : parsed;
    }

    public boolean checkChance(@NotNull MenuHolder holder) {
        if (this.chance == null) {
            return true;
        }
        Double parsedChance = Doubles.tryParse((String)holder.setPlaceholders(this.chance));
        if (parsedChance == null) {
            return false;
        }
        if (parsedChance >= 100.0) {
            return true;
        }
        double random = (double)ThreadLocalRandom.current().nextInt(10000) / 100.0;
        return random <= parsedChance;
    }
}

