/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.libs.adventure.adventure.resource;

import com.extendedclip.deluxemenus.libs.adventure.adventure.internal.Internals;
import com.extendedclip.deluxemenus.libs.adventure.adventure.resource.ResourcePackRequest;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.examination.ExaminableProperty;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ResourcePackRequestImpl
implements ResourcePackRequest {
    private final UUID id;
    private final URI uri;
    private final String hash;
    private final boolean required;
    private final Component prompt;

    ResourcePackRequestImpl(@NotNull UUID id, @NotNull URI uri, @NotNull String hash, boolean required, @Nullable Component prompt) {
        this.id = Objects.requireNonNull(id, "id");
        this.uri = Objects.requireNonNull(uri, "uri");
        this.hash = Objects.requireNonNull(hash, "hash");
        this.required = required;
        this.prompt = prompt;
    }

    @Override
    @NotNull
    public UUID id() {
        return this.id;
    }

    @Override
    @NotNull
    public URI uri() {
        return this.uri;
    }

    @Override
    @NotNull
    public String hash() {
        return this.hash;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    @Nullable
    public Component prompt() {
        return this.prompt;
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("id", this.id), ExaminableProperty.of("uri", this.uri), ExaminableProperty.of("hash", this.hash), ExaminableProperty.of("required", this.required), ExaminableProperty.of("prompt", this.prompt));
    }

    public String toString() {
        return Internals.toString(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourcePackRequestImpl)) {
            return false;
        }
        ResourcePackRequestImpl that = (ResourcePackRequestImpl)other;
        return this.id.equals(that.id) && this.uri.equals(that.uri) && this.hash.equals(that.hash) && this.required == that.required && Objects.equals(this.prompt, that.prompt);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + this.hash.hashCode();
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.prompt != null ? this.prompt.hashCode() : 0);
        return result;
    }

    static final class BuilderImpl
    implements ResourcePackRequest.Builder {
        private UUID id;
        private URI uri;
        private String hash;
        private boolean required;
        private Component prompt;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public ResourcePackRequest.Builder id(@NotNull UUID id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @Override
        @NotNull
        public ResourcePackRequest.Builder uri(@NotNull URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @Override
        @NotNull
        public ResourcePackRequest.Builder hash(@NotNull String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            return this;
        }

        @Override
        @NotNull
        public ResourcePackRequest.Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        @NotNull
        public ResourcePackRequest.Builder prompt(@Nullable Component prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        @NotNull
        public ResourcePackRequest build() {
            return new ResourcePackRequestImpl(this.id, this.uri, this.hash, this.required, this.prompt);
        }
    }
}

