/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.menu.HeadType;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.nbt.NbtProvider;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class MenuItem
implements Cloneable {
    private static final Map<String, Function<PlayerInventory, ItemStack>> INVENTORY_ITEM_ACCESSORS = ImmutableMap.builder().put((Object)"main_hand", PlayerInventory::getItemInMainHand).put((Object)"off_hand", PlayerInventory::getItemInOffHand).put((Object)"armor_helmet", PlayerInventory::getHelmet).put((Object)"armor_chestplate", PlayerInventory::getChestplate).put((Object)"armor_leggings", PlayerInventory::getLeggings).put((Object)"armor_boots", PlayerInventory::getBoots).build();
    private String configMaterial;
    private short configData;
    private int configAmount;
    private String customModelData;
    private String configDynamicAmount = null;
    private String configDisplayName;
    private List<String> configLore;
    private DyeColor configBaseColor;
    private HeadType headType;
    private String placeholderData;
    private String rgb;
    private Map<Enchantment, Integer> enchantments;
    private List<PotionEffect> potionEffects;
    private List<Pattern> bannerMeta;
    private List<ItemFlag> itemFlags;
    private boolean unbreakable;
    private boolean hideAttributes;
    private boolean hideEnchants;
    private boolean hidePotionEffects;
    private boolean hideUnbreakable;
    private String lowercaseConfigMaterial;
    private boolean displayNameHasPlaceholders;
    private boolean loreHasPlaceholders;
    private String nbtString;
    private String nbtInt;
    private List<String> nbtStrings;
    private List<String> nbtInts;
    private int slot;
    private int priority;
    private boolean updatePlaceholders;
    private ClickHandler clickHandler;
    private ClickHandler leftClickHandler;
    private ClickHandler rightClickHandler;
    private ClickHandler shiftLeftClickHandler;
    private ClickHandler shiftRightClickHandler;
    private ClickHandler middleClickHandler;
    private RequirementList viewRequirements;
    private RequirementList clickRequirements;
    private RequirementList leftClickRequirements;
    private RequirementList rightClickRequirements;
    private RequirementList shiftLeftClickRequirements;
    private RequirementList shiftRightClickRequirements;
    private RequirementList middleClickRequirements;

    public MenuItem clone() {
        try {
            return (MenuItem)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            DeluxeMenus.printStacktrace("Something went wrong while trying to clone menu item.", exception);
            return new MenuItem();
        }
    }

    public ItemStack getItemStack(@NotNull MenuHolder holder) {
        Object parts;
        BlockStateMeta blockStateMeta;
        BannerMeta meta;
        Player viewer = holder.getViewer();
        ItemStack itemStack = null;
        int amount = 1;
        if (this.isPlaceholderMaterial(this.lowercaseConfigMaterial)) {
            this.configMaterial = holder.setPlaceholders(this.configMaterial.substring("placeholder-".length()));
            this.lowercaseConfigMaterial = this.configMaterial.toLowerCase(Locale.ENGLISH);
        }
        if (this.isPlayerItem(this.lowercaseConfigMaterial)) {
            ItemStack playerItem = INVENTORY_ITEM_ACCESSORS.get(this.lowercaseConfigMaterial).apply(viewer.getInventory());
            if (playerItem == null) {
                return new ItemStack(Material.STONE, amount);
            }
            itemStack = playerItem.clone();
            amount = playerItem.getAmount();
        }
        int temporaryAmount = amount;
        if (this.isHeadItem(this.lowercaseConfigMaterial)) {
            itemStack = this.getItemFromHook(this.headType.getHookName(), holder.setPlaceholders(this.configMaterial.substring(this.headType.getPrefix().length()))).orElseGet(() -> DeluxeMenus.getInstance().getHead().clone());
        } else if (this.isItemsAdderItem(this.lowercaseConfigMaterial)) {
            itemStack = this.getItemFromHook("itemsadder", holder.setPlaceholders(this.configMaterial.substring("itemsadder-".length()))).orElseGet(() -> new ItemStack(Material.STONE, temporaryAmount));
        } else if (this.isOraxenItem(this.lowercaseConfigMaterial)) {
            itemStack = this.getItemFromHook("oraxen", holder.setPlaceholders(this.configMaterial.substring("oraxen-".length()))).orElseGet(() -> new ItemStack(Material.STONE, temporaryAmount));
        } else if (this.isWaterBottle(this.lowercaseConfigMaterial)) {
            itemStack = this.createWaterBottle(amount);
        } else if (itemStack == null) {
            Material material = Material.getMaterial((String)this.configMaterial.toUpperCase(Locale.ROOT));
            if (material == null) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Material: " + this.configMaterial + " is not valid! Setting to Stone.");
                itemStack = new ItemStack(Material.STONE, amount);
            } else {
                itemStack = new ItemStack(material, amount);
            }
        }
        if (this.isBanner(itemStack.getType()) && (meta = (BannerMeta)itemStack.getItemMeta()) != null) {
            if (this.configBaseColor != null) {
                meta.setBaseColor(this.configBaseColor);
            }
            if (this.bannerMeta != null) {
                meta.setPatterns(this.bannerMeta);
            }
            itemStack.setItemMeta((ItemMeta)meta);
        }
        if (this.isShield(itemStack.getType()) && (blockStateMeta = (BlockStateMeta)itemStack.getItemMeta()) != null) {
            Banner banner = (Banner)blockStateMeta.getBlockState();
            if (this.configBaseColor != null) {
                banner.setBaseColor(this.configBaseColor);
                banner.update();
                blockStateMeta.setBlockState((BlockState)banner);
            }
            if (this.bannerMeta != null) {
                banner.setPatterns(this.bannerMeta);
                banner.update();
                blockStateMeta.setBlockState((BlockState)banner);
            }
            itemStack.setItemMeta((ItemMeta)blockStateMeta);
        }
        if (this.isPotion(itemStack.getType()) && (meta = (PotionMeta)itemStack.getItemMeta()) != null) {
            if (this.rgb != null) {
                String rgbString = holder.setPlaceholders(this.rgb);
                parts = rgbString.split(",");
                try {
                    meta.setColor(Color.fromRGB((int)Integer.parseInt(parts[0].trim()), (int)Integer.parseInt(parts[1].trim()), (int)Integer.parseInt(parts[2].trim())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.potionEffects != null && !this.potionEffects.isEmpty()) {
                for (PotionEffect effect : this.potionEffects) {
                    meta.addCustomEffect(effect, true);
                }
            }
            itemStack.setItemMeta((ItemMeta)meta);
        }
        if (itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        if (this.placeholderData != null) {
            try {
                this.configData = Short.parseShort(holder.setPlaceholders(this.placeholderData));
            }
            catch (Exception exception) {
                DeluxeMenus.printStacktrace("Invalid placeholder data found: " + holder.setPlaceholders(this.placeholderData) + ".", exception);
            }
        }
        if (this.configData > 0) {
            itemStack.setDurability(this.configData);
        }
        if (this.configAmount != -1) {
            amount = this.configAmount;
        }
        if (this.configDynamicAmount != null) {
            try {
                int dynamicAmount = (int)Double.parseDouble(holder.setPlaceholders(this.configDynamicAmount));
                amount = Math.max(dynamicAmount, 1);
            }
            catch (NumberFormatException dynamicAmount) {
                // empty catch block
            }
        }
        if (amount > 64) {
            amount = 64;
        }
        itemStack.setAmount(amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        if (this.customModelData != null && VersionHelper.IS_CUSTOM_MODEL_DATA) {
            try {
                int modelData = Integer.parseInt(holder.setPlaceholders(this.customModelData));
                if (modelData > 0) {
                    itemMeta.setCustomModelData(Integer.valueOf(modelData));
                }
            }
            catch (Exception modelData) {
                // empty catch block
            }
        }
        if (this.configDisplayName != null) {
            String displayName = holder.setPlaceholders(this.configDisplayName);
            itemMeta.setDisplayName(StringUtils.color(displayName));
        }
        if (this.configLore != null) {
            List lore = this.configLore.stream().map(holder::setPlaceholders).map(StringUtils::color).map(line -> line.split("\n")).flatMap(Arrays::stream).map(line -> line.split("\\\\n")).flatMap(Arrays::stream).collect(Collectors.toList());
            itemMeta.setLore(lore);
        }
        if (this.itemFlags != null && !this.itemFlags.isEmpty()) {
            for (ItemFlag flag : this.itemFlags) {
                itemMeta.addItemFlags(new ItemFlag[]{flag});
            }
        }
        if (this.hideAttributes) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.hideEnchants) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.hidePotionEffects) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        }
        if (this.unbreakable) {
            itemMeta.setUnbreakable(true);
        }
        if (this.hideUnbreakable) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (itemMeta instanceof LeatherArmorMeta && this.rgb != null) {
            String rgbString = holder.setPlaceholders(this.rgb);
            parts = rgbString.split(",");
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            try {
                leatherArmorMeta.setColor(Color.fromRGB((int)Integer.parseInt(((String)parts[0]).trim()), (int)Integer.parseInt(((String)parts[1]).trim()), (int)Integer.parseInt(((String)parts[2]).trim())));
                itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
            }
            catch (Exception exception) {
                DeluxeMenus.printStacktrace("Invalid rgb colors found for leather armor: " + ((String)parts[0]).trim() + ", " + ((String)parts[1]).trim() + ", " + ((String)parts[2]).trim(), exception);
            }
        } else if (itemMeta instanceof FireworkEffectMeta && this.rgb != null) {
            String rgbString = holder.setPlaceholders(this.rgb);
            parts = rgbString.split(",");
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemMeta;
            try {
                fireworkEffectMeta.setEffect(FireworkEffect.builder().withColor(Color.fromRGB((int)Integer.parseInt(((String)parts[0]).trim()), (int)Integer.parseInt(((String)parts[1]).trim()), (int)Integer.parseInt(((String)parts[2]).trim()))).build());
                itemStack.setItemMeta((ItemMeta)fireworkEffectMeta);
            }
            catch (Exception exception) {
                DeluxeMenus.printStacktrace("Invalid rgb colors found for firework or firework star: " + ((String)parts[0]).trim() + ", " + ((String)parts[1]).trim() + ", " + ((String)parts[2]).trim(), exception);
            }
        } else if (itemMeta instanceof EnchantmentStorageMeta && this.enchantments != null) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            for (Map.Entry entry : this.enchantments.entrySet()) {
                boolean result = enchantmentStorageMeta.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                if (result) continue;
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Failed to add enchantment " + ((Enchantment)entry.getKey()).getName() + " to item " + itemStack.getType());
            }
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            itemStack.setItemMeta(itemMeta);
        }
        if (!(itemMeta instanceof EnchantmentStorageMeta) && this.enchantments != null) {
            itemStack.addUnsafeEnchantments(this.enchantments);
        }
        if (NbtProvider.isAvailable()) {
            String tag;
            String tag2;
            if (this.nbtString != null && (tag2 = holder.setPlaceholders(this.nbtString)).contains(":")) {
                parts = tag2.split(":", 2);
                itemStack = NbtProvider.setString(itemStack, (String)parts[0], (String)parts[1]);
            }
            if (this.nbtInt != null && (tag = holder.setPlaceholders(this.nbtInt)).contains(":")) {
                parts = tag.split(":");
                itemStack = NbtProvider.setInt(itemStack, (String)parts[0], Integer.parseInt((String)parts[1]));
            }
            for (String nbtTag : this.nbtStrings) {
                String string = holder.setPlaceholders(nbtTag);
                if (!string.contains(":")) continue;
                String[] parts2 = string.split(":", 2);
                itemStack = NbtProvider.setString(itemStack, parts2[0], parts2[1]);
            }
            for (String nbtTag : this.nbtInts) {
                String string = holder.setPlaceholders(nbtTag);
                if (!string.contains(":")) continue;
                String[] parts3 = string.split(":");
                itemStack = NbtProvider.setInt(itemStack, parts3[0], Integer.parseInt(parts3[1]));
            }
        }
        return itemStack;
    }

    private boolean isPlaceholderMaterial(@NotNull String material) {
        return material.startsWith("placeholder-");
    }

    private boolean isPlayerItem(@NotNull String material) {
        return INVENTORY_ITEM_ACCESSORS.containsKey(material);
    }

    private boolean isHeadItem(@NotNull String material) {
        Optional<HeadType> headType = HeadType.parseHeadType(material);
        headType.ifPresent(type -> {
            this.headType = type;
        });
        return headType.isPresent();
    }

    private boolean isItemsAdderItem(@NotNull String material) {
        return material.startsWith("itemsadder-");
    }

    private boolean isOraxenItem(@NotNull String material) {
        return material.startsWith("oraxen-");
    }

    private boolean isWaterBottle(@NotNull String material) {
        return material.equalsIgnoreCase("water_bottle");
    }

    private boolean isBanner(@NotNull Material material) {
        return material.name().endsWith("_BANNER");
    }

    private boolean isShield(@NotNull Material material) {
        return material == Material.SHIELD;
    }

    private boolean isPotion(@NotNull Material material) {
        return material == Material.POTION || material == Material.SPLASH_POTION || material == Material.LINGERING_POTION;
    }

    @NotNull
    private ItemStack createWaterBottle(int amount) {
        ItemStack itemStack = new ItemStack(Material.POTION, amount);
        PotionMeta itemMeta = (PotionMeta)itemStack.getItemMeta();
        if (itemMeta != null) {
            PotionData potionData = new PotionData(PotionType.WATER);
            itemMeta.setBasePotionData(potionData);
            itemStack.setItemMeta((ItemMeta)itemMeta);
        }
        return itemStack;
    }

    @NotNull
    private Optional<ItemStack> getItemFromHook(String hookName, String ... args) {
        return DeluxeMenus.getInstance().getItemHook(hookName).map(itemHook -> itemHook.getItem(args));
    }

    public ClickHandler getClickHandler() {
        return this.clickHandler;
    }

    public void setClickHandler(ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
    }

    public RequirementList getClickRequirements() {
        return this.clickRequirements;
    }

    public void setClickRequirements(RequirementList clickRequirements) {
        this.clickRequirements = clickRequirements;
    }

    public void setPotionEffects(List<PotionEffect> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public String getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(String customModelData) {
        this.customModelData = customModelData;
    }

    public DyeColor getConfigBaseColor() {
        return this.configBaseColor;
    }

    public void setConfigBaseColor(DyeColor configBaseColor) {
        this.configBaseColor = configBaseColor;
    }

    @NotNull
    public String getConfigMaterial() {
        return this.configMaterial;
    }

    public void setConfigMaterial(@NotNull String configMaterial) {
        this.configMaterial = configMaterial;
        this.lowercaseConfigMaterial = configMaterial.toLowerCase(Locale.ROOT);
    }

    public short getConfigData() {
        return this.configData;
    }

    public void setConfigData(Short configData) {
        this.configData = configData;
    }

    public int getConfigAmount() {
        return this.configAmount;
    }

    public void setConfigAmount(int configAmount) {
        this.configAmount = configAmount;
    }

    public String getConfigDisplayName() {
        return this.configDisplayName;
    }

    public void setConfigDisplayName(String configDisplayName) {
        this.configDisplayName = configDisplayName;
        if (this.configDisplayName != null) {
            this.displayNameHasPlaceholders = DeluxeMenusConfig.containsPlaceholders(this.configDisplayName);
        }
    }

    public List<String> getConfigLore() {
        return this.configLore;
    }

    public void setConfigLore(List<String> configLore) {
        this.configLore = configLore;
        if (this.configLore != null) {
            this.loreHasPlaceholders = configLore.stream().anyMatch(DeluxeMenusConfig::containsPlaceholders);
        }
    }

    public ClickHandler getLeftClickHandler() {
        return this.leftClickHandler;
    }

    public void setLeftClickHandler(ClickHandler clickHandler) {
        this.leftClickHandler = clickHandler;
    }

    public ClickHandler getRightClickHandler() {
        return this.rightClickHandler;
    }

    public void setRightClickHandler(ClickHandler clickHandler) {
        this.rightClickHandler = clickHandler;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean hasViewRequirement() {
        return this.viewRequirements != null && this.viewRequirements.getRequirements() != null;
    }

    public RequirementList getViewRequirements() {
        return this.viewRequirements;
    }

    public void setViewRequirements(RequirementList r) {
        this.viewRequirements = r;
    }

    public boolean displayNameHasPlaceholders() {
        return this.displayNameHasPlaceholders;
    }

    public boolean loreHasPlaceholders() {
        return this.loreHasPlaceholders;
    }

    public boolean updatePlaceholders() {
        return this.updatePlaceholders;
    }

    public void setUpdatePlaceholders(boolean updatePlaceholders) {
        this.updatePlaceholders = updatePlaceholders;
    }

    public boolean hideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(boolean hide) {
        this.hideAttributes = hide;
    }

    public List<ItemFlag> itemFlags() {
        return this.itemFlags;
    }

    public void setItemFlags(List<ItemFlag> flags) {
        this.itemFlags = flags;
    }

    public boolean hideEnchants() {
        return this.hideEnchants;
    }

    public void setHideEnchants(boolean hideEnchants) {
        this.hideEnchants = hideEnchants;
    }

    public boolean hidePotionEffects() {
        return this.hidePotionEffects;
    }

    public void setHidePotionEffects(boolean hidePotionEffects) {
        this.hidePotionEffects = hidePotionEffects;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    public RequirementList getLeftClickRequirements() {
        return this.leftClickRequirements;
    }

    public void setLeftClickRequirements(RequirementList leftClickRequirements) {
        this.leftClickRequirements = leftClickRequirements;
    }

    public RequirementList getRightClickRequirements() {
        return this.rightClickRequirements;
    }

    public void setRightClickRequirements(RequirementList rightClickRequirements) {
        this.rightClickRequirements = rightClickRequirements;
    }

    public List<Pattern> getBannerMeta() {
        return this.bannerMeta;
    }

    public void setBannerMeta(List<Pattern> bannerMeta) {
        this.bannerMeta = bannerMeta;
    }

    public String getConfigDynamicAmount() {
        return this.configDynamicAmount;
    }

    public void setConfigDynamicAmount(String configDynamicAmount) {
        this.configDynamicAmount = configDynamicAmount;
    }

    public boolean hideUnbreakable() {
        return this.hideUnbreakable;
    }

    public void setHideUnbreakable(boolean b) {
        this.hideUnbreakable = b;
    }

    public String getRGB() {
        return this.rgb;
    }

    public void setRGB(String rgb) {
        this.rgb = rgb;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public String getPlaceholderData() {
        return this.placeholderData;
    }

    public void setPlaceholderData(String placeholderData) {
        this.placeholderData = placeholderData;
    }

    public ClickHandler getShiftLeftClickHandler() {
        return this.shiftLeftClickHandler;
    }

    public void setShiftLeftClickHandler(ClickHandler shiftLeftClickHandler) {
        this.shiftLeftClickHandler = shiftLeftClickHandler;
    }

    public ClickHandler getShiftRightClickHandler() {
        return this.shiftRightClickHandler;
    }

    public void setShiftRightClickHandler(ClickHandler shiftRightClickHandler) {
        this.shiftRightClickHandler = shiftRightClickHandler;
    }

    public RequirementList getShiftLeftClickRequirements() {
        return this.shiftLeftClickRequirements;
    }

    public void setShiftLeftClickRequirements(RequirementList shiftLeftClickRequirements) {
        this.shiftLeftClickRequirements = shiftLeftClickRequirements;
    }

    public RequirementList getShiftRightClickRequirements() {
        return this.shiftRightClickRequirements;
    }

    public void setShiftRightClickRequirements(RequirementList shiftRightClickRequirements) {
        this.shiftRightClickRequirements = shiftRightClickRequirements;
    }

    public ClickHandler getMiddleClickHandler() {
        return this.middleClickHandler;
    }

    public void setMiddleClickHandler(ClickHandler middleClickHandler) {
        this.middleClickHandler = middleClickHandler;
    }

    public RequirementList getMiddleClickRequirements() {
        return this.middleClickRequirements;
    }

    public void setMiddleClickRequirements(RequirementList middleClickRequirements) {
        this.middleClickRequirements = middleClickRequirements;
    }

    public String getNbtString() {
        return this.nbtString;
    }

    public void setNbtString(String nbtString) {
        this.nbtString = nbtString;
    }

    public String getNbtInt() {
        return this.nbtInt;
    }

    public void setNbtInt(String nbtInt) {
        this.nbtInt = nbtInt;
    }

    public List<String> getNbtStrings() {
        return this.nbtStrings;
    }

    public void setNbtStrings(List<String> nbtStrings) {
        this.nbtStrings = nbtStrings;
    }

    public List<String> getNbtInts() {
        return this.nbtInts;
    }

    public void setNbtInts(List<String> nbtInts) {
        this.nbtInts = nbtInts;
    }
}

