/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.allNms;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;

public class v1_13Events
implements Listener {
    Residence plugin;

    public v1_13Events(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLandDryFade(BlockFadeEvent event) {
        if (Version.isCurrentLower((Version)Version.v1_13_R1)) {
            return;
        }
        if (!Flags.dryup.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        CMIMaterial mat = CMIMaterial.get((Block)event.getBlock());
        if (!mat.equals((Object)CMIMaterial.FARMLAND)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getNewState().getLocation());
        if (perms.has(Flags.dryup, FlagPermissions.FlagCombo.OnlyFalse)) {
            Block b = event.getBlock();
            try {
                BlockData data = b.getBlockData();
                Farmland farm = (Farmland)data;
                if (farm.getMoisture() < 2) {
                    farm.setMoisture(7);
                    b.setBlockData((BlockData)farm);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLandDryPhysics(BlockPhysicsEvent event) {
        block9: {
            if (Version.isCurrentLower((Version)Version.v1_13_R1)) {
                return;
            }
            if (!Flags.dryup.isGlobalyEnabled()) {
                return;
            }
            if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
                return;
            }
            try {
                if (!event.getChangedType().toString().equalsIgnoreCase("FARMLAND")) {
                    return;
                }
                FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
                if (!perms.has(Flags.dryup, FlagPermissions.FlagCombo.OnlyFalse)) break block9;
                Block b = event.getBlock();
                try {
                    BlockData data = b.getBlockData();
                    Farmland farm = (Farmland)data;
                    if (farm.getMoisture() < 2) {
                        farm.setMoisture(7);
                        b.setBlockData((BlockData)farm);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                event.setCancelled(true);
                return;
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
    }
}

