/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Visualizer {
    private Player player;
    private long start;
    private List<CuboidArea> areas = new ArrayList<CuboidArea>();
    private List<CuboidArea> errorAreas = new ArrayList<CuboidArea>();
    private CMITask mainSchduler = null;
    private CMITask errorScheduler = null;
    private CompletableFuture<Void> baseSheduler = null;
    private boolean once = false;
    private int starting = 0;
    private int currentSkip = 0;
    private List<Location> locations = new ArrayList<Location>();
    private List<Location> errorLocations = new ArrayList<Location>();
    private List<Location> locations2 = new ArrayList<Location>();
    private List<Location> errorLocations2 = new ArrayList<Location>();
    private Location loc = null;

    public Visualizer(Player player) {
        this.player = player;
        this.start = System.currentTimeMillis();
    }

    public void cancelAll() {
        if (this.mainSchduler != null) {
            this.mainSchduler.cancel();
            this.mainSchduler = null;
        }
        if (this.errorScheduler != null) {
            this.errorScheduler.cancel();
            this.errorScheduler = null;
        }
        if (this.baseSheduler != null) {
            this.baseSheduler.cancel(true);
            this.baseSheduler = null;
        }
    }

    public boolean isSameLoc() {
        if (this.loc == null) {
            return false;
        }
        if (this.loc.getWorld() != this.player.getWorld()) {
            return false;
        }
        if (!this.errorAreas.isEmpty() && this.errorLocations.isEmpty()) {
            return false;
        }
        return !(this.loc.distance(this.player.getLocation()) > 1.0);
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public List<CuboidArea> getAreas() {
        return this.areas;
    }

    public void setAreas(ClaimedResidence res) {
        if (res != null) {
            this.areas = Arrays.asList(res.getAreaArray());
        }
    }

    public void setAreas(CuboidArea[] areas) {
        this.areas = Arrays.asList(areas);
    }

    public void setAreas(ArrayList<CuboidArea> areas) {
        this.areas = areas;
    }

    public void setAreas(CuboidArea area2) {
        this.areas = new ArrayList<CuboidArea>();
        this.areas.add(area2);
    }

    public List<CuboidArea> getErrorAreas() {
        return this.errorAreas;
    }

    public void setErrorAreas(ClaimedResidence res) {
        if (res != null) {
            this.errorAreas = Arrays.asList(res.getAreaArray());
        }
    }

    public void setErrorAreas(CuboidArea[] errorAreas) {
        this.errorAreas = Arrays.asList(errorAreas);
    }

    public void setErrorAreas(ArrayList<CuboidArea> errorAreas) {
        this.errorAreas = errorAreas;
    }

    public void setErrorAreas(CuboidArea errorArea) {
        this.errorAreas.add(errorArea);
    }

    public CMITask getScheduler() {
        return this.mainSchduler;
    }

    public void setScheduler(CMITask scheduler) {
        this.mainSchduler = scheduler;
    }

    public CMITask getErrorId() {
        return this.errorScheduler;
    }

    public void setErrorId(CMITask errorId) {
        this.errorScheduler = errorId;
    }

    public boolean isOnce() {
        return this.once;
    }

    public void setOnce(boolean once) {
        this.once = once;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public void setLocations(List<Location> locations) {
        this.locations = locations;
    }

    public List<Location> getLocations2() {
        return this.locations2;
    }

    public void setLocations2(List<Location> locations) {
        this.locations2 = locations;
    }

    public List<Location> getErrorLocations() {
        return this.errorLocations;
    }

    public void setErrorLocations(List<Location> errorLocations) {
        this.errorLocations = errorLocations;
    }

    public List<Location> getErrorLocations2() {
        return this.errorLocations2;
    }

    public void setErrorLocations2(List<Location> errorLocations) {
        this.errorLocations2 = errorLocations;
    }

    public Location getLoc() {
        return this.loc;
    }

    public void setLoc(Location loc) {
        this.loc = loc;
    }

    public int getStarting() {
        return this.starting;
    }

    public void setStarting(int starting) {
        this.starting = starting;
    }

    public CompletableFuture<Void> getBaseSheduler() {
        return this.baseSheduler;
    }

    public void setBaseSheduler(CompletableFuture<Void> scheduler) {
        this.baseSheduler = scheduler;
    }

    public int getCurrentSkip() {
        return this.currentSkip;
    }

    public void setCurrentSkip(int currentSkip) {
        this.currentSkip = currentSkip;
    }

    public void addCurrentSkip() {
        ++this.currentSkip;
    }
}

