/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCEntityInteractEvent;
import com.griefcraft.scripting.event.LWCMagnetPullEvent;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEntityEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEntityEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCProtectionRemovePostEvent;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import com.griefcraft.scripting.event.LWCReloadEvent;
import com.griefcraft.scripting.event.LWCSendLocaleEvent;
import java.util.ArrayList;
import java.util.List;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ResidenceLWCListener
implements Module {
    public static void register(Plugin plugin) {
        LWC.getInstance().getModuleLoader().registerModule(plugin, (Module)new ResidenceLWCListener());
    }

    public static void removeLwcFromResidence(Player player, ClaimedResidence res) {
        if (Version.isCurrentLower((Version)Version.v1_13_R1)) {
            return;
        }
        CMIScheduler.runTaskAsynchronously(() -> {
            long time = System.currentTimeMillis();
            LWC lwc = LWC.getInstance();
            if (lwc == null) {
                return;
            }
            if (res == null) {
                return;
            }
            int i = 0;
            ProtectionCache cache = lwc.getProtectionCache();
            List<Material> list2 = Residence.getInstance().getConfigManager().getLwcMatList();
            ArrayList<Block> block = new ArrayList<Block>();
            try {
                ChunkSnapshot chunkSnapshot = null;
                int chunkX = 0;
                int chunkZ = 0;
                CuboidArea[] cuboidAreaArray = res.getAreaArray();
                int n = cuboidAreaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CuboidArea area2 = cuboidAreaArray[n2];
                    Location low = area2.getLowLocation();
                    Location high = area2.getHighLocation();
                    World world = low.getWorld();
                    int x = low.getBlockX();
                    while (x <= high.getBlockX()) {
                        int z = low.getBlockZ();
                        while (z <= high.getBlockZ()) {
                            BlockData type;
                            int y;
                            int hy = world.getHighestBlockYAt(x, z);
                            if (high.getBlockY() < hy) {
                                hy = high.getBlockY();
                            }
                            int cx = Math.abs(x % 16);
                            int cz = Math.abs(z % 16);
                            if (chunkSnapshot == null || x >> 4 != chunkX || z >> 4 != chunkZ) {
                                if (!world.getBlockAt(x, 0, z).getChunk().isLoaded()) {
                                    world.getBlockAt(x, 0, z).getChunk().load();
                                    chunkSnapshot = world.getBlockAt(x, 0, z).getChunk().getChunkSnapshot(false, false, false);
                                    world.getBlockAt(x, 0, z).getChunk().unload();
                                } else {
                                    chunkSnapshot = world.getBlockAt(x, 0, z).getChunk().getChunkSnapshot();
                                }
                                chunkX = x >> 4;
                                chunkZ = z >> 4;
                            }
                            if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                                y = low.getBlockY();
                                while (y <= hy) {
                                    type = chunkSnapshot.getBlockData(cx, y, cz);
                                    if (list2.contains(type.getMaterial())) {
                                        block.add(world.getBlockAt(x, y, z));
                                    }
                                    ++y;
                                }
                            } else {
                                y = low.getBlockY();
                                while (y <= hy) {
                                    type = CMILocation.getBlockTypeSafe((Location)new Location(world, (double)x, (double)y, (double)z));
                                    if (list2.contains(type)) {
                                        block.add(world.getBlockAt(x, y, z));
                                    }
                                    ++y;
                                }
                            }
                            ++z;
                        }
                        ++x;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Block b : block) {
                Protection prot = cache.getProtection(b);
                if (prot == null) continue;
                prot.remove();
                ++i;
            }
            if (i > 0) {
                Residence.getInstance().msg((CommandSender)player, lm.Residence_LwcRemoved, i, System.currentTimeMillis() - time);
            }
        });
    }

    public void load(LWC lwc) {
    }

    public void onReload(LWCReloadEvent event) {
    }

    public void onAccessRequest(LWCAccessEvent event) {
    }

    public void onDropItem(LWCDropItemEvent event) {
    }

    public void onCommand(LWCCommandEvent event) {
    }

    public void onRedstone(LWCRedstoneEvent event) {
    }

    public void onDestroyProtection(LWCProtectionDestroyEvent event) {
    }

    public void onProtectionInteract(LWCProtectionInteractEvent event) {
    }

    public void onBlockInteract(LWCBlockInteractEvent event) {
    }

    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        boolean hasuse;
        Player player = event.getPlayer();
        FlagPermissions perms = Residence.getInstance().getPermsByLocForPlayer(event.getBlock().getLocation(), player);
        if (!perms.playerHas(player, Flags.container, hasuse = perms.playerHas(player, Flags.use, true)) && !PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0])) {
            event.setCancelled(true);
            Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
        }
    }

    public void onPostRegistration(LWCProtectionRegistrationPostEvent event) {
    }

    public void onPostRemoval(LWCProtectionRemovePostEvent event) {
    }

    public void onSendLocale(LWCSendLocaleEvent event) {
    }

    public void onEntityInteract(LWCEntityInteractEvent arg0) {
    }

    public void onEntityInteractProtection(LWCProtectionInteractEntityEvent arg0) {
    }

    public void onMagnetPull(LWCMagnetPullEvent arg0) {
    }

    public void onRegisterEntity(LWCProtectionRegisterEntityEvent arg0) {
    }
}

