/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.LinkedHashMap;
import java.util.Map;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ResidencePlayerListener1_17
implements Listener {
    private Residence plugin;
    private static int MAX_ENTRIES = 50;
    public static LinkedHashMap<String, BlockData> powder_snow = new LinkedHashMap<String, BlockData>(MAX_ENTRIES + 1, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BlockData> eldest) {
            return this.size() > MAX_ENTRIES;
        }
    };

    public ResidencePlayerListener1_17(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketEntityEvent(PlayerBucketEntityEvent event) {
        Player player = event.getPlayer();
        if (Residence.getInstance().isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getEntity();
        ItemStack iih = CMIItemStack.getItemInMainHand((Player)player);
        if (iih == null) {
            return;
        }
        if (!CMIMaterial.get((ItemStack)iih).equals((Object)CMIMaterial.WATER_BUCKET)) {
            return;
        }
        FlagPermissions perms = Residence.getInstance().getPermsByLocForPlayer(ent.getLocation(), player);
        if (!perms.playerHas(player, Flags.animalkilling, FlagPermissions.FlagCombo.TrueOrNone)) {
            event.setCancelled(true);
            Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.animalkilling});
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractRespawn(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        try {
            if (event.getHand() != EquipmentSlot.HAND && event.getHand() != EquipmentSlot.OFF_HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        if (!CMIMaterial.isCopperBlock((Material)mat)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res == null) {
            return;
        }
        ItemStack item = null;
        item = event.getHand() == EquipmentSlot.OFF_HAND ? CMILib.getInstance().getReflectionManager().getItemInOffHand(player) : CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            return;
        }
        boolean waxed = CMIMaterial.isWaxedCopper((Material)mat);
        if ((CMIMaterial.get((ItemStack)item).equals((Object)CMIMaterial.HONEYCOMB) && !waxed || item.getType().toString().contains("_AXE") && CMIMaterial.getCopperStage((Material)mat) > 1) && !res.isOwner(player) && !res.getPermissions().playerHas(player, Flags.copper, FlagPermissions.FlagCombo.TrueOrNone) && !this.plugin.isResAdminOn(player)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.copper, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLandDryPhysics(BlockPhysicsEvent event) {
        if (!Flags.place.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!event.getSourceBlock().getType().equals((Object)Material.POWDER_SNOW) || event.getBlock().getType().equals((Object)Material.AIR) || event.getBlock().getType().equals((Object)Material.POWDER_SNOW)) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (block.getLocation().getY() == event.getSourceBlock().getLocation().getY()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res == null) {
            return;
        }
        powder_snow.put(event.getSourceBlock().getLocation().toString(), block.getBlockData().clone());
    }
}

