/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.permissions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.PlayerGroup;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.BPermissionsAdapter;
import com.bekvon.bukkit.residence.permissions.LuckPerms5Adapter;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionInfo;
import com.bekvon.bukkit.residence.permissions.PermissionsInterface;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Util.CMIVersionChecker;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PermissionManager {
    protected static PermissionsInterface perms;
    protected LinkedHashMap<String, PermissionGroup> groups;
    protected Map<String, String> playersGroup;
    protected FlagPermissions globalFlagPerms;
    protected HashMap<String, PlayerGroup> groupsMap = new HashMap();
    private PermissionGroup defaultGroup = null;
    private Residence plugin;
    private CMITask autoCacheClear = null;
    private static final int cacheClearDelay = 600;
    private HashMap<UUID, HashMap<String, PermissionInfo>> cache = new HashMap();
    private Runnable cacheClear = () -> this.cache.clear();

    public PermissionManager(Residence plugin) {
        this.plugin = plugin;
        try {
            this.groups = new LinkedHashMap();
            this.playersGroup = Collections.synchronizedMap(new HashMap());
            this.globalFlagPerms = new FlagPermissions();
            this.readConfig();
            this.checkPermissions();
        }
        catch (Exception ex) {
            Logger.getLogger(PermissionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void startCacheClearScheduler() {
        this.autoCacheClear = CMIScheduler.scheduleSyncRepeatingTask((Runnable)this.cacheClear, (long)12000L, (long)12000L);
    }

    public void stopCacheClearScheduler() {
        try {
            if (this.autoCacheClear != null) {
                this.autoCacheClear.cancel();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public FlagPermissions getAllFlags() {
        return this.globalFlagPerms;
    }

    public Map<String, String> getPlayersGroups() {
        return this.playersGroup;
    }

    public Map<String, PermissionGroup> getGroups() {
        return this.groups;
    }

    public PermissionGroup getDefaultGroup() {
        if (this.defaultGroup == null) {
            this.defaultGroup = this.groups.get(Residence.getInstance().getConfigManager().getDefaultGroup().toLowerCase());
        }
        return this.defaultGroup;
    }

    public PermissionGroup getGroupByName(String group) {
        if (!this.groups.containsKey(group = group.toLowerCase())) {
            return this.getDefaultGroup();
        }
        return this.groups.get(group);
    }

    public String getPermissionsGroup(Player player) {
        return this.getPermissionsGroup(player.getName(), player.getWorld().getName()).toLowerCase();
    }

    public String getPermissionsGroup(String player, String world) {
        if (perms == null) {
            return this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        }
        if (!Residence.getInstance().isFullyLoaded()) {
            return this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        }
        try {
            return perms.getPlayerGroup(player, world).toLowerCase();
        }
        catch (Exception e) {
            return this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        }
    }

    public boolean isResidenceAdmin(CommandSender sender) {
        return ResPerm.admin.hasPermission(sender) || sender.isOp() && this.plugin.getConfigManager().getOpsAreAdmins();
    }

    private void checkPermissions() {
        Plugin p;
        Server server2 = this.plugin.getServ();
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Plugin pl = pluginManager.getPlugin("LuckPerms");
        if (pl != null && pl.isEnabled()) {
            Integer ver = CMIVersionChecker.convertVersion((String)pl.getDescription().getVersion());
            if (ver > 50000) {
                perms = new LuckPerms5Adapter();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found LuckPerms5 Plugin!");
                return;
            }
            this.plugin.consoleMessage("&cLuckPerms plugin was found but its outdated");
        }
        if ((p = server2.getPluginManager().getPlugin("Vault")) != null) {
            ResidenceVaultAdapter vault = new ResidenceVaultAdapter(server2);
            if (vault.permissionsOK()) {
                perms = vault;
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found Vault using permissions plugin:" + vault.getPermissionsName());
                return;
            }
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found Vault, but Vault reported no usable permissions system...");
        }
        if ((p = server2.getPluginManager().getPlugin("bPermissions")) != null) {
            perms = new BPermissionsAdapter();
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found bPermissions Plugin!");
            return;
        }
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Permissions plugin NOT FOUND!");
    }

    private void readConfig() {
        Set keys;
        YamlConfiguration groupsFile = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "groups.yml"));
        YamlConfiguration flags2 = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
        String defaultGroup = this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        this.globalFlagPerms = FlagPermissions.parseFromConfigNode("FlagPermission", flags2.getConfigurationSection("Global"));
        ConfigurationSection nodes = groupsFile.getConfigurationSection("Groups");
        if (nodes != null) {
            Set entrys = nodes.getKeys(false);
            int i = 0;
            for (String key : entrys) {
                try {
                    PermissionGroup old = this.groups.getOrDefault(key.toLowerCase(), new PermissionGroup(key.toLowerCase(), null, this.globalFlagPerms, ++i));
                    old.mirrorIn(nodes.getConfigurationSection(key));
                    this.groups.put(key.toLowerCase(), old);
                    List mirrors = nodes.getConfigurationSection(key).getStringList("Mirror");
                    for (String group : mirrors) {
                        this.groups.put(group.toLowerCase(), new PermissionGroup(group.toLowerCase(), nodes.getConfigurationSection(key), this.globalFlagPerms, i));
                    }
                }
                catch (Exception ex) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Error parsing group from config:" + key + " Exception:" + ex);
                }
            }
        }
        if (!this.groups.containsKey(defaultGroup)) {
            this.groups.put(defaultGroup, new PermissionGroup(defaultGroup));
        }
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Loaded (" + this.groups.size() + ") groups");
        if (groupsFile.isConfigurationSection("GroupAssignments") && (keys = groupsFile.getConfigurationSection("GroupAssignments").getKeys(false)) != null) {
            for (String key : keys) {
                this.playersGroup.put(key.toLowerCase(), groupsFile.getString("GroupAssignments." + key, defaultGroup).toLowerCase());
            }
        }
    }

    public boolean hasGroup(String group) {
        group = group.toLowerCase();
        return this.groups.containsKey(group);
    }

    public PermissionsInterface getPermissionsPlugin() {
        return perms;
    }

    public void removeFromCache(Player player) {
        this.cache.remove(player.getUniqueId());
    }

    public PermissionInfo getFromCache(Player player, String perm) {
        HashMap<String, PermissionInfo> old = this.cache.get(player.getUniqueId());
        if (old == null) {
            return null;
        }
        return old.get(perm);
    }

    public PermissionInfo addToCache(Player player, String perm, boolean has, Long delayInMiliseconds) {
        HashMap<String, PermissionInfo> old = this.cache.get(player.getUniqueId());
        if (old == null) {
            old = new HashMap();
        }
        PermissionInfo info2 = new PermissionInfo(perm, delayInMiliseconds);
        info2.setLastChecked(System.currentTimeMillis());
        info2.setEnabled(has);
        old.put(perm, info2);
        this.cache.put(player.getUniqueId(), old);
        return info2;
    }

    public PermissionAttachmentInfo getSetPermission(CommandSender sender, String perm) {
        if (sender instanceof Player) {
            for (PermissionAttachmentInfo permission : ((Player)sender).getEffectivePermissions()) {
                if (!permission.getPermission().equalsIgnoreCase(perm)) continue;
                return permission;
            }
        }
        return null;
    }

    public boolean isSetPermission(CommandSender sender, String perm) {
        if (sender instanceof Player) {
            return this.isSetPermission((Player)sender, perm);
        }
        return true;
    }

    public boolean isSetPermission(Player player, String perm) {
        return player.hasPermission(new Permission(perm, PermissionDefault.FALSE));
    }

    @Deprecated
    public PermissionInfo getPermissionInfo(Player player, String perm, Long delayInMiliseconds) {
        return this.getPermissionInfo(player, perm, false, delayInMiliseconds);
    }

    @Deprecated
    public PermissionInfo getPermissionInfo(Player player, ResPerm perm) {
        return this.getPermissionInfo(player, perm, (Long)1000L);
    }

    public PermissionInfo getPermissionInfo(UUID uuid, ResPerm perm) {
        return this.getPermissionInfo(uuid, perm, (Long)1000L);
    }

    @Deprecated
    public PermissionInfo getPermissionInfo(Player player, ResPerm perm, Long delayInMiliseconds) {
        return this.getPermissionInfo(player.getUniqueId(), perm, delayInMiliseconds);
    }

    public PermissionInfo getPermissionInfo(UUID uuid, ResPerm perm, Long delayInMiliseconds) {
        String permission = perm.getPermission(" ");
        if (permission.endsWith(" ")) {
            permission = permission.replace(" ", "");
        }
        if (permission.endsWith(".")) {
            permission = permission.substring(0, permission.length() - 1);
        }
        return this.getPermissionInfo(uuid, permission, false, delayInMiliseconds);
    }

    @Deprecated
    public PermissionInfo getPermissionInfo(Player player, String perm) {
        return this.getPermissionInfo(player, perm, false, (Long)1000L);
    }

    @Deprecated
    public PermissionInfo getPermissionInfo(Player player, String perm, boolean force) {
        return this.getPermissionInfo(player, perm, force, (Long)1000L);
    }

    @Deprecated
    public PermissionInfo getPermissionInfo(Player player, String perm, boolean force, Long delay) {
        return this.getPermissionInfo(player.getUniqueId(), perm, force, delay);
    }

    public PermissionInfo getPermissionInfo(UUID uuid, String perm, boolean force, Long delay) {
        Player player;
        String pref;
        PermissionInfo p;
        if (!(perm = perm.toLowerCase()).endsWith(".")) {
            perm = String.valueOf(perm) + ".";
        }
        if (uuid == null) {
            return new PermissionInfo(perm, delay);
        }
        HashMap<String, PermissionInfo> c = this.cache.get(uuid);
        if (c == null) {
            c = new HashMap();
        }
        if ((p = c.get(perm)) == null) {
            p = new PermissionInfo(perm, delay);
        }
        if (delay != null) {
            p.setDelay(delay);
        }
        String string = pref = perm.contains(".") ? perm.split("\\.")[0] : perm;
        if ((force || p.isTimeToRecalculate()) && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
            HashMap<String, Boolean> all = PermissionManager.getAll(player, pref);
            Double max = null;
            Double min = null;
            for (Map.Entry<String, Boolean> uno : all.entrySet()) {
                if (!uno.getValue().booleanValue() || !uno.getKey().startsWith(perm)) continue;
                String value = uno.getKey().replace(perm, "");
                p.addValue(value);
                try {
                    double t = Double.parseDouble(value);
                    if (max == null || t > max) {
                        max = t;
                    }
                    if (min != null && !(t < min)) continue;
                    min = t;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            p.setMaxValue(max);
            p.setMinValue(min);
        }
        p.setLastChecked(System.currentTimeMillis());
        c.put(perm, p);
        this.cache.put(uuid, c);
        return p;
    }

    private static HashMap<String, Boolean> getAll(Player player, String pref) {
        pref = pref.endsWith(".") ? pref : String.valueOf(pref) + ".";
        HashMap<String, Boolean> mine = new HashMap<String, Boolean>();
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            if (!permission.getPermission().startsWith(pref)) continue;
            mine.put(permission.getPermission(), permission.getValue());
        }
        return mine;
    }

    public static enum ResPerm {
        chatcolor("Allows to change residence chat color"),
        chatprefix("Allows to change residence chat prefix"),
        chatkick("Allows to kick player from residence chat"),
        permisiononerror("Allows to see missing permission on error message"),
        command_message_enter("Allows to change residence enter message"),
        command_message_leave("Allows to change residence leave message"),
        command_message_enter_remove("Allows to remove residence enter message"),
        command_message_leave_remove("Allows to remove residence leave message"),
        cleanbypass("Prevents residence from ebing removed on automatic cleanup"),
        worldguard_$1("Allows to create residence inside region", "region"),
        flag_$1("Gives access to defined flag", "flagName"),
        tpdelaybypass("Allows to bypass teleport delay"),
        backup("Allows to use backup flag to save residence into schematics"),
        admin_tp("Allows teleportation into residence where its not allowed"),
        topadmin("Defines as residence top admin"),
        admin("Defines as residence admin"),
        admin_move("Allows movement in residence where its not allowed"),
        newguyresidence("Creates residence on first chest place"),
        bypass_ignorey("Allows to ignore Y corrdiante restrictions"),
        bypass_ignoreyinsubzone("Allows to ignore subzone limitations"),
        bypass_destroy("Allows to bypass destroy flag"),
        bypass_build("Allows to bypass build flag"),
        bypass_container("Allows to bypass container flag"),
        bypass_use("Allows to bypass use flag"),
        bypass_door("Allows to bypass door flag"),
        bypass_button("Allows to bypass button flag"),
        bypass_fly("Allows to bypass fly flag"),
        bypass_nofly("Allows to bypass nofly flag"),
        bypass_tp("Allows to bypass command flag"),
        bypass_command("Allows to bypass command flag"),
        bypass_itempickup("Allows to bypass itempickup flag"),
        bypass_itemdrop("Allows to bypass itemdrop flag"),
        buy("Allows to buy residence"),
        sell("Allows to sell residence"),
        max_res_x_$1("Defines residence size limit on X axis", "number"),
        max_res_z_$1("Defines residence size limit on Z axis", "number"),
        max_res_unlimited("Defines residence limit as unlimited"),
        max_res_$1("Defines residence limit", "number"),
        max_subzones_unlimited("Defines subzone limit as unlimited"),
        max_subzones_$1("Defines subzone limit", "number"),
        max_subzonedepth_unlimited("Defines subzone depth limit as unlimited"),
        max_subzonedepth_$1("Defines subzone depth limit", "number"),
        max_rents_unlimited("Defines residence rent limit as unlimited"),
        max_rents_$1("Defines residence rent limit", "number"),
        group_$1("Defines players residence group", "groupName"),
        market_evict("Allows to evict players from rented residences"),
        rename("Allows to rename residence"),
        select("Allows to select residence area"),
        select_auto_others("Allows to toggle auto selection for others"),
        resize("Allows to resize residence"),
        create("Allows to create residence"),
        create_subzone("Allows to create residence subzones"),
        randomtp("Allows to use rt command"),
        randomtp_admin("Allows to use rt command on another player"),
        randomtp_cooldownbypass("Allows to bypass random teleport command cooldown"),
        randomtp_delaybypass("Allows to bypass random teleport command delay"),
        delete("Allows to delete residence"),
        delete_subzone("Allows to delete subzone"),
        command_kick_bypass("Allows to bypass kick from residence"),
        command_contract_subzone("Allows to contract subzones"),
        command_expand_subzone("Allows to expand subzones"),
        versioncheck("Shows when we have new version of plugin"),
        command_$1("Gives access to particular command", "commandName"),
        command_$1_others("Allows to perform command on another player", "commandName");

        private Boolean show = true;
        private String desc;
        private String[] wars;
        private String fixedPermission = null;

        private ResPerm(String desc, Boolean show2) {
            this.desc = desc;
            this.show = show2;
        }

        private ResPerm(String desc) {
            this.desc = desc;
        }

        private ResPerm(String desc, String ... wars) {
            this.desc = desc;
            this.wars = wars;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getPermissionForShow() {
            return this.getPermissionForShow(false);
        }

        public String getPermissionForShow(boolean cmd2) {
            if (this.getWars() == null) {
                return this.getPermission("");
            }
            String[] w = new String[this.getWars().length];
            int i = 0;
            while (i < this.getWars().length) {
                w[i] = String.valueOf(Residence.getInstance().getLM().getMessage(lm.Permissions_variableColor, new Object[0])) + "[" + this.getWars()[i] + "]" + (!cmd2 ? Residence.getInstance().getLM().getMessage(lm.Permissions_permissionColor, new Object[0]) : Residence.getInstance().getLM().getMessage(lm.Permissions_cmdPermissionColor, new Object[0]));
                ++i;
            }
            return this.getPermission(w);
        }

        public String getPermission() {
            return this.getPermission("");
        }

        public String getPermission(String ... extra) {
            if (this.fixedPermission != null) {
                return this.fixedPermission;
            }
            String perm = this.name().replace("_", ".");
            int i = 0;
            String[] stringArray = extra;
            int n = extra.length;
            int n2 = 0;
            while (n2 < n) {
                String one = stringArray[n2];
                ++i;
                if (one != null && !one.isEmpty()) {
                    perm = perm.replace("$" + i, one.toLowerCase());
                }
                ++n2;
            }
            perm = perm.replace("$star", "*");
            if (!this.name().contains("$")) {
                this.fixedPermission = "residence." + perm;
            }
            return "residence." + perm;
        }

        public boolean hasPermission(CommandSender sender) {
            return this.hasPermission(sender, false, new String[0]);
        }

        public boolean hasPermission(CommandSender sender, Integer ... extra) {
            String[] ex = new String[extra.length];
            int i = 0;
            while (i < extra.length) {
                ex[i] = String.valueOf(extra[i]);
                ++i;
            }
            return this.hasPermission(sender, false, ex);
        }

        public boolean hasPermission(CommandSender sender, lm lm2) {
            return this.hasPermission(sender, true, true, null, lm2, new String[0]);
        }

        public boolean hasPermission(CommandSender sender, lm lm2, String ... extra) {
            return this.hasPermission(sender, true, true, null, lm2, extra);
        }

        public boolean hasPermission(CommandSender sender, Flags flag) {
            return this.hasPermission(sender, false, flag.toString());
        }

        public boolean hasPermission(CommandSender sender, String ... extra) {
            return this.hasPermission(sender, false, extra);
        }

        public boolean hasPermission(CommandSender sender, Long delay, String ... extra) {
            return this.hasPermission(sender, false, true, delay, null, extra);
        }

        public boolean hasPermission(CommandSender sender, boolean inform, String ... extra) {
            return this.hasPermission(sender, inform, true, extra);
        }

        public boolean hasPermission(CommandSender sender, boolean inform, boolean informConsole, String ... extra) {
            return this.hasPermission(sender, inform, informConsole, (Long)null, (lm)null, extra);
        }

        public boolean hasPermission(CommandSender sender, boolean inform, Long delayInMiliSeconds) {
            return this.hasPermission(sender, inform, true, delayInMiliSeconds, null, new String[0]);
        }

        public boolean hasPermission(CommandSender sender, boolean inform, boolean informConsole, Long delay, lm lms, String ... extra) {
            if (sender == null) {
                return false;
            }
            if (!(sender instanceof Player)) {
                return true;
            }
            String perm = this.getPermission(extra);
            Player player = (Player)sender;
            PermissionInfo info2 = Residence.getInstance().getPermissionManager().getFromCache(player, perm);
            boolean has = false;
            if (info2 != null && info2.getDelay() + info2.getLastChecked() > System.currentTimeMillis()) {
                has = info2.isEnabled();
            } else {
                has = sender.hasPermission(perm);
                Residence.getInstance().getPermissionManager().addToCache(player, perm, has, delay == null ? 200L : delay);
            }
            if (!has && inform) {
                boolean showPerm = permisiononerror.hasPermission(sender, 50000L, new String[0]);
                RawMessage rm = new RawMessage();
                rm.addText(Residence.getInstance().getLM().getMessage(lms == null ? lm.General_NoPermission : lms, new Object[0])).addHover(showPerm ? perm : null);
                rm.show(sender);
                ResPerm.informConsole(sender, perm, informConsole);
            }
            return has;
        }

        private static void informConsole(CommandSender sender, String permission, boolean informConsole) {
            if (informConsole) {
                ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                Residence.getInstance().msg((CommandSender)console, Residence.getInstance().getLM().getMessage(lm.General_NoPermission, "[playerName]", sender.getName(), "[permission]", permission));
            }
        }

        public boolean hasSetPermission(CommandSender sender, String ... extra) {
            return this.hasSetPermission(sender, false, extra);
        }

        public boolean hasSetPermission(CommandSender sender, boolean inform, String ... extra) {
            return ResPerm.hasSetPermission(sender, this.getPermission(extra), inform);
        }

        public static boolean hasSetPermission(CommandSender sender, String perm, boolean inform) {
            boolean has = Residence.getInstance().getPermissionManager().isSetPermission(sender, perm);
            if (!has && inform) {
                boolean showPerm = permisiononerror.hasPermission(sender);
                RawMessage rm = new RawMessage();
                rm.addText(Residence.getInstance().getLM().getMessage(lm.General_NoPermission, new Object[0])).addHover(showPerm ? perm : null);
                rm.show(sender);
                ResPerm.informConsole(sender, perm, true);
            }
            return has;
        }

        public String[] getWars() {
            return this.wars;
        }

        public void setWars(String[] wars) {
            this.wars = wars;
        }

        public Boolean getShow() {
            return this.show;
        }

        public void setShow(Boolean show2) {
            this.show = show2;
        }

        public static boolean hasPermission(CommandSender sender, String permision, Boolean output) {
            return ResPerm.hasPermission(sender, permision, output, true);
        }

        public static boolean hasPermission(CommandSender sender, String permision, Boolean output, boolean informConsole) {
            if (!(sender instanceof Player)) {
                return true;
            }
            Player player = (Player)sender;
            if (player.hasPermission(permision)) {
                return true;
            }
            if (output.booleanValue()) {
                boolean showPerm = permisiononerror.hasPermission(sender);
                RawMessage rm = new RawMessage();
                rm.addText(Residence.getInstance().getLM().getMessage(lm.General_NoPermission, new Object[0])).addHover(showPerm ? permision : null);
                rm.show(sender);
                ResPerm.informConsole(sender, permision, informConsole);
            }
            return false;
        }
    }
}

