/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.pl3xmap;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.TransactionManager;
import com.bekvon.bukkit.residence.economy.rent.RentManager;
import com.bekvon.bukkit.residence.pl3xmap.Pl3xMapLayer;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Fill;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Stroke;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class Pl3xMapManager {
    Residence plugin;
    public Pl3xMap api;
    private CMITask scheduler = null;
    HashMap<String, SimpleLayer> providers = new HashMap();

    public Pl3xMapManager(Residence plugin) {
        this.plugin = plugin;
    }

    public void fireUpdateAdd(ClaimedResidence res, int deep) {
        if (this.api == null) {
            return;
        }
        if (res == null) {
            return;
        }
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
        this.scheduler = CMIScheduler.runTaskLater(() -> this.handleResidenceAdd(res.getName(), res, deep), (long)10L);
    }

    public void fireUpdateRemove(ClaimedResidence res, int deep) {
        if (this.api == null) {
            return;
        }
        if (res == null) {
            return;
        }
        this.handleResidenceRemove(res.getName(), res, deep);
    }

    private String formatInfoWindow(String resid, ClaimedResidence res, String resName) {
        if (res == null) {
            return null;
        }
        if (res.getName() == null) {
            return null;
        }
        if (res.getOwner() == null) {
            return null;
        }
        String v = "<div class=\"regioninfo\"><div class=\"infowindow\"><span style=\"font-size:140%;font-weight:bold;\">%regionname%</span><br /> " + CMIChatColor.stripColor((String)this.plugin.msg(lm.General_Owner, "")) + "<span style=\"font-weight:bold;\">%playerowners%</span><br />";
        if (this.plugin.getConfigManager().Pl3xMapShowFlags) {
            ResidencePermissions residencePermissions = res.getPermissions();
            FlagPermissions gRD = Residence.getInstance().getConfigManager().getGlobalResidenceDefaultFlags();
            StringBuilder flgs = new StringBuilder();
            for (Map.Entry<String, Boolean> one : residencePermissions.getFlags().entrySet()) {
                if (Residence.getInstance().getConfigManager().Pl3xMapExcludeDefaultFlags && gRD.isSet(one.getKey()) && gRD.getFlags().get(one.getKey()).equals(one.getValue())) continue;
                if (!flgs.toString().isEmpty()) {
                    flgs.append("<br/>");
                }
                flgs.append(String.valueOf(one.getKey()) + ": " + one.getValue());
            }
            if (!flgs.toString().isEmpty()) {
                v = String.valueOf(v) + CMIChatColor.stripColor((String)this.plugin.msg(lm.General_ResidenceFlags, "")) + "<br /><span style=\"font-weight:bold;\">%flags%</span>";
                v = v.replace("%flags%", flgs.toString());
            }
        }
        v = String.valueOf(v) + "</div></div>";
        if (this.plugin.getRentManager().isForRent(res.getName())) {
            v = "<div class=\"regioninfo\"><div class=\"infowindow\">" + CMIChatColor.stripColor((String)this.plugin.msg(lm.Rentable_Land, "")) + "<span style=\"font-size:140%;font-weight:bold;\">%regionname%</span><br />" + CMIChatColor.stripColor((String)this.plugin.msg(lm.General_Owner, "")) + "<span style=\"font-weight:bold;\">%playerowners%</span><br />" + CMIChatColor.stripColor((String)this.plugin.msg(lm.Residence_RentedBy, "")) + "<span style=\"font-weight:bold;\">%renter%</span><br /> " + CMIChatColor.stripColor((String)this.plugin.msg(lm.General_LandCost, "")) + "<span style=\"font-weight:bold;\">%rent%</span><br /> " + CMIChatColor.stripColor((String)this.plugin.msg(lm.Rent_Days, "")) + "<span style=\"font-weight:bold;\">%rentdays%</span><br /> " + CMIChatColor.stripColor((String)this.plugin.msg(lm.Rentable_AllowRenewing, "")) + "<span style=\"font-weight:bold;\">%renew%</span><br /> " + CMIChatColor.stripColor((String)this.plugin.msg(lm.Rent_Expire, "")) + "<span style=\"font-weight:bold;\">%expire%</span></div></div>";
        }
        if (this.plugin.getTransactionManager().isForSale(res.getName())) {
            v = "<div class=\"regioninfo\"><div class=\"infowindow\">" + CMIChatColor.stripColor((String)this.plugin.msg(lm.Economy_LandForSale, " ")) + "<span style=\"font-size:140%;font-weight:bold;\">%regionname%</span><br /> " + CMIChatColor.stripColor((String)this.plugin.msg(lm.General_Owner, "")) + "<span style=\"font-weight:bold;\">%playerowners%</span><br />" + CMIChatColor.stripColor((String)this.plugin.msg(lm.Economy_SellAmount, "")) + "<span style=\"font-weight:bold;\">%price%</span><br /></div></div>";
        }
        v = v.replace("%regionname%", resName);
        v = v.replace("%playerowners%", res.getOwner());
        String m = res.getEnterMessage();
        v = v.replace("%entermsg%", m != null ? m : "");
        m = res.getLeaveMessage();
        v = v.replace("%leavemsg%", m != null ? m : "");
        RentManager rentmgr = this.plugin.getRentManager();
        TransactionManager transmgr = this.plugin.getTransactionManager();
        if (rentmgr.isForRent(res.getName())) {
            long time;
            boolean isrented = rentmgr.isRented(resid);
            v = v.replace("%isrented%", Boolean.toString(isrented));
            String id = "";
            if (isrented) {
                id = rentmgr.getRentingPlayer(resid);
            }
            v = v.replace("%renter%", id);
            v = v.replace("%rent%", String.valueOf(rentmgr.getCostOfRent(resid)));
            v = v.replace("%rentdays%", String.valueOf(rentmgr.getRentDays(resid)));
            boolean renew = rentmgr.getRentableRepeatable(resid);
            v = v.replace("%renew%", String.valueOf(renew));
            String expire = "";
            if (isrented && (time = rentmgr.getRentedLand((String)resid).endTime) != 0L) {
                expire = GetTime.getTime(time);
            }
            v = v.replace("%expire%", expire);
        }
        if (transmgr.isForSale(res.getName())) {
            boolean forsale = transmgr.isForSale(resid);
            v = v.replace("%isforsale%", Boolean.toString(transmgr.isForSale(resid)));
            String price = "";
            if (forsale) {
                price = Integer.toString(transmgr.getSaleAmount(resid));
            }
            v = v.replace("%price%", price);
        }
        return v;
    }

    private boolean isVisible(String id, String worldname) {
        List<String> visible = this.plugin.getConfigManager().Pl3xMapVisibleRegions;
        List<String> hidden = this.plugin.getConfigManager().Pl3xMapHiddenRegions;
        if (visible != null && visible.size() > 0 && !visible.contains(id) && !visible.contains("world:" + worldname)) {
            return false;
        }
        return hidden == null || hidden.size() <= 0 || !hidden.contains(id) && !hidden.contains("world:" + worldname);
    }

    private int fillColor(String resid) {
        if (this.plugin.getRentManager().isForRent(resid) && !this.plugin.getRentManager().isRented(resid)) {
            return this.plugin.getConfigManager().Pl3xMapFillForRent;
        }
        if (this.plugin.getRentManager().isForRent(resid) && this.plugin.getRentManager().isRented(resid)) {
            return this.plugin.getConfigManager().Pl3xMapFillRented;
        }
        if (this.plugin.getTransactionManager().isForSale(resid)) {
            return this.plugin.getConfigManager().Pl3xMapFillForSale;
        }
        return this.plugin.getConfigManager().Pl3xFillColor;
    }

    private void handleResidenceAdd(String resid, ClaimedResidence res, int depth) {
        if (res == null) {
            return;
        }
        if (res.getPermissions().has("hidden", false) && this.plugin.getConfigManager().Pl3xMapHideHidden) {
            this.fireUpdateRemove(res, depth);
            return;
        }
        org.bukkit.World world = Bukkit.getWorld((String)res.getPermissions().getWorldName());
        World mWorld = (World)this.api.getWorldRegistry().get(world.getName());
        if (mWorld == null) {
            return;
        }
        Registry registry = mWorld.getLayerRegistry();
        SimpleLayer provider = this.providers.get(res.getPermissions().getWorldName());
        if (registry.has("Residence")) {
            provider = (SimpleLayer)registry.get("Residence");
            this.providers.put(res.getPermissions().getWorldName(), provider);
        }
        if (provider == null) {
            Pl3xMapLayer prov = new Pl3xMapLayer(mWorld);
            mWorld.getLayerRegistry().register("Residence", (Keyed)prov);
            this.providers.put(res.getPermissions().getWorldName(), (SimpleLayer)prov);
        }
        if ((provider = this.providers.get(res.getPermissions().getWorldName())) == null) {
            return;
        }
        for (Map.Entry<String, CuboidArea> oneArea : res.getAreaMap().entrySet()) {
            String id = String.valueOf(oneArea.getKey()) + "." + resid;
            String resName = res.getName();
            if (res.getAreaMap().size() > 1) {
                resName = String.valueOf(res.getName()) + " (" + oneArea.getKey() + ")";
            }
            String desc = this.formatInfoWindow(resid, res, resName);
            if (!this.isVisible(resid, res.getPermissions().getWorldName())) {
                return;
            }
            Location l0 = oneArea.getValue().getLowLocation();
            Location l1 = oneArea.getValue().getHighLocation();
            Point p1 = Point.of((double)l0.getX(), (double)l0.getZ());
            Point p2 = Point.of((double)(l1.getX() + 1.0), (double)(l1.getZ() + 1.0));
            Rectangle marker = Marker.rectangle((String)id, (Point)p1, (Point)p2);
            Options options = new Options();
            Tooltip tooltip = new Tooltip();
            tooltip.setContent(desc);
            options.setTooltip(tooltip);
            Fill fill = new Fill();
            fill.setColor(Integer.valueOf(this.fillColor(resid)));
            fill.setType(Fill.Type.NONZERO);
            options.setFill(fill);
            Stroke stroke = new Stroke();
            stroke.setColor(Integer.valueOf(this.plugin.getConfigManager().Pl3xBorderColor));
            stroke.setWeight(Integer.valueOf(this.plugin.getConfigManager().Pl3xMapBorderWeight));
            options.setStroke(stroke);
            marker.setOptions(options);
            provider.addMarker((Marker)marker);
            if (depth > this.plugin.getConfigManager().Pl3xMapLayerSubZoneDepth) continue;
            List<ClaimedResidence> subids = res.getSubzones();
            for (ClaimedResidence one : subids) {
                try {
                    this.handleResidenceAdd(one.getName(), one, depth + 1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void handleResidenceRemove(String resid, ClaimedResidence res, int depth) {
        if (resid == null) {
            return;
        }
        if (res == null) {
            return;
        }
        org.bukkit.World world = Bukkit.getWorld((String)res.getPermissions().getWorldName());
        World mWorld = (World)this.api.getWorldRegistry().get(world.getName());
        if (mWorld == null) {
            return;
        }
        Registry registry = mWorld.getLayerRegistry();
        SimpleLayer provider = this.providers.get(res.getPermissions().getWorldName());
        if (registry.has("Residence")) {
            provider = (SimpleLayer)registry.get("Residence");
            this.providers.put(res.getPermissions().getWorldName(), provider);
        }
        if (provider == null) {
            return;
        }
        for (Map.Entry<String, CuboidArea> oneArea : res.getAreaMap().entrySet()) {
            String id = String.valueOf(oneArea.getKey()) + "." + resid;
            provider.removeMarker(id);
            if (depth > this.plugin.getConfigManager().Pl3xMapLayerSubZoneDepth + 1) continue;
            List<ClaimedResidence> subids = res.getSubzones();
            for (ClaimedResidence one : subids) {
                this.handleResidenceRemove(one.getName(), one, depth + 1);
            }
        }
    }

    public void activate() {
        CMIMessages.consoleMessage((String)(String.valueOf(Residence.getInstance().getPrefix()) + " Pl3xMap residence activated!"));
        for (Map.Entry<String, ClaimedResidence> one : this.plugin.getResidenceManager().getResidences().entrySet()) {
            this.fireUpdateAdd(one.getValue(), one.getValue().getSubzoneDeep());
            try {
                this.handleResidenceAdd(one.getValue().getName(), one.getValue(), one.getValue().getSubzoneDeep());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

