/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class WorldEditSelectionManager
extends SelectionManager {
    public WorldEditSelectionManager(Server serv, Residence plugin) {
        super(serv, plugin);
    }

    @Override
    public boolean worldEdit(Player player) {
        block4: {
            WorldEditPlugin wep = (WorldEditPlugin)this.server.getPluginManager().getPlugin("WorldEdit");
            try {
                Selection sel = (Selection)wep.getClass().getMethod("getSelection", Player.class).invoke((Object)wep, player);
                if (sel == null) break block4;
                Location pos1 = sel.getMinimumPoint();
                Location pos2 = sel.getMaximumPoint();
                try {
                    CuboidRegion region = (CuboidRegion)sel.getRegionSelector().getRegion();
                    pos1 = new Location(player.getWorld(), (double)region.getPos1().getX(), (double)region.getPos1().getY(), (double)region.getPos1().getZ());
                    pos2 = new Location(player.getWorld(), (double)region.getPos2().getX(), (double)region.getPos2().getY(), (double)region.getPos2().getZ());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateLocations(player, pos1, pos2);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean worldEditUpdate(Player player) {
        if (!this.hasPlacedBoth(player)) {
            return false;
        }
        CuboidSelection selection = new CuboidSelection(player.getWorld(), this.getPlayerLoc1(player), this.getPlayerLoc2(player));
        try {
            this.plugin.getWorldEdit().getClass().getMethod("setSelection", Player.class, Selection.class).invoke((Object)this.plugin.getWorldEdit(), player, selection);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void placeLoc1(Player player, Location loc, boolean show2) {
        super.placeLoc1(player, loc, show2);
        this.worldEditUpdate(player);
    }

    @Override
    public void placeLoc2(Player player, Location loc, boolean show2) {
        super.placeLoc2(player, loc, show2);
        this.worldEditUpdate(player);
    }

    @Override
    public void sky(Player player, boolean resadmin2) {
        super.sky(player, resadmin2);
        this.worldEditUpdate(player);
    }

    @Override
    public void bedrock(Player player, boolean resadmin2) {
        super.bedrock(player, resadmin2);
        this.worldEditUpdate(player);
    }

    @Override
    public void modify(Player player, boolean shift, double amount) {
        super.modify(player, shift, amount);
        this.worldEditUpdate(player);
    }

    @Override
    public void selectChunk(Player player) {
        super.selectChunk(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void showSelectionInfo(Player player) {
        super.showSelectionInfo(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void regenerate(CuboidArea area2) {
        CuboidSelection selection = new CuboidSelection(area2.getWorld(), area2.getLowLocation(), area2.getHighLocation());
        try {
            Region region = selection.getRegionSelector().getRegion();
            region.getWorld().regenerate(region, WorldEdit.getInstance().getEditSessionFactory().getEditSession(region.getWorld(), -1));
        }
        catch (IncompleteRegionException incompleteRegionException) {
            // empty catch block
        }
    }
}

