/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.WorldGuardInterface;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldGuard7Util
implements WorldGuardInterface {
    private Residence plugin;

    public WorldGuard7Util(Residence residence) {
        this.plugin = residence;
    }

    @Override
    public ProtectedRegion getRegion(Player player, CuboidArea area2) {
        if (area2 == null) {
            return null;
        }
        if (this.plugin.getWorldGuard() == null) {
            return null;
        }
        if (this.plugin.getWorldEdit() == null) {
            return null;
        }
        Location loc1 = area2.getLowLocation();
        Location loc2 = area2.getHighLocation();
        String id = "icp__tempregion";
        try {
            BlockVector3 min = BlockVector3.at((double)loc1.getX(), (double)loc1.getY(), (double)loc1.getZ());
            BlockVector3 max = BlockVector3.at((double)loc2.getX(), (double)loc2.getY(), (double)loc2.getZ());
            ProtectedCuboidRegion region = new ProtectedCuboidRegion(id, min, max);
            RegionManager mgr = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)loc1.getWorld()));
            ApplicableRegionSet regions = mgr.getApplicableRegions((ProtectedRegion)region);
            for (ProtectedRegion one : regions.getRegions()) {
                if (PermissionManager.ResPerm.worldguard_$1.hasPermission((CommandSender)player, one.getId())) continue;
                return one;
            }
        }
        catch (Exception | IncompatibleClassChangeError throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isSelectionInArea(Player player) {
        if (this.plugin.getWorldGuard() == null) {
            return false;
        }
        ProtectedRegion Region2 = this.getRegion(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
        if (Region2 == null) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.Select_WorldGuardOverlap, Region2.getId());
        Location lowLoc = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player).getWorld(), (double)Region2.getMinimumPoint().getBlockX(), (double)Region2.getMinimumPoint().getBlockY(), (double)Region2.getMinimumPoint().getBlockZ());
        Location highLoc = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player).getWorld(), (double)Region2.getMaximumPoint().getBlockX(), (double)Region2.getMaximumPoint().getBlockY(), (double)Region2.getMaximumPoint().getBlockZ());
        Visualizer v = new Visualizer(player);
        v.setAreas(this.plugin.getSelectionManager().getSelectionCuboid(player));
        v.setErrorAreas(new CuboidArea(lowLoc, highLoc));
        this.plugin.getSelectionManager().showBounds(player, v);
        return true;
    }
}

