/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.signsStuff;

import com.bekvon.bukkit.residence.CommentedYamlConfiguration;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.signsStuff.SignInfo;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SignUtil {
    private Residence plugin;
    public SignInfo Signs = new SignInfo();

    public SignUtil(Residence plugin) {
        this.plugin = plugin;
    }

    public SignInfo getSigns() {
        return this.Signs;
    }

    public int updateAllSigns() {
        ConcurrentHashMap<String, Signs> temp = new ConcurrentHashMap<String, Signs>();
        temp.putAll(this.Signs.GetAllSigns());
        for (Map.Entry one : temp.entrySet()) {
            this.SignUpdate((Signs)one.getValue());
        }
        this.saveSigns();
        return temp.size();
    }

    public void LoadSigns() {
        this.Signs.GetAllSigns().clear();
        File file = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration f = YamlConfiguration.loadConfiguration((File)file);
        if (!f.isConfigurationSection("Signs")) {
            return;
        }
        ConfigurationSection ConfCategory = f.getConfigurationSection("Signs");
        ArrayList categoriesList = new ArrayList(ConfCategory.getKeys(false));
        if (categoriesList.size() == 0) {
            return;
        }
        for (String category : categoriesList) {
            ConfigurationSection NameSection = ConfCategory.getConfigurationSection(category);
            Signs newTemp = new Signs();
            ClaimedResidence res = this.plugin.getResidenceManager().getByName(NameSection.contains("Residence") ? NameSection.getString("Residence") : NameSection.getString("Res"));
            if (res == null) continue;
            newTemp.setResidence(res);
            if (NameSection.contains("World")) {
                World w = Bukkit.getWorld((String)NameSection.getString("World"));
                if (w == null) continue;
                double x = NameSection.getDouble("X");
                double y = NameSection.getDouble("Y");
                double z = NameSection.getDouble("Z");
                Location loc = new Location(w, x, y, z);
                newTemp.setLocation(loc);
            } else {
                Location loc = Utils.convertStringToLocation(NameSection.getString("Loc"));
                newTemp.setLocation(loc);
            }
            this.Signs.addSign(newTemp);
        }
    }

    public void saveSigns() {
        File f = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        CommentedYamlConfiguration writer = new CommentedYamlConfiguration();
        conf.options().copyDefaults(true);
        writer.addComment("Signs", "DO NOT EDIT THIS FILE BY HAND!");
        if (!conf.isConfigurationSection("Signs")) {
            conf.createSection("Signs");
        }
        int i = 0;
        for (Map.Entry<String, Signs> one : new ConcurrentHashMap<String, Signs>(this.Signs.GetAllSigns()).entrySet()) {
            Signs s = one.getValue();
            String path = "Signs." + ++i;
            writer.set(String.valueOf(path) + ".Res", s.getResidence().getName());
            writer.set(String.valueOf(path) + ".Loc", Utils.convertLocToStringTiny(s.getLocation()));
        }
        try {
            writer.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Signs getSignFromLoc(Location loc) {
        return this.getSigns().getResSign(loc);
    }

    public void CheckSign(ClaimedResidence res, int time) {
        CMIScheduler.runTaskLater(() -> this.CheckSign(res), (long)((long)time * 1L));
    }

    public void CheckSign(ClaimedResidence res) {
        for (Signs one : res.getSignsInResidence()) {
            if (res != one.getResidence()) continue;
            this.SignUpdate(one);
        }
        this.saveSigns();
    }

    @Deprecated
    public void removeSign(String res) {
        if (res != null) {
            this.removeSign(this.plugin.getResidenceManager().getByName(res));
        }
    }

    public void removeSign(ClaimedResidence res) {
        for (Signs one : res.getSignsInResidence()) {
            if (res != one.getResidence()) continue;
            this.SignUpdate(one);
        }
    }

    public void updateSignResName(ClaimedResidence res) {
        for (Signs one : res.getSignsInResidence()) {
            if (res != one.getResidence()) continue;
            this.SignUpdate(one);
            this.saveSigns();
            break;
        }
    }

    public boolean SignUpdate(Signs Sign2) {
        ClaimedResidence res = Sign2.getResidence();
        if (res == null) {
            return false;
        }
        boolean ForSale = res.isForSell();
        boolean ForRent = res.isForRent();
        Location nloc = Sign2.getLocation();
        if (nloc == null) {
            this.Signs.removeSign(Sign2);
            res.getSignsInResidence().remove(Sign2);
            return false;
        }
        CMIScheduler.runAtLocation((Location)nloc, () -> {
            Block block = nloc.getBlock();
            if (!CMIMaterial.isSign((Material)block.getType())) {
                this.Signs.removeSign(Sign2);
                res.getSignsInResidence().remove(Sign2);
                return;
            }
            Sign sign = (Sign)block.getState();
            String landName = res.getName();
            if (landName == null) {
                return;
            }
            if (!ForRent && !ForSale) {
                String shortName = this.fixResName(landName);
                String secondLine = null;
                if (shortName.contains("~")) {
                    String[] lines = this.fixDoubleResName(landName);
                    shortName = lines[0];
                    secondLine = lines[1];
                }
                sign.setLine(0, this.plugin.msg(lm.Sign_ResName, shortName));
                if (secondLine != null) {
                    sign.setLine(1, this.plugin.msg(lm.Sign_ResName, secondLine));
                }
                sign.setLine(2, "");
                sign.setLine(3, "");
                sign.setLine(secondLine == null ? 1 : 2, this.plugin.msg(lm.Sign_Owner, res.getOwner()));
                sign.update();
                return;
            }
            if (ForRent) {
                String timeString;
                boolean rented = res.isRented();
                RentedLand rentedPlace = res.getRentedLand();
                long time = 0L;
                if (rentedPlace != null) {
                    time = rentedPlace.endTime;
                }
                SimpleDateFormat formatter = new SimpleDateFormat(this.plugin.msg(lm.Sign_DateFormat, new Object[0]));
                formatter.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfigManager().getTimeZone()));
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(time);
                String endDate = timeString = formatter.format(calendar.getTime());
                if (time == 0L) {
                    endDate = "Unknown";
                }
                endDate = this.plugin.getRentManager().getRentedAutoRepeats(res) ? this.plugin.msg(lm.Sign_RentedAutorenewTrue, endDate) : this.plugin.msg(lm.Sign_RentedAutorenewFalse, endDate);
                String TopLine = rented ? this.plugin.msg(lm.Sign_RentedTopLine, endDate) : this.plugin.msg(lm.Sign_ForRentTopLine, new Object[0]);
                sign.setLine(0, TopLine);
                String infoLine = this.plugin.msg(rented ? lm.Sign_RentedPriceLine : lm.Sign_ForRentPriceLine, this.plugin.getRentManager().getCostOfRent(res), this.plugin.getRentManager().getRentDays(res), this.plugin.getRentManager().getRentableRepeatable(res));
                sign.setLine(1, infoLine);
                String shortName = this.fixResName(landName);
                sign.setLine(2, rented ? this.plugin.msg(lm.Sign_RentedResName, shortName) : this.plugin.msg(lm.Sign_RentedResName, shortName));
                sign.setLine(3, rented ? this.plugin.msg(lm.Sign_RentedBottomLine, this.plugin.getRentManager().getRentingPlayer(landName)) : this.plugin.msg(lm.Sign_ForRentBottomLine, new Object[0]));
                sign.update();
            }
            if (ForSale) {
                String shortName = this.fixResName(landName);
                String secondLine = null;
                if (shortName.contains("~")) {
                    String[] lines = this.fixDoubleResName(landName);
                    shortName = lines[0];
                    secondLine = lines[1];
                }
                sign.setLine(0, this.plugin.msg(lm.Sign_ForSaleTopLine, new Object[0]));
                String infoLine = this.plugin.msg(lm.Sign_ForSalePriceLine, res.getSellPrice());
                sign.setLine(1, infoLine);
                sign.setLine(2, this.plugin.msg(lm.Sign_RentedResName, shortName));
                if (secondLine != null) {
                    sign.setLine(3, this.plugin.msg(lm.Sign_RentedResName, secondLine));
                } else {
                    sign.setLine(3, this.plugin.msg(lm.Sign_ForSaleBottom, res.getTotalSize()));
                }
                sign.update();
            }
        });
        return true;
    }

    public void convertSigns(CommandSender sender) {
        File file = new File("plugins/ResidenceSigns/signs.yml");
        if (!file.exists()) {
            sender.sendMessage(ChatColor.GOLD + "Can't find ResidenceSign file");
            return;
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)file);
        if (!conf.contains("signs")) {
            sender.sendMessage(ChatColor.GOLD + "Incorrect format of signs file");
            return;
        }
        Set sectionname = conf.getConfigurationSection("signs").getKeys(false);
        ConfigurationSection section = conf.getConfigurationSection("signs");
        long time = System.currentTimeMillis();
        int i = 0;
        for (String one : sectionname) {
            Location nloc;
            Block block;
            World world;
            Signs signs = new Signs();
            String resname = section.getString(String.valueOf(one) + ".resName");
            ClaimedResidence res = this.plugin.getResidenceManager().getByName(resname);
            if (res == null) continue;
            signs.setResidence(res);
            List loc = section.getStringList(String.valueOf(one) + ".loc");
            if (loc.size() != 4 || (world = Bukkit.getWorld((String)((String)loc.get(0)))) == null) continue;
            int x = 0;
            int y = 0;
            int z = 0;
            try {
                x = Integer.parseInt((String)loc.get(1));
                y = Integer.parseInt((String)loc.get(2));
                z = Integer.parseInt((String)loc.get(3));
            }
            catch (Exception ex) {
                continue;
            }
            signs.setLocation(new Location(world, (double)x, (double)y, (double)z));
            Signs s = this.getSigns().getResSign(signs.getLocation());
            if (s == null || !((block = (nloc = signs.getLocation()).getBlock()).getState() instanceof Sign)) continue;
            this.getSigns().addSign(signs);
            this.SignUpdate(signs);
            ++i;
        }
        this.saveSigns();
        sender.sendMessage(ChatColor.GOLD + i + ChatColor.YELLOW + " signs have being converted to new format! It took " + ChatColor.GOLD + (System.currentTimeMillis() - time) + ChatColor.YELLOW + " ms!");
    }

    public String fixResName(String name) {
        if (name.length() > 15 && !name.contains(".")) {
            name = "~" + name.substring(name.length() - 14);
        } else if (name.length() > 15 && name.contains(".")) {
            String[] splited = name.split("\\.");
            name = "";
            int i = 0;
            while (i < splited.length) {
                String tempName = String.valueOf(name) + "." + splited[i];
                name = tempName.length() < 15 ? tempName : "~" + tempName.substring(tempName.length() - 14);
                ++i;
            }
        }
        return name;
    }

    public String[] fixDoubleResName(String name) {
        String SecondLine = name.substring(name.length() - 15);
        String FirstLine = name.replace(SecondLine, "");
        if (FirstLine.length() > 15 && !FirstLine.contains(".")) {
            FirstLine = "~" + FirstLine.substring(name.length() - 14);
        } else if (FirstLine.length() > 15 && FirstLine.contains(".")) {
            String[] splited = FirstLine.split("\\.");
            FirstLine = "";
            int i = 0;
            while (i < splited.length) {
                String tempName = String.valueOf(FirstLine) + "." + splited[i];
                FirstLine = tempName.length() < 15 ? tempName : "~" + tempName.substring(tempName.length() - 14);
                ++i;
            }
        }
        String[] lines = new String[]{FirstLine, SecondLine};
        return lines;
    }
}

