/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.residence.Placeholders.Placeholder;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.ResidenceCommandListener;
import com.bekvon.bukkit.residence.commands.pset;
import com.bekvon.bukkit.residence.commands.set;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.HelpLines;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HelpEntry {
    protected String name;
    protected String desc;
    protected String[] lines;
    protected List<HelpEntry> subentrys;
    protected static int linesPerPage = 8;

    public HelpEntry(String entryname) {
        this.name = entryname;
        this.subentrys = new ArrayList<HelpEntry>();
        this.lines = new String[0];
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String inname) {
        this.name = inname;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public String getDescription() {
        if (this.desc == null) {
            return "";
        }
        return this.desc;
    }

    public void printHelp(CommandSender sender, int page, boolean resadmin2, String path) {
        List<HelpLines> helplines = this.getHelpData(sender, resadmin2);
        path = "/" + path.replace(".", " ") + " ";
        PageInfo pi = new PageInfo(linesPerPage, helplines.size(), page);
        if (!pi.isPageOk()) {
            Residence.getInstance().msg(sender, lm.Invalid_Help, new Object[0]);
            return;
        }
        int i = pi.getStart();
        while (i <= pi.getEnd()) {
            if (helplines.get(i).getCommand() != null) {
                HelpEntry sub = this.getSubEntry(helplines.get(i).getCommand());
                String desc = "&6";
                int y = 0;
                String[] stringArray = sub.lines;
                int n = sub.lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String one = stringArray[n2];
                    desc = String.valueOf(desc) + one;
                    if (++y < sub.lines.length) {
                        desc = String.valueOf(desc) + "\n";
                    }
                    ++n2;
                }
                if (resadmin2) {
                    path = path.replace("/res ", "/resadmin ");
                }
                RawMessage rm = new RawMessage();
                rm.addText(CMIChatColor.translate((String)("&6" + helplines.get(i).getDesc()))).addHover(desc).addSuggestion(String.valueOf(path) + helplines.get(i).getCommand());
                rm.show(sender);
            } else {
                sender.sendMessage(CMIChatColor.translate((String)("&6" + helplines.get(i).getDesc())));
            }
            ++i;
        }
        String baseCmd = resadmin2 ? "resadmin" : "res";
        String cmd2 = !this.name.equalsIgnoreCase("res") ? "/" + baseCmd + " " + this.name + " ?" : "/" + baseCmd + " ?";
        pi.autoPagination(sender, cmd2);
    }

    public void printHelp(CommandSender sender, int page, String path, boolean resadmin2) {
        HelpEntry subEntry = this.getSubEntry(path);
        if (subEntry != null) {
            subEntry.printHelp(sender, page, resadmin2, path);
        } else {
            Residence.getInstance().msg(sender, lm.Invalid_Help, new Object[0]);
        }
    }

    private List<HelpLines> getHelpData(CommandSender sender, boolean resadmin2) {
        ArrayList<HelpLines> helplines = new ArrayList<HelpLines>();
        String[] stringArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            String one = stringArray[n2];
            helplines.add(new HelpLines(null, one));
            ++n2;
        }
        FlagPermissions GlobalFlags = Residence.getInstance().getPermissionManager().getAllFlags();
        Map<String, String> unsortMap = new HashMap<String, String>();
        for (HelpEntry helpEntry : this.subentrys) {
            block17: {
                block16: {
                    if (this.name.equalsIgnoreCase("flags")) break block16;
                    if (ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && !resadmin2 || !ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && resadmin2) {
                        continue;
                    }
                    break block17;
                }
                if (!GlobalFlags.getFlags().containsKey(helpEntry.getName().toLowerCase())) break block17;
                Boolean state = GlobalFlags.getFlags().get(helpEntry.getName().toLowerCase());
                if (!state.booleanValue() && !resadmin2 && !PermissionManager.ResPerm.flag_$1.hasPermission(sender, helpEntry.getName().toLowerCase())) continue;
                String flagName = helpEntry.getName();
                Flags flag = Flags.getFlag(helpEntry.getName());
                if (flag != null) {
                    flagName = flag.getName();
                }
                String desc = helpEntry.getDescription();
                switch (helpEntry.getName().toLowerCase()) {
                    case "wspeed1": {
                        desc = desc.replace("%1", "" + Residence.getInstance().getConfigManager().getWalkSpeed1());
                        break;
                    }
                    case "wspeed2": {
                        desc = desc.replace("%1", "" + Residence.getInstance().getConfigManager().getWalkSpeed2());
                    }
                }
                unsortMap.put(helpEntry.getName(), Residence.getInstance().msg(lm.InformationPage_FlagsList, flagName, desc));
                continue;
            }
            helplines.add(new HelpLines(helpEntry.getName(), Residence.getInstance().msg(lm.InformationPage_GeneralList, helpEntry.getName(), helpEntry.getDescription())));
        }
        if (!unsortMap.isEmpty()) {
            unsortMap = Residence.getInstance().getSortingManager().sortStringByKeyASC(unsortMap);
            for (Map.Entry entry : unsortMap.entrySet()) {
                helplines.add(new HelpLines((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return helplines;
    }

    public boolean containesEntry(String name) {
        return this.getSubEntry(name) != null;
    }

    public HelpEntry getSubEntry(String name) {
        String[] split = name.split("\\.");
        HelpEntry entry = this;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String entryname = stringArray[n2];
            if ((entry = entry.findSubEntry(entryname)) == null) {
                return null;
            }
            ++n2;
        }
        return entry;
    }

    private HelpEntry findSubEntry(String name) {
        for (HelpEntry entry : this.subentrys) {
            if (!entry.getName().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return null;
    }

    public void addSubEntry(HelpEntry entry) {
        if (!this.subentrys.contains(entry)) {
            this.subentrys.add(entry);
        }
    }

    public void removeSubEntry(HelpEntry entry) {
        if (this.subentrys.contains(entry)) {
            this.subentrys.remove(entry);
        }
    }

    public int getSubEntryCount() {
        return this.subentrys.size();
    }

    public static HelpEntry parseHelp(FileConfiguration node, String key) {
        String[] split = key.split("\\.");
        String thisname = split[split.length - 1];
        HelpEntry entry = new HelpEntry(thisname);
        ConfigurationSection keysnode = node.getConfigurationSection(key);
        Set keys = null;
        if (keysnode != null) {
            keys = keysnode.getKeys(false);
        }
        if (keys != null) {
            List stringList;
            if (keys.contains("Info") && (stringList = node.getStringList(String.valueOf(key) + ".Info")) != null) {
                entry.lines = new String[stringList.size()];
                int i = 0;
                while (i < stringList.size()) {
                    entry.lines[i] = CMIChatColor.translate((String)((String)stringList.get(i)));
                    ++i;
                }
            }
            if (keys.contains("Description")) {
                entry.desc = node.getString(String.valueOf(key) + ".Description");
            }
            if (keys.contains("SubCommands")) {
                Set subcommandkeys = node.getConfigurationSection(String.valueOf(key) + ".SubCommands").getKeys(false);
                if (key.equalsIgnoreCase("CommandHelp.SubCommands.res")) {
                    subcommandkeys.clear();
                    for (String one : Residence.getInstance().getCommandFiller().getCommands()) {
                        subcommandkeys.add(one);
                    }
                }
                for (String subkey : subcommandkeys) {
                    entry.subentrys.add(HelpEntry.parseHelp(node, String.valueOf(key) + ".SubCommands." + subkey));
                }
            }
        }
        return entry;
    }

    private static String getMp(HashMap<String, List<String>> mp) {
        StringBuilder st = new StringBuilder();
        for (String one : mp.keySet()) {
            if (!st.toString().isEmpty()) {
                st.append("%%");
            }
            st.append(one);
        }
        return st.toString();
    }

    private static String getMpEntry(HashMap<String, List<String>> mp) {
        StringBuilder st = new StringBuilder();
        for (Map.Entry<String, List<String>> one : mp.entrySet()) {
            if (!st.toString().isEmpty()) {
                st.append("%%");
            }
            if (one.getKey().equalsIgnoreCase("") && !one.getValue().isEmpty()) {
                st.append(one.getValue().get(0));
                continue;
            }
            st.append(one.getKey());
        }
        return st.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getSubCommands(CommandSender sender, String[] args) {
        HashSet<String> subCommands;
        block93: {
            subCommands = new HashSet<String>();
            int neededArgPlace = args.length - 2;
            if (neededArgPlace < 0) {
                neededArgPlace = 0;
            }
            List<String> ArgsList = new ArrayList<String>();
            if (args.length > 0) {
                HashMap<String, List<String>> mp = new HashMap<String, List<String>>();
                ArrayList<String> base = new ArrayList<String>();
                for (Map.Entry<String, HashMap<String, List<String>>> entry : Residence.getInstance().getLocaleManager().CommandTab.entrySet()) {
                    if (!entry.getKey().startsWith(args[0].toLowerCase())) continue;
                    mp.putAll((Map<String, List<String>>)entry.getValue());
                    base.add(entry.getKey());
                }
                if (!mp.isEmpty()) {
                    if (args.length > 1) {
                        if (args[args.length - 1].isEmpty()) {
                            List<String> list2 = mp.get(args[1].toLowerCase());
                            if (list2 != null) {
                                --neededArgPlace;
                                if (args.length == 2) {
                                    ArgsList.add(HelpEntry.getMpEntry(mp));
                                } else {
                                    ArgsList = list2;
                                }
                            } else {
                                List<String> list3 = mp.get("");
                                if (list3 != null) {
                                    ArgsList = list3;
                                } else {
                                    ArgsList.add(HelpEntry.getMp(mp));
                                }
                            }
                        } else {
                            List<String> list4 = mp.get("");
                            if (list4 != null) {
                                if (args.length == 2) {
                                    ArgsList.add(HelpEntry.getMpEntry(mp));
                                } else {
                                    ArgsList = list4;
                                }
                            } else {
                                ArgsList.add(HelpEntry.getMp(mp));
                            }
                        }
                    } else {
                        ArgsList.add(CMIList.listToString(base, (String)"%%"));
                        ArgsList.add(HelpEntry.getMp(mp));
                    }
                } else {
                    for (String string : Residence.getInstance().getLocaleManager().CommandTab.keySet()) {
                        if (!PermissionManager.ResPerm.command_$1.hasPermission(sender, string)) continue;
                        subCommands.add(string);
                    }
                    return subCommands;
                }
            }
            String NeededArg = null;
            if (neededArgPlace < 0) {
                neededArgPlace = 0;
            }
            if (neededArgPlace < ArgsList.size() && neededArgPlace >= 0) {
                NeededArg = (String)ArgsList.get(neededArgPlace);
            }
            Player playerSender = null;
            if (sender instanceof Player) {
                playerSender = (Player)sender;
            }
            if (NeededArg == null) break block93;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (NeededArg.contains("%%")) {
                arrayList.addAll(Arrays.asList(NeededArg.split("%%")));
            } else {
                arrayList.add(NeededArg);
            }
            Iterator iterator = arrayList.iterator();
            block36: while (iterator.hasNext()) {
                String oneArg;
                switch (oneArg = (String)iterator.next()) {
                    case "[playername]": {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (playerSender != null && !playerSender.canSee(player)) continue;
                            subCommands.add(player.getName());
                        }
                        continue block36;
                    }
                    case "[residence]": {
                        if (sender instanceof Player) {
                            String resName;
                            ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation());
                            if (claimedResidence != null && (resName = claimedResidence.getName()) != null) {
                                subCommands.add(resName);
                            }
                            List<ClaimedResidence> resList = Residence.getInstance().getPlayerManager().getResidencePlayer((Player)sender).getResList();
                            for (ClaimedResidence oneRes : resList) {
                                subCommands.add(oneRes.getName());
                            }
                            continue block36;
                        }
                        subCommands.addAll(Residence.getInstance().getResidenceManager().getResidenceList(Residence.getInstance().getServerLandName(), true, false, false));
                        break;
                    }
                    case "[cresidence]": {
                        String resName;
                        ClaimedResidence claimedResidence;
                        if (!(sender instanceof Player) || (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation())) == null || (resName = claimedResidence.getName()) == null) continue block36;
                        subCommands.add(resName);
                        break;
                    }
                    case "[carea]": {
                        String resName;
                        ClaimedResidence claimedResidence;
                        if (!(sender instanceof Player) || (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation())) == null || (resName = claimedResidence.getAreaIDbyLoc(((Player)sender).getLocation())) == null) continue block36;
                        subCommands.add(resName);
                        break;
                    }
                    case "[enter]": {
                        String resName;
                        ClaimedResidence claimedResidence;
                        if (!(sender instanceof Player) || (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation())) == null || (resName = claimedResidence.getEnterMessage()) == null) continue block36;
                        subCommands.add(CMIChatColor.deColorize((String)resName));
                        break;
                    }
                    case "[leave]": {
                        String resName;
                        ClaimedResidence claimedResidence;
                        if (!(sender instanceof Player) || (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(((Player)sender).getLocation())) == null || (resName = claimedResidence.getLeaveMessage()) == null) continue block36;
                        subCommands.add(CMIChatColor.deColorize((String)resName));
                        break;
                    }
                    case "[residenceshop]": {
                        for (ClaimedResidence claimedResidence : Residence.getInstance().getResidenceManager().getShops()) {
                            subCommands.add(claimedResidence.getName());
                        }
                        continue block36;
                    }
                    case "[placeholder]": {
                        Placeholder.CMIPlaceHolders[] cMIPlaceHoldersArray = Placeholder.CMIPlaceHolders.values();
                        int n = cMIPlaceHoldersArray.length;
                        int resName = 0;
                        while (resName < n) {
                            Placeholder.CMIPlaceHolders cMIPlaceHolders = cMIPlaceHoldersArray[resName];
                            subCommands.add(cMIPlaceHolders.getFull());
                            ++resName;
                        }
                        continue block36;
                    }
                    case "[flag]": {
                        void var12_31;
                        Flags.FlagMode flagMode = Flags.FlagMode.Both;
                        if (args.length > 0) {
                            if (args[0].equalsIgnoreCase(set.class.getSimpleName())) {
                                Flags.FlagMode flagMode2 = Flags.FlagMode.Residence;
                            } else if (args[0].equalsIgnoreCase(pset.class.getSimpleName())) {
                                Flags.FlagMode flagMode3 = Flags.FlagMode.Player;
                            }
                        }
                        if (args.length > 1 && Flags.getFlag(args[args.length - 2]) != null) continue block36;
                        for (String one : FlagPermissions.getAllPosibleFlags()) {
                            Flags f = Flags.getFlag(one);
                            if (f != null) {
                                if (f.getFlagMode() != Flags.FlagMode.Both && f.getFlagMode() != var12_31 || !f.isGlobalyEnabled()) continue;
                                subCommands.add(f.getName());
                            }
                            subCommands.add(one);
                        }
                        for (String one : FlagPermissions.getPosibleAreaFlags()) {
                            Flags f = Flags.getFlag(one);
                            if (f != null) {
                                if (f.getFlagMode() != Flags.FlagMode.Both && f.getFlagMode() != var12_31 || !f.isGlobalyEnabled()) continue;
                                subCommands.add(f.getName());
                            }
                            subCommands.add(one);
                        }
                        continue block36;
                    }
                    case "[material]": {
                        Material[] materialArray = Material.values();
                        int n = materialArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Material one = materialArray[n2];
                            subCommands.add(one.name().toLowerCase());
                            ++n2;
                        }
                        continue block36;
                    }
                    case "[materialId]": {
                        if (!Version.isCurrentEqualOrLower((Version)Version.v1_13_R2)) continue block36;
                        Material[] materialArray = Material.values();
                        int n = materialArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Material one = materialArray[n3];
                            subCommands.add(String.valueOf(one.getId()));
                            ++n3;
                        }
                        continue block36;
                    }
                    case "[worldname]": {
                        for (World one : Bukkit.getWorlds()) {
                            subCommands.add(one.getName());
                        }
                        continue block36;
                    }
                    case "[x]": {
                        if (playerSender == null) continue block36;
                        subCommands.add(String.valueOf(playerSender.getLocation().getBlockX()));
                        break;
                    }
                    case "[y]": {
                        if (playerSender == null) continue block36;
                        subCommands.add(String.valueOf(playerSender.getLocation().getBlockY()));
                        break;
                    }
                    case "[z]": {
                        if (playerSender == null) continue block36;
                        subCommands.add(String.valueOf(playerSender.getLocation().getBlockZ()));
                        break;
                    }
                    default: {
                        subCommands.add(oneArg);
                    }
                }
            }
        }
        if (!subCommands.isEmpty()) {
            return subCommands;
        }
        return new HashSet<String>(Arrays.asList("?"));
    }
}

