/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.RandomTeleport;
import com.bekvon.bukkit.residence.containers.ValidLocation;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.listeners.ResidencePlayerListener;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Version.PaperMethods.PaperLib;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Teleporters.CMITeleporter;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class RandomTp {
    static int miny = 63;
    private Residence plugin;
    Random randomX = new Random(System.currentTimeMillis());
    Random randomZ = new Random(System.nanoTime());

    public RandomTp(Residence plugin) {
        this.plugin = plugin;
    }

    public boolean isDefinedRnadomTp(World world) {
        for (RandomTeleport one : this.plugin.getConfigManager().getRandomTeleport()) {
            if (!one.getCenter().getWorld().equals(world)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Location getRandomlocation(World world) {
        if (world == null) {
            return null;
        }
        Random randomX = new Random(System.currentTimeMillis());
        Random randomZ = new Random(System.nanoTime());
        boolean ok = false;
        double x = 0.0;
        double z = 0.0;
        int tries = 0;
        RandomTeleport rtloc = null;
        for (RandomTeleport one : this.plugin.getConfigManager().getRandomTeleport()) {
            if (!one.getCenter().getWorld().equals(world)) continue;
            rtloc = one;
            break;
        }
        if (rtloc == null) {
            return null;
        }
        int inerrange = rtloc.getMinCord();
        int outerrange = rtloc.getMaxCord();
        if (outerrange < 1) {
            outerrange = 1;
        }
        int maxtries = this.plugin.getConfigManager().getrtMaxTries();
        int centerX = rtloc.getCenter().getBlockX();
        int centerY = rtloc.getCenter().getBlockZ();
        Location loc = null;
        block1: while (!ok) {
            ClaimedResidence res;
            if (++tries > maxtries) {
                return null;
            }
            x = (double)(randomX.nextInt(outerrange * 2) - outerrange) + 0.5 + (double)centerX;
            if (x > (double)(inerrange * -1) && x < (double)inerrange || (z = (double)(randomZ.nextInt(outerrange * 2) - outerrange) + 0.5 + (double)centerY) > (double)(inerrange * -1) && z < (double)inerrange) continue;
            loc = new Location(world, x, (double)world.getMaxHeight(), z);
            int max = loc.getWorld().getMaxHeight();
            int i = max = loc.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? 100 : world.getHighestBlockAt(loc).getY() + 1;
            while (i > 0) {
                loc.setY((double)i);
                Block block = loc.getBlock();
                Block block2 = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = loc.clone().add(0.0, -1.0, 0.0).getBlock();
                if (!ResidencePlayerListener.isEmptyBlock(block3) && ResidencePlayerListener.isEmptyBlock(block) && ResidencePlayerListener.isEmptyBlock(block2)) break;
                if (i <= 3) {
                    loc = null;
                    continue block1;
                }
                --i;
            }
            if (!ResidencePlayerListener.isEmptyBlock(loc.getBlock()) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.LAVA) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.WATER) || (res = this.plugin.getResidenceManager().getByLoc(loc)) != null) continue;
            loc.setY(loc.getY() + 2.0);
            break;
        }
        if (loc != null) {
            int dir = randomZ.nextInt(359);
            loc.setYaw((float)dir);
        }
        return loc;
    }

    public Location getRandomlocationSync(World world) {
        return this.get(world);
    }

    public CompletableFuture<Location> getRandomlocationAsync(World world) {
        return CompletableFuture.supplyAsync(() -> this.get(world));
    }

    private RandomTeleport getRandomTeleport(World world) {
        if (world == null) {
            return null;
        }
        for (RandomTeleport one : this.plugin.getConfigManager().getRandomTeleport()) {
            if (!one.getCenter().getWorld().equals(world)) continue;
            return one;
        }
        return null;
    }

    private Location get(World world) {
        if (world == null) {
            return null;
        }
        boolean ok = false;
        double x = 0.0;
        double z = 0.0;
        int tries = 0;
        RandomTeleport rtloc = null;
        for (RandomTeleport one : this.plugin.getConfigManager().getRandomTeleport()) {
            if (!one.getCenter().getWorld().equals(world)) continue;
            rtloc = one;
            break;
        }
        if (rtloc == null) {
            return null;
        }
        int inerrange = rtloc.getMinCord();
        int outerrange = rtloc.getMaxCord();
        if (outerrange < 1) {
            outerrange = 1;
        }
        int maxtries = this.plugin.getConfigManager().getrtMaxTries();
        int centerX = rtloc.getCenter().getBlockX();
        int centerY = rtloc.getCenter().getBlockZ();
        Location loc = null;
        while (!ok) {
            if (++tries > maxtries) {
                return null;
            }
            try {
                ClaimedResidence res;
                x = (double)(this.randomX.nextInt(outerrange * 2) - outerrange) + 0.5 + (double)centerX;
                if (x > (double)(inerrange * -1) && x < (double)inerrange || (z = (double)(this.randomZ.nextInt(outerrange * 2) - outerrange) + 0.5 + (double)centerY) > (double)(inerrange * -1) && z < (double)inerrange) continue;
                loc = new Location(world, x, (double)world.getMaxHeight(), z);
                if ((loc = RandomTp.getDownLocationSimple(loc)) == null) continue;
                if (loc.getY() < (double)(CMIWorld.getMinHeight((World)loc.getWorld()) + 4)) {
                    if (loc.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                        loc.setY((double)(CMIWorld.getMaxHeight((World)loc.getWorld()) / 2));
                    } else if (Version.isFolia()) {
                        Location location = loc;
                        CompletableFuture fut = CMIScheduler.runAtLocation((Location)loc, () -> {
                            Chunk chunk = location.getChunk();
                            int y = chunk.getChunkSnapshot().getHighestBlockYAt(location.getBlockX() & 0xF, location.getBlockZ() & 0xF) - 1;
                            location.setY((double)y);
                        });
                        fut.get();
                        loc = location;
                    } else if (Version.isPaper() && Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                        CompletableFuture chunkFuture = PaperLib.getChunkAtAsync((Location)loc, (boolean)false);
                        Chunk chunk = (Chunk)chunkFuture.get();
                        if (chunk == null) continue;
                        int y = chunk.getChunkSnapshot().getHighestBlockYAt(loc.getBlockX() & 0xF, loc.getBlockZ() & 0xF) - 1;
                        loc.setY((double)y);
                    } else {
                        loc.setY((double)loc.getWorld().getHighestBlockYAt(loc));
                    }
                }
                if (loc.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && loc.getY() > 128.0) continue;
                ValidLocation empty = new ValidLocation();
                if (Version.isFolia()) {
                    Location location = loc;
                    CompletableFuture fut = CMIScheduler.runAtLocation((Location)loc, () -> {
                        validLocation.valid = ResidencePlayerListener.isEmptyBlock(location.getBlock());
                        if (!validLocation.valid) {
                            return;
                        }
                        boolean bl = validLocation.valid = !location.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.LAVA);
                        if (!validLocation.valid) {
                            return;
                        }
                        validLocation.valid = !location.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.WATER);
                    });
                    fut.get();
                } else {
                    empty.valid = ResidencePlayerListener.isEmptyBlock(loc.getBlock());
                }
                if (!empty.valid || !Version.isFolia() && (loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.LAVA) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().equals((Object)Material.WATER)) || (res = this.plugin.getResidenceManager().getByLoc(loc)) != null) continue;
                loc.setY(loc.getY() + 2.0);
                break;
            }
            catch (Error | Exception empty) {
                // empty catch block
            }
        }
        if (loc != null) {
            int dir = this.randomZ.nextInt(359);
            loc.setYaw((float)dir);
        }
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Location getDownLocationSimple(Location oloc) {
        try {
            if (oloc == null) {
                return oloc;
            }
            Location loc = oloc.clone();
            loc.setY((double)loc.getBlockY());
            if (oloc.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                return null;
            }
            if (Version.isFolia()) {
                Location location = loc.clone();
                CompletableFuture fut = CMIScheduler.runAtLocation((Location)loc, () -> {
                    Chunk chunk = location.getChunk();
                    int y = chunk.getChunkSnapshot().getHighestBlockYAt(location.getBlockX() & 0xF, location.getBlockZ() & 0xF) - 1;
                    location.setY((double)(y + 1));
                });
                fut.get();
                loc = location;
            } else if (Version.isPaper() && Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                CompletableFuture chunkFuture = PaperLib.getChunkAtAsync((Location)loc, (boolean)true);
                Chunk chunk = (Chunk)chunkFuture.get();
                if (chunk == null) {
                    return null;
                }
                int y = chunk.getChunkSnapshot().getHighestBlockYAt(loc.getBlockX() & 0xF, loc.getBlockZ() & 0xF) - 1;
                if (loc.getY() < (double)y) {
                    return null;
                }
                loc.setY((double)(y + 1));
            } else {
                int y = loc.getWorld().getHighestBlockYAt(loc);
                if (loc.getY() < (double)y) {
                    return null;
                }
                loc.setY((double)(y + 1));
            }
            if (oloc.getWorld().getEnvironment().equals((Object)World.Environment.THE_END) && loc.getY() < 5.0) {
                return null;
            }
            return loc.add(0.0, 1.0, 0.0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void performDelaydTp(Location loc, Player targetPlayer) {
        CMIScheduler.runAtLocationLater((Location)loc, () -> {
            if (!this.plugin.getTeleportDelayMap().contains(targetPlayer.getName()) && this.plugin.getConfigManager().getTeleportDelay() > 0) {
                return;
            }
            if (this.plugin.getTeleportDelayMap().contains(targetPlayer.getName())) {
                this.plugin.getTeleportDelayMap().remove(targetPlayer.getName());
            }
            targetPlayer.closeInventory();
            CMITeleporter.teleportAsync((Entity)targetPlayer, (Location)loc);
            this.plugin.msg((CommandSender)targetPlayer, lm.RandomTeleport_TeleportSuccess, loc.getX(), loc.getY(), loc.getZ());
        }, (long)((long)this.plugin.getConfigManager().getTeleportDelay() * 20L));
    }

    public void performInstantTp(Location loc, Player targetPlayer) {
        targetPlayer.closeInventory();
        CMITeleporter.teleportAsync((Entity)targetPlayer, (Location)loc);
        this.plugin.msg((CommandSender)targetPlayer, lm.RandomTeleport_TeleportSuccess, loc.getX(), loc.getY(), loc.getZ());
    }
}

