/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import me.mattstudios.citizenscmd.api.CitizensCMDAPI;
import me.mattstudios.citizenscmd.commands.AddCommand;
import me.mattstudios.citizenscmd.commands.CooldownCommand;
import me.mattstudios.citizenscmd.commands.EditCommand;
import me.mattstudios.citizenscmd.commands.HelpCommand;
import me.mattstudios.citizenscmd.commands.ListCommand;
import me.mattstudios.citizenscmd.commands.PermissionCommand;
import me.mattstudios.citizenscmd.commands.PriceCommand;
import me.mattstudios.citizenscmd.commands.ReloadCommand;
import me.mattstudios.citizenscmd.commands.RemoveCommand;
import me.mattstudios.citizenscmd.files.CooldownHandler;
import me.mattstudios.citizenscmd.files.DataHandler;
import me.mattstudios.citizenscmd.files.LangHandler;
import me.mattstudios.citizenscmd.listeners.NPCClickListener;
import me.mattstudios.citizenscmd.listeners.NPCListener;
import me.mattstudios.citizenscmd.listeners.UpdateEvent;
import me.mattstudios.citizenscmd.metrics.bukkit.Metrics;
import me.mattstudios.citizenscmd.mf.base.CommandManager;
import me.mattstudios.citizenscmd.permissions.PermissionsManager;
import me.mattstudios.citizenscmd.schedulers.CooldownScheduler;
import me.mattstudios.citizenscmd.schedulers.UpdateScheduler;
import me.mattstudios.citizenscmd.updater.SpigotUpdater;
import me.mattstudios.citizenscmd.utility.DisplayFormat;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.Util;
import me.mattstudios.citizenscmd.utility.YamlUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class CitizensCMD
extends JavaPlugin {
    private LangHandler lang;
    private DataHandler dataHandler;
    private CooldownHandler cooldownHandler;
    private PermissionsManager permissionsManager;
    private static CitizensCMDAPI api;
    private static Economy economy;
    private boolean papi = false;
    private CommandManager commandManager;
    private boolean updateStatus = false;
    private boolean shift = false;
    private String newVersion;
    private DisplayFormat displayFormat;
    private HashMap<String, Boolean> waitingList;

    public void onEnable() {
        this.saveDefaultConfig();
        YamlUtils.copyDefaults(this.getClassLoader().getResourceAsStream("config.yml"), new File(this.getDataFolder().getPath(), "config.yml"));
        this.setLang(Objects.requireNonNull(this.getConfig().getString("lang")));
        if (!this.hasCitizens() && this.getConfig().getBoolean("citizens-check")) {
            Util.disablePlugin(this);
            return;
        }
        this.commandManager = new CommandManager(this);
        Metrics metrics = new Metrics((Plugin)this);
        Util.setUpMetrics(metrics, this.getConfig());
        MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r &3Citizens&cCMD &8&o" + this.getDescription().getVersion() + " &8By &3Mateus Moreira &c@LichtHund"));
        this.permissionsManager = new PermissionsManager(this);
        this.dataHandler = new DataHandler(this);
        this.dataHandler.initialize();
        this.cooldownHandler = new CooldownHandler(this);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> this.cooldownHandler.initialize(), 30L);
        this.registerCommands();
        this.registerEvents();
        MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r " + this.lang.getMessage(Messages.USING_LANGUAGE)));
        if (this.hasPAPI()) {
            MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r " + this.lang.getMessage(Messages.PAPI_AVAILABLE)));
            this.papi = true;
        }
        if (this.setupEconomy()) {
            MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r " + this.lang.getUncoloredMessage(Messages.VAULT_AVAILABLE)));
        }
        this.waitingList = new HashMap();
        this.setShift(this.getConfig().getBoolean("shift-confirm"));
        if (this.getConfig().contains("cooldown-time-display")) {
            switch (Objects.requireNonNull(this.getConfig().getString("cooldown-time-display")).toLowerCase()) {
                case "short": {
                    this.displayFormat = DisplayFormat.SHORT;
                    break;
                }
                case "full": {
                    this.displayFormat = DisplayFormat.FULL;
                    break;
                }
                default: {
                    this.displayFormat = DisplayFormat.MEDIUM;
                    break;
                }
            }
        } else {
            this.displayFormat = DisplayFormat.MEDIUM;
        }
        if (this.getConfig().getBoolean("check-updates")) {
            SpigotUpdater updater = new SpigotUpdater(this, 30224);
            try {
                if (updater.checkForUpdates()) {
                    this.updateStatus = true;
                    this.newVersion = updater.getLatestVersion();
                    MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r &b&o" + this.lang.getUncoloredMessage(Messages.STARTUP_NEW_VERSION)));
                    MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r &b&o" + updater.getResourceURL()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        api = new CitizensCMDAPI(this.dataHandler);
        new UpdateScheduler(this).runTaskTimerAsynchronously((Plugin)this, 72000L, 72000L);
        new CooldownScheduler(this).runTaskTimerAsynchronously((Plugin)this, 36000L, 36000L);
    }

    private boolean hasCitizens() {
        return Bukkit.getPluginManager().isPluginEnabled("Citizens");
    }

    private boolean hasPAPI() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    private void registerCommands() {
        this.commandManager.getCompletionHandler().register("#permissions", input -> Arrays.asList("console", "player", "permission", "server", "message", "sound"));
        this.commandManager.getCompletionHandler().register("#type", input -> Arrays.asList("cmd", "perm"));
        this.commandManager.getCompletionHandler().register("#click", input -> Arrays.asList("left", "right"));
        this.commandManager.getCompletionHandler().register("#set", input -> Arrays.asList("set", "remove"));
        this.commandManager.getMessageHandler().register("cmd.no.permission", (sender, arg) -> {
            sender.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
            sender.sendMessage(this.lang.getMessage(Messages.NO_PERMISSION));
        });
        this.commandManager.getMessageHandler().register("cmd.no.console", (sender, arg) -> {
            sender.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
            sender.sendMessage(this.lang.getMessage(Messages.CONSOLE_NOT_ALLOWED));
        });
        this.commandManager.getMessageHandler().register("cmd.no.exists", (sender, arg) -> {
            sender.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
            sender.sendMessage(this.lang.getMessage(Messages.WRONG_USAGE));
        });
        this.commandManager.getMessageHandler().register("cmd.wrong.usage", (sender, arg) -> {
            sender.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
            sender.sendMessage(this.lang.getMessage(Messages.WRONG_USAGE));
        });
        this.commandManager.getMessageHandler().register("arg.must.be.number", (sender, arg) -> {
            sender.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
            sender.sendMessage(this.lang.getMessage(Messages.INVALID_NUMBER));
        });
        Stream.of(new AddCommand(this), new HelpCommand(this), new EditCommand(this), new ListCommand(this), new CooldownCommand(this), new PermissionCommand(this), new PriceCommand(this), new ReloadCommand(this), new RemoveCommand(this)).forEach(this.commandManager::register);
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new UpdateEvent(this), (Plugin)this);
        pm.registerEvents((Listener)new NPCClickListener(this), (Plugin)this);
        try {
            pm.registerEvents((Listener)new NPCListener(this), (Plugin)this);
        }
        catch (Exception ex) {
            MessageUtils.info(MessageUtils.color("&cCould not register clone event, please update your Citizens."));
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        economy = (Economy)registeredServiceProvider.getProvider();
        this.shift = this.getConfig().getBoolean("shift-confirm");
        return economy != null;
    }

    public void setLang(String language) {
        this.lang = new LangHandler(this, language);
    }

    public boolean papiEnabled() {
        return this.papi;
    }

    public LangHandler getLang() {
        return this.lang;
    }

    public void setUpdateStatus(boolean newUpdateStatus) {
        this.updateStatus = newUpdateStatus;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public CooldownHandler getCooldownHandler() {
        return this.cooldownHandler;
    }

    public PermissionsManager getPermissionsManager() {
        return this.permissionsManager;
    }

    public static Economy getEconomy() {
        return economy;
    }

    public HashMap<String, Boolean> getWaitingList() {
        return this.waitingList;
    }

    public void setShift(boolean shift) {
        this.shift = shift;
    }

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(DisplayFormat displayFormat) {
        this.displayFormat = displayFormat;
    }

    public static CitizensCMDAPI getApi() {
        return api;
    }

    public boolean isShift() {
        return this.shift;
    }

    public boolean isUpdateStatus() {
        return this.updateStatus;
    }
}

