/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.commands;

import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.mf.annotations.Command;
import me.mattstudios.citizenscmd.mf.annotations.Completion;
import me.mattstudios.citizenscmd.mf.annotations.Permission;
import me.mattstudios.citizenscmd.mf.annotations.SubCommand;
import me.mattstudios.citizenscmd.mf.base.CommandBase;
import me.mattstudios.citizenscmd.utility.EnumTypes;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.Util;
import org.bukkit.entity.Player;

@Command(value="npcmd")
public class RemoveCommand
extends CommandBase {
    private CitizensCMD plugin;

    public RemoveCommand(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="remove")
    @Permission(value="citizenscmd.remove")
    @Completion(value={"#click"})
    public void remove(Player player, String clickString, int id) {
        EnumTypes.ClickType click;
        if (Util.npcNotSelected(this.plugin, player)) {
            return;
        }
        int npc = Util.getSelectedNpcId(player);
        switch (clickString.toLowerCase()) {
            case "left": {
                int leftCommandSize = this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.LEFT).size();
                if (leftCommandSize == 0) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.NO_COMMANDS));
                    return;
                }
                if (id < 1 || id > leftCommandSize) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_ID_NUMBER));
                    return;
                }
                click = EnumTypes.ClickType.LEFT;
                break;
            }
            case "right": {
                int rightCommandSize = this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.RIGHT).size();
                if (rightCommandSize == 0) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.NO_COMMANDS));
                    return;
                }
                if (id < 0 || id > rightCommandSize) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_ID_NUMBER));
                    return;
                }
                click = EnumTypes.ClickType.RIGHT;
                break;
            }
            default: {
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_CLICK_TYPE));
                return;
            }
        }
        this.plugin.getDataHandler().removeCommand(npc, id, click, player);
    }
}

