/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.utility.EnumTypes;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.Util;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class DataHandler {
    private CitizensCMD plugin;
    private static File savesFile;
    private static File dir;
    private static FileConfiguration dataConfigurator;
    private HashMap<String, Object> data;

    public DataHandler(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        File pluginFolder = this.plugin.getDataFolder();
        dir = new File(pluginFolder + "/data");
        savesFile = new File(dir.getPath(), "saves.yml");
        dataConfigurator = new YamlConfiguration();
        this.data = new HashMap();
        this.createBasics();
        this.cacheData();
    }

    private void createBasics() {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!savesFile.exists()) {
            try {
                savesFile.createNewFile();
            }
            catch (IOException e) {
                MessageUtils.info(MessageUtils.color("&cError creating saves file.."));
            }
        }
    }

    private void cacheData() {
        new Thread(() -> {
            try {
                dataConfigurator.load(savesFile);
                if (!dataConfigurator.contains("npc-data")) {
                    return;
                }
                for (String parent : Objects.requireNonNull(dataConfigurator.getConfigurationSection("npc-data")).getKeys(false)) {
                    for (String child : Objects.requireNonNull(dataConfigurator.getConfigurationSection("npc-data." + parent)).getKeys(false)) {
                        switch (child.toLowerCase()) {
                            case "permission": {
                                this.data.put("npc-data." + parent + "." + child, dataConfigurator.getString("npc-data." + parent + "." + child));
                                break;
                            }
                            case "cooldown": {
                                this.data.put("npc-data." + parent + "." + child, dataConfigurator.getInt("npc-data." + parent + "." + child));
                                break;
                            }
                            case "right-click-commands": 
                            case "left-click-commands": {
                                this.data.put("npc-data." + parent + "." + child, dataConfigurator.getStringList("npc-data." + parent + "." + child));
                                break;
                            }
                            case "price": {
                                this.data.put("npc-data." + parent + "." + child, dataConfigurator.getDouble("npc-data." + parent + "." + child));
                            }
                        }
                    }
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void addCommand(int npc, String permission, String command, Player player, boolean left) {
        new Thread(() -> {
            try {
                ArrayList<String> commandListLeft;
                this.createBasics();
                dataConfigurator.load(savesFile);
                ArrayList<String> commandList = this.data.containsKey("npc-data.npc-" + npc + ".right-click-commands") ? (List)this.data.get("npc-data.npc-" + npc + ".right-click-commands") : new ArrayList<String>();
                List<String> list = commandListLeft = this.data.containsKey("npc-data.npc-" + npc + ".left-click-commands") ? (List)this.data.get("npc-data.npc-" + npc + ".left-click-commands") : new ArrayList<String>();
                if (!this.data.containsKey("npc-data.npc-" + npc + ".cooldown")) {
                    this.data.put("npc-data.npc-" + npc + ".cooldown", Util.getDefaultCooldown(this.plugin));
                    dataConfigurator.set("npc-data.npc-" + npc + ".cooldown", (Object)Util.getDefaultCooldown(this.plugin));
                }
                if (left) {
                    commandListLeft.add("[" + permission + "] " + command);
                } else {
                    commandList.add("[" + permission + "] " + command);
                }
                if (this.data.containsKey("npc-data.npc-" + npc + ".right-click-commands")) {
                    this.data.replace("npc-data.npc-" + npc + ".right-click-commands", commandList);
                } else {
                    this.data.put("npc-data.npc-" + npc + ".right-click-commands", commandList);
                }
                dataConfigurator.set("npc-data.npc-" + npc + ".right-click-commands", commandList);
                if (this.data.containsKey("npc-data.npc-" + npc + ".left-click-commands")) {
                    this.data.replace("npc-data.npc-" + npc + ".left-click-commands", commandListLeft);
                } else {
                    this.data.put("npc-data.npc-" + npc + ".left-click-commands", commandListLeft);
                }
                dataConfigurator.set("npc-data.npc-" + npc + ".left-click-commands", commandListLeft);
                if (!this.data.containsKey("npc-data.npc-" + npc + ".price")) {
                    this.data.put("npc-data.npc-" + npc + ".price", 0);
                    dataConfigurator.set("npc-data.npc-" + npc + ".price", (Object)0);
                }
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.NPC_ADDED));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.NPC_ADD_FAIL));
            }
        }).start();
    }

    public void addCommand(int npc, String permission, String command, boolean left) {
        new Thread(() -> {
            try {
                ArrayList<String> commandListLeft;
                this.createBasics();
                dataConfigurator.load(savesFile);
                ArrayList<String> commandList = this.data.containsKey("npc-data.npc-" + npc + ".right-click-commands") ? (List)this.data.get("npc-data.npc-" + npc + ".right-click-commands") : new ArrayList<String>();
                List<String> list = commandListLeft = this.data.containsKey("npc-data.npc-" + npc + ".left-click-commands") ? (List)this.data.get("npc-data.npc-" + npc + ".left-click-commands") : new ArrayList<String>();
                if (!this.data.containsKey("npc-data.npc-" + npc + ".cooldown")) {
                    this.data.put("npc-data.npc-" + npc + ".cooldown", Util.getDefaultCooldown(this.plugin));
                    dataConfigurator.set("npc-data.npc-" + npc + ".cooldown", (Object)Util.getDefaultCooldown(this.plugin));
                }
                if (left) {
                    commandListLeft.add("[" + permission + "] " + command);
                } else {
                    commandList.add("[" + permission + "] " + command);
                }
                if (this.data.containsKey("npc-data.npc-" + npc + ".right-click-commands")) {
                    this.data.replace("npc-data.npc-" + npc + ".right-click-commands", commandList);
                } else {
                    this.data.put("npc-data.npc-" + npc + ".right-click-commands", commandList);
                }
                dataConfigurator.set("npc-data.npc-" + npc + ".right-click-commands", commandList);
                if (this.data.containsKey("npc-data.npc-" + npc + ".left-click-commands")) {
                    this.data.replace("npc-data.npc-" + npc + ".left-click-commands", commandListLeft);
                } else {
                    this.data.put("npc-data.npc-" + npc + ".left-click-commands", commandListLeft);
                }
                dataConfigurator.set("npc-data.npc-" + npc + ".left-click-commands", commandListLeft);
                if (!this.data.containsKey("npc-data.npc-" + npc + ".price")) {
                    this.data.put("npc-data.npc-" + npc + ".price", 0);
                    dataConfigurator.set("npc-data.npc-" + npc + ".price", (Object)0);
                }
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException throwable) {
                // empty catch block
            }
        }).start();
    }

    public void setCooldown(int npc, int cooldown, Player player) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                dataConfigurator.set("npc-data.npc-" + npc + ".cooldown", (Object)cooldown);
                this.data.replace("npc-data.npc-" + npc + ".cooldown", cooldown);
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.NPC_COOLDOWN_SET));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.NPC_COOLDOWN_SET_ERROR));
            }
        }).start();
    }

    public void setPrice(int npc, double price, Player player) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                dataConfigurator.set("npc-data.npc-" + npc + ".price", (Object)price);
                this.data.replace("npc-data.npc-" + npc + ".price", price);
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.NPC_PRICE_SET));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void setCustomPermission(int npc, String permission, Player player) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                dataConfigurator.set("npc-data.npc-" + npc + ".permission", (Object)permission);
                this.data.replace("npc-data.npc-" + npc + ".permission", permission);
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.PERMISSION_SET));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void removeCustomPermission(int npc, Player player) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                if (dataConfigurator.contains("npc-data.npc-" + npc + ".permission")) {
                    dataConfigurator.set("npc-data.npc-" + npc + ".permission", null);
                }
                this.data.remove("npc-data.npc-" + npc + ".permission");
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.PERMISSION_REMOVED));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public String getCustomPermission(int npc) {
        return (String)this.data.get("npc-data.npc-" + npc + ".permission");
    }

    public boolean hasCustomPermission(int npc) {
        return this.data.containsKey("npc-data.npc-" + npc + ".permission");
    }

    public List<String> getClickCommandsData(int npc, EnumTypes.ClickType click) {
        return (List)this.data.get("npc-data.npc-" + npc + "." + click.toString().toLowerCase() + "-click-commands");
    }

    public String[] getCompleteCommandsNumbers(int npc, EnumTypes.ClickType click) {
        List commandList = (List)this.data.get("npc-data.npc-" + npc + "." + click.toString().toLowerCase() + "-click-commands");
        String[] commandSet = new String[commandList.size()];
        for (int i = 0; i < commandList.size(); ++i) {
            commandSet[i] = "" + (i + 1);
        }
        return commandSet;
    }

    public boolean hasNoCommands(int npc, EnumTypes.ClickType click) {
        String key = "npc-data.npc-" + npc + "." + click.toString().toLowerCase() + "-click-commands";
        if (this.data.containsKey(key)) {
            return ((List)this.data.get(key)).isEmpty();
        }
        return true;
    }

    public boolean hasNPCData(int npc) {
        for (String key : this.data.keySet()) {
            if (!key.contains("npc-" + npc)) continue;
            return true;
        }
        return false;
    }

    public int getNPCCooldown(int npc) {
        return this.data.containsKey("npc-data.npc-" + npc + ".cooldown") ? (Integer)this.data.get("npc-data.npc-" + npc + ".cooldown") : 0;
    }

    public double getPrice(int npc) {
        return this.data.containsKey("npc-data.npc-" + npc + ".price") ? Double.parseDouble(this.data.get("npc-data.npc-" + npc + ".price").toString()) : 0.0;
    }

    public void removeCommand(int npc, int commandID, EnumTypes.ClickType click, Player player) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                List<String> commands = this.getClickCommandsData(npc, click);
                commands.remove(commandID - 1);
                String key = "npc-data.npc-" + npc + "." + click.toString().toLowerCase() + "-click-commands";
                this.data.replace(key, commands);
                dataConfigurator.set(key, commands);
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.REMOVED_COMMAND));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void edit(int npc, int commandID, EnumTypes.ClickType click, EnumTypes.EditType type, String newValue, Player player) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                List<String> commandsData = this.getClickCommandsData(npc, click);
                String typeText = "";
                switch (type) {
                    case CMD: {
                        String tempCommand = commandsData.get(commandID - 1);
                        tempCommand = tempCommand.replaceAll(" ([^]]*)", " " + newValue);
                        commandsData.set(commandID - 1, tempCommand);
                        typeText = "CMD";
                        break;
                    }
                    case PERM: {
                        String tempPerm = commandsData.get(commandID - 1);
                        tempPerm = tempPerm.replaceAll("\\[([^]]*)]", "[" + newValue + "]");
                        commandsData.set(commandID - 1, tempPerm);
                        typeText = "PERM";
                    }
                }
                String key = "npc-data.npc-" + npc + "." + click.toString().toLowerCase() + "-click-commands";
                this.data.replace(key, commandsData);
                dataConfigurator.set(key, commandsData);
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.EDITED_COMMAND).replace("{type}", typeText));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void removeNPCData(int npc) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                if (dataConfigurator.contains("npc-data.npc-" + npc)) {
                    dataConfigurator.set("npc-data.npc-" + npc, null);
                }
                this.data.keySet().removeIf(key -> key.contains("npc-data.npc-" + npc));
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void cloneData(int npc, int npcClone) {
        new Thread(() -> {
            try {
                this.createBasics();
                dataConfigurator.load(savesFile);
                HashMap<String, Object> newNpcData = new HashMap<String, Object>();
                for (String key : this.data.keySet()) {
                    if (!key.contains("npc-" + npc)) continue;
                    String newKey = key.replace("npc-" + npc, "npc-" + npcClone);
                    newNpcData.put(newKey, this.data.get(key));
                    dataConfigurator.set(newKey, this.data.get(key));
                }
                this.data.putAll(newNpcData);
                dataConfigurator.save(savesFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }).start();
    }

    HashMap<String, Integer> getCachedCooldownByID() {
        HashMap<String, Integer> cachedData = new HashMap<String, Integer>();
        for (String key : this.data.keySet()) {
            String[] components = key.split("\\.");
            if (!components[2].equalsIgnoreCase("cooldown")) continue;
            cachedData.put(components[1], (Integer)this.data.get(key));
        }
        return cachedData;
    }

    public void reload() {
        this.initialize();
    }
}

