/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.chars;

import com.sk89q.worldedit.bukkit.fastutil.chars.CharComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class CharComparators {
    public static final CharComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final CharComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private CharComparators() {
    }

    public static CharComparator oppositeComparator(CharComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static CharComparator asCharComparator(final Comparator<? super Character> c2) {
        if (c2 == null || c2 instanceof CharComparator) {
            return (CharComparator)c2;
        }
        return new CharComparator(){

            @Override
            public int compare(char x, char y) {
                return c2.compare(Character.valueOf(x), Character.valueOf(y));
            }

            @Override
            public int compare(Character x, Character y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final CharComparator comparator;

        protected OppositeComparator(CharComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(char a2, char b) {
            return this.comparator.compare(b, a2);
        }

        @Override
        public final CharComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(char a2, char b) {
            return Character.compare(a2, b);
        }

        @Override
        public CharComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements CharComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(char a2, char b) {
            return -Character.compare(a2, b);
        }

        @Override
        public CharComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

