/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.ints;

import com.sk89q.worldedit.bukkit.fastutil.BigArrays;
import com.sk89q.worldedit.bukkit.fastutil.Hash;
import com.sk89q.worldedit.bukkit.fastutil.bytes.ByteBigArrays;
import com.sk89q.worldedit.bukkit.fastutil.ints.IntArrays;
import com.sk89q.worldedit.bukkit.fastutil.ints.IntComparator;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongBigArrays;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class IntBigArrays {
    public static final int[][] EMPTY_BIG_ARRAY = new int[0][];
    public static final int[][] DEFAULT_EMPTY_BIG_ARRAY = new int[0][];
    public static final AtomicIntegerArray[] EMPTY_BIG_ATOMIC_ARRAY = new AtomicIntegerArray[0];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;
    private static final int RADIXSORT_NO_REC = 1024;

    private IntBigArrays() {
    }

    @Deprecated
    public static int get(int[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    @Deprecated
    public static void set(int[][] array, long index, int value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    @Deprecated
    public static void swap(int[][] array, long first, long second) {
        int t = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    @Deprecated
    public static void add(int[][] array, long index, int incr) {
        int[] nArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        nArray[n] = nArray[n] + incr;
    }

    @Deprecated
    public static void mul(int[][] array, long index, int factor) {
        int[] nArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        nArray[n] = nArray[n] * factor;
    }

    @Deprecated
    public static void incr(int[][] array, long index) {
        int[] nArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        nArray[n] = nArray[n] + 1;
    }

    @Deprecated
    public static void decr(int[][] array, long index) {
        int[] nArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        nArray[n] = nArray[n] - 1;
    }

    @Deprecated
    public static long length(int[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    @Deprecated
    public static void copy(int[][] srcArray, long srcPos, int[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(int[][] srcArray, long srcPos, int[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(int[] srcArray, int srcPos, int[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static int[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = new int[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new int[0x8000000];
            }
            base[baseLength - 1] = new int[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new int[0x8000000];
            }
        }
        return base;
    }

    public static AtomicIntegerArray[] newBigAtomicArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ATOMIC_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        AtomicIntegerArray[] base = new AtomicIntegerArray[baseLength];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new AtomicIntegerArray(0x8000000);
            }
            base[baseLength - 1] = new AtomicIntegerArray(residual);
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new AtomicIntegerArray(0x8000000);
            }
        }
        return base;
    }

    @Deprecated
    public static int[][] wrap(int[] array) {
        return BigArrays.wrap(array);
    }

    @Deprecated
    public static int[][] ensureCapacity(int[][] array, long length) {
        return IntBigArrays.ensureCapacity(array, length, IntBigArrays.length(array));
    }

    @Deprecated
    public static int[][] forceCapacity(int[][] array, long length, long preserve) {
        return BigArrays.forceCapacity(array, length, preserve);
    }

    @Deprecated
    public static int[][] ensureCapacity(int[][] array, long length, long preserve) {
        return length > IntBigArrays.length(array) ? IntBigArrays.forceCapacity(array, length, preserve) : array;
    }

    @Deprecated
    public static int[][] grow(int[][] array, long length) {
        long oldLength = IntBigArrays.length(array);
        return length > oldLength ? IntBigArrays.grow(array, length, oldLength) : array;
    }

    @Deprecated
    public static int[][] grow(int[][] array, long length, long preserve) {
        long oldLength = IntBigArrays.length(array);
        return length > oldLength ? IntBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    @Deprecated
    public static int[][] trim(int[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = IntBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = (int[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = IntArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    @Deprecated
    public static int[][] setLength(int[][] array, long length) {
        return BigArrays.setLength(array, length);
    }

    @Deprecated
    public static int[][] copy(int[][] array, long offset, long length) {
        return BigArrays.copy(array, offset, length);
    }

    @Deprecated
    public static int[][] copy(int[][] array) {
        return BigArrays.copy(array);
    }

    @Deprecated
    public static void fill(int[][] array, int value) {
        int i = array.length;
        while (i-- != 0) {
            Arrays.fill(array[i], value);
        }
    }

    @Deprecated
    public static void fill(int[][] array, long from, long to, int value) {
        BigArrays.fill(array, from, to, value);
    }

    @Deprecated
    public static boolean equals(int[][] a1, int[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(int[][] a2) {
        return BigArrays.toString(a2);
    }

    @Deprecated
    public static void ensureFromTo(int[][] a2, long from, long to) {
        BigArrays.ensureFromTo(IntBigArrays.length(a2), from, to);
    }

    @Deprecated
    public static void ensureOffsetLength(int[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(IntBigArrays.length(a2), offset, length);
    }

    @Deprecated
    public static void ensureSameLength(int[][] a2, int[][] b) {
        if (IntBigArrays.length(a2) != IntBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + IntBigArrays.length(a2) + " != " + IntBigArrays.length(b));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    private static void swap(int[][] x, long a2, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            BigArrays.swap(x, a2, b);
            ++i;
            ++a2;
            ++b;
        }
    }

    private static long med3(int[][] x, long a2, long b, long c2, IntComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a2), BigArrays.get(x, b));
        int ac = comp.compare(BigArrays.get(x, a2), BigArrays.get(x, c2));
        int bc = comp.compare(BigArrays.get(x, b), BigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a2)) : (bc > 0 ? b : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(int[][] a2, long from, long to, IntComparator comp) {
        for (long i = from; i < to - 1L; ++i) {
            long m = i;
            for (long j = i + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a2, j), BigArrays.get(a2, m)) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            BigArrays.swap(a2, i, m);
        }
    }

    public static void quickSort(int[][] x, long from, long to, IntComparator comp) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            IntBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = IntBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = IntBigArrays.med3(x, m - s, m, m + s, comp);
                n = IntBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = IntBigArrays.med3(x, l, m, n, comp);
        }
        int v = BigArrays.get(x, m);
        long b = a2 = from;
        long d = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = comp.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a2++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = comp.compare(BigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            BigArrays.swap(x, b++, c2--);
        }
        long n = to;
        long s = Math.min(a2 - from, b - a2);
        IntBigArrays.swap(x, from, b - s, s);
        s = Math.min(d - c2, n - d - 1L);
        IntBigArrays.swap(x, b, n - s, s);
        s = b - a2;
        if (s > 1L) {
            IntBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c2) > 1L) {
            IntBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(int[][] x, long a2, long b, long c2) {
        int ab = Integer.compare(BigArrays.get(x, a2), BigArrays.get(x, b));
        int ac = Integer.compare(BigArrays.get(x, a2), BigArrays.get(x, c2));
        int bc = Integer.compare(BigArrays.get(x, b), BigArrays.get(x, c2));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c2 : a2)) : (bc > 0 ? b : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(int[][] a2, long from, long to) {
        for (long i = from; i < to - 1L; ++i) {
            long m = i;
            for (long j = i + 1L; j < to; ++j) {
                if (BigArrays.get(a2, j) >= BigArrays.get(a2, m)) continue;
                m = j;
            }
            if (m == i) continue;
            BigArrays.swap(a2, i, m);
        }
    }

    public static void quickSort(int[][] x, IntComparator comp) {
        IntBigArrays.quickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static void quickSort(int[][] x, long from, long to) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            IntBigArrays.selectionSort(x, from, to);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = IntBigArrays.med3(x, l, l + s, l + 2L * s);
                m = IntBigArrays.med3(x, m - s, m, m + s);
                n = IntBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = IntBigArrays.med3(x, l, m, n);
        }
        int v = BigArrays.get(x, m);
        long b = a2 = from;
        long d = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b <= c2 && (comparison = Integer.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a2++, b);
                }
                ++b;
                continue;
            }
            while (c2 >= b && (comparison = Integer.compare(BigArrays.get(x, c2), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c2, d--);
                }
                --c2;
            }
            if (b > c2) break;
            BigArrays.swap(x, b++, c2--);
        }
        long n = to;
        long s = Math.min(a2 - from, b - a2);
        IntBigArrays.swap(x, from, b - s, s);
        s = Math.min(d - c2, n - d - 1L);
        IntBigArrays.swap(x, b, n - s, s);
        s = b - a2;
        if (s > 1L) {
            IntBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c2) > 1L) {
            IntBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(int[][] x) {
        IntBigArrays.quickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(int[][] x, long from, long to) {
        ForkJoinPool pool = IntBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            IntBigArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(int[][] x) {
        IntBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(int[][] x, long from, long to, IntComparator comp) {
        ForkJoinPool pool = IntBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            IntBigArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(int[][] x, IntComparator comp) {
        IntBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static long binarySearch(int[][] a2, long from, long to, int key) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            int midVal = BigArrays.get(a2, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(int[][] a2, int key) {
        return IntBigArrays.binarySearch(a2, 0L, BigArrays.length(a2), key);
    }

    public static long binarySearch(int[][] a2, long from, long to, int key, IntComparator c2) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            int midVal = BigArrays.get(a2, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(int[][] a2, int key, IntComparator c2) {
        return IntBigArrays.binarySearch(a2, 0L, BigArrays.length(a2), key, c2);
    }

    public static void radixSort(int[][] a2) {
        IntBigArrays.radixSort(a2, 0L, BigArrays.length(a2));
    }

    public static void radixSort(int[][] a2, long from, long to) {
        int maxLevel = 3;
        int stackSize = 766;
        long[] offsetStack = new long[766];
        int offsetPos = 0;
        long[] lengthStack = new long[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 40L) {
                IntBigArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (3 - level % 4) * 8;
            long i = length;
            while (i-- != 0L) {
                BigArrays.set(digit, i, (byte)(BigArrays.get(a2, first + i) >>> shift & 0xFF ^ signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = BigArrays.get(digit, i) & 0xFF;
                count[n2] = count[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 3 && count[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count[i2];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c2 = -1;
            for (long i3 = 0L; i3 < end; i3 += count[c2]) {
                int t = BigArrays.get(a2, i3 + first);
                c2 = BigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c2;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    int z = t;
                    int zz = c2;
                    t = BigArrays.get(a2, d + first);
                    c2 = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(a2, d + first, z);
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a2, i3 + first, t);
                count[c2] = 0L;
            }
        }
    }

    private static void selectionSort(int[][] a2, int[][] b, long from, long to) {
        for (long i = from; i < to - 1L; ++i) {
            long m = i;
            for (long j = i + 1L; j < to; ++j) {
                if (BigArrays.get(a2, j) >= BigArrays.get(a2, m) && (BigArrays.get(a2, j) != BigArrays.get(a2, m) || BigArrays.get(b, j) >= BigArrays.get(b, m))) continue;
                m = j;
            }
            if (m == i) continue;
            int t = BigArrays.get(a2, i);
            BigArrays.set(a2, i, BigArrays.get(a2, m));
            BigArrays.set(a2, m, t);
            t = BigArrays.get(b, i);
            BigArrays.set(b, i, BigArrays.get(b, m));
            BigArrays.set(b, m, t);
        }
    }

    public static void radixSort(int[][] a2, int[][] b) {
        IntBigArrays.radixSort(a2, b, 0L, BigArrays.length(a2));
    }

    public static void radixSort(int[][] a2, int[][] b, long from, long to) {
        int layers = 2;
        if (BigArrays.length(a2) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 40L) {
                IntBigArrays.selectionSort(a2, b, first, first + length);
                continue;
            }
            int[][] k = level < 4 ? a2 : b;
            int shift = (3 - level % 4) * 8;
            long i = length;
            while (i-- != 0L) {
                BigArrays.set(digit, i, (byte)(BigArrays.get(k, first + i) >>> shift & 0xFF ^ signMask));
            }
            i = length;
            while (i-- != 0L) {
                int n2 = BigArrays.get(digit, i) & 0xFF;
                count[n2] = count[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0L) {
                    lastUsed = i2;
                    if (level < 7 && count[i2] > 1L) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count[i2];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c2 = -1;
            for (long i3 = 0L; i3 < end; i3 += count[c2]) {
                int t = BigArrays.get(a2, i3 + first);
                int u = BigArrays.get(b, i3 + first);
                c2 = BigArrays.get(digit, i3) & 0xFF;
                while (true) {
                    int n3 = c2;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i3) break;
                    int z = t;
                    int zz = c2;
                    t = BigArrays.get(a2, d + first);
                    BigArrays.set(a2, d + first, z);
                    z = u;
                    u = BigArrays.get(b, d + first);
                    BigArrays.set(b, d + first, z);
                    c2 = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a2, i3 + first, t);
                BigArrays.set(b, i3 + first, u);
                count[c2] = 0L;
            }
        }
    }

    private static void insertionSortIndirect(long[][] perm, int[][] a2, int[][] b, long from, long to) {
        long i = from;
        while (++i < to) {
            long t = BigArrays.get(perm, i);
            long j = i;
            long u = BigArrays.get(perm, j - 1L);
            while (BigArrays.get(a2, t) < BigArrays.get(a2, u) || BigArrays.get(a2, t) == BigArrays.get(a2, u) && BigArrays.get(b, t) < BigArrays.get(b, u)) {
                BigArrays.set(perm, j, u);
                if (from == j - 1L) {
                    --j;
                    break;
                }
                u = BigArrays.get(perm, --j - 1L);
            }
            BigArrays.set(perm, j, t);
        }
    }

    public static void radixSortIndirect(long[][] perm, int[][] a2, int[][] b, boolean stable) {
        IntBigArrays.ensureSameLength(a2, b);
        IntBigArrays.radixSortIndirect(perm, a2, b, 0L, BigArrays.length(a2), stable);
    }

    public static void radixSortIndirect(long[][] perm, int[][] a2, int[][] b, long from, long to, boolean stable) {
        long[][] support;
        if (to - from < 1024L) {
            IntBigArrays.insertionSortIndirect(perm, a2, b, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        long[] offsetStack = new long[1786];
        long[] lengthStack = new long[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        long[][] lArray = support = stable ? LongBigArrays.newBigArray(BigArrays.length(perm)) : null;
        while (stackPos > 0) {
            long first = offsetStack[--stackPos];
            long length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int[][] k = level < 4 ? a2 : b;
            int shift = (3 - level % 4) * 8;
            long i = first + length;
            while (i-- != first) {
                int n = BigArrays.get(k, BigArrays.get(perm, i)) >>> shift & 0xFF ^ signMask;
                count[n] = count[n] + 1L;
            }
            int lastUsed = -1;
            long p = stable ? 0L : first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0L) {
                    lastUsed = i2;
                }
                pos[i2] = p += count[i2];
            }
            if (stable) {
                long i3 = first + length;
                while (i3-- != first) {
                    int n = BigArrays.get(k, BigArrays.get(perm, i3)) >>> shift & 0xFF ^ signMask;
                    long l = pos[n] - 1L;
                    pos[n] = l;
                    BigArrays.set(support, l, BigArrays.get(perm, i3));
                }
                BigArrays.copy(support, 0L, perm, first, length);
                p = first;
                for (int i4 = 0; i4 < 256; ++i4) {
                    if (level < 7 && count[i4] > 1L) {
                        if (count[i4] < 1024L) {
                            IntBigArrays.insertionSortIndirect(perm, a2, b, p, p + count[i4]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count[i4];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count[i4];
                }
                Arrays.fill(count, 0L);
                continue;
            }
            long end = first + length - count[lastUsed];
            int c2 = -1;
            for (long i5 = first; i5 <= end; i5 += count[c2]) {
                long t = BigArrays.get(perm, i5);
                c2 = BigArrays.get(k, t) >>> shift & 0xFF ^ signMask;
                if (i5 < end) {
                    while (true) {
                        int n = c2;
                        long l = pos[n] - 1L;
                        pos[n] = l;
                        long d = l;
                        if (l <= i5) break;
                        long z = t;
                        t = BigArrays.get(perm, d);
                        BigArrays.set(perm, d, z);
                        c2 = BigArrays.get(k, t) >>> shift & 0xFF ^ signMask;
                    }
                    BigArrays.set(perm, i5, t);
                }
                if (level < 7 && count[c2] > 1L) {
                    if (count[c2] < 1024L) {
                        IntBigArrays.insertionSortIndirect(perm, a2, b, i5, i5 + count[c2]);
                    } else {
                        offsetStack[stackPos] = i5;
                        lengthStack[stackPos] = count[c2];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c2] = 0L;
            }
        }
    }

    public static int[][] shuffle(int[][] a2, long from, long to, Random random) {
        return BigArrays.shuffle(a2, from, to, random);
    }

    public static int[][] shuffle(int[][] a2, Random random) {
        return BigArrays.shuffle(a2, random);
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final int[][] x;

        public ForkJoinQuickSort(int[][] x, long from, long to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            long c2;
            long a2;
            int[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                IntBigArrays.quickSort(x, this.from, this.to);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = IntBigArrays.med3(x, l, l + s, l + 2L * s);
            m = IntBigArrays.med3(x, m - s, m, m + s);
            n = IntBigArrays.med3(x, n - 2L * s, n - s, n);
            m = IntBigArrays.med3(x, l, m, n);
            int v = BigArrays.get(x, m);
            long b = a2 = this.from;
            long d = c2 = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = Integer.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a2++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = Integer.compare(BigArrays.get(x, c2), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                BigArrays.swap(x, b++, c2--);
            }
            s = Math.min(a2 - this.from, b - a2);
            IntBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1L);
            IntBigArrays.swap(x, b, this.to - s, s);
            s = b - a2;
            long t = d - c2;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final int[][] x;
        private final IntComparator comp;

        public ForkJoinQuickSortComp(int[][] x, long from, long to, IntComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            long c2;
            long a2;
            int[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                IntBigArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = IntBigArrays.med3(x, l, l + s, l + 2L * s, this.comp);
            m = IntBigArrays.med3(x, m - s, m, m + s, this.comp);
            n = IntBigArrays.med3(x, n - 2L * s, n - s, n, this.comp);
            m = IntBigArrays.med3(x, l, m, n, this.comp);
            int v = BigArrays.get(x, m);
            long b = a2 = this.from;
            long d = c2 = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c2 && (comparison = this.comp.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a2++, b);
                    }
                    ++b;
                    continue;
                }
                while (c2 >= b && (comparison = this.comp.compare(BigArrays.get(x, c2), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c2, d--);
                    }
                    --c2;
                }
                if (b > c2) break;
                BigArrays.swap(x, b++, c2--);
            }
            s = Math.min(a2 - this.from, b - a2);
            IntBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c2, this.to - d - 1L);
            IntBigArrays.swap(x, b, this.to - s, s);
            s = b - a2;
            long t = d - c2;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<int[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(int[][] a2, int[][] b) {
            return IntBigArrays.equals(a2, b);
        }
    }
}

