/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;

public abstract class TabFeature {
    private final String featureName;
    private final String refreshDisplayName;
    protected String[] disabledServers = new String[0];
    private boolean serverWhitelistMode = false;
    protected String[] disabledWorlds = new String[0];
    private boolean worldWhitelistMode = false;
    private final Set<TabPlayer> disabledPlayers = Collections.newSetFromMap(new WeakHashMap());
    private final List<String> methodOverrides = new ArrayList<String>();

    protected TabFeature(String featureName, String refreshDisplayName) {
        this.featureName = featureName;
        this.refreshDisplayName = refreshDisplayName;
        try {
            if (this.getClass().getMethod("onCommand", TabPlayer.class, String.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onCommand");
            }
            if (this.getClass().getMethod("onJoin", TabPlayer.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onJoin");
            }
            if (this.getClass().getMethod("onQuit", TabPlayer.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onQuit");
            }
            if (this.getClass().getMethod("onWorldChange", TabPlayer.class, String.class, String.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onWorldChange");
            }
            if (this.getClass().getMethod("onServerChange", TabPlayer.class, String.class, String.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onServerChange");
            }
            if (this.getClass().getMethod("onDisplayObjective", TabPlayer.class, PacketPlayOutScoreboardDisplayObjective.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onDisplayObjective");
                TabAPI.getInstance().getFeatureManager().markDisplayObjective();
            }
            if (this.getClass().getMethod("onLoginPacket", TabPlayer.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onLoginPacket");
            }
            if (this.getClass().getMethod("onObjective", TabPlayer.class, PacketPlayOutScoreboardObjective.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onObjective");
                TabAPI.getInstance().getFeatureManager().markObjective();
            }
            if (this.getClass().getMethod("onPlayerInfo", TabPlayer.class, PacketPlayOutPlayerInfo.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onPlayerInfo");
            }
            if (this.getClass().getMethod("onPacketReceive", TabPlayer.class, Object.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onPacketReceive");
            }
            if (this.getClass().getMethod("onPacketSend", TabPlayer.class, Object.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onPacketSend");
            }
            if (this.getClass().getMethod("refresh", TabPlayer.class, Boolean.TYPE).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("refresh");
            }
            if (this.getClass().getMethod("onVanishStatusChange", TabPlayer.class).getDeclaringClass() != TabFeature.class) {
                this.methodOverrides.add("onVanishStatusChange");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected TabFeature(String featureName, String refreshDisplayName, String configSection) {
        this(featureName, refreshDisplayName);
        List<String> disabledServers = TabAPI.getInstance().getConfig().getStringList(configSection + ".disable-in-servers");
        List<String> disabledWorlds = TabAPI.getInstance().getConfig().getStringList(configSection + ".disable-in-worlds");
        if (disabledServers != null) {
            this.disabledServers = disabledServers.toArray(new String[0]);
            this.serverWhitelistMode = disabledServers.contains("WHITELIST");
        }
        if (disabledWorlds != null) {
            this.disabledWorlds = disabledWorlds.toArray(new String[0]);
            this.worldWhitelistMode = disabledWorlds.contains("WHITELIST");
        }
    }

    public void load() {
    }

    public void unload() {
    }

    public boolean onCommand(TabPlayer sender, String message) {
        return false;
    }

    public void onJoin(TabPlayer connectedPlayer) {
    }

    public void onQuit(TabPlayer disconnectedPlayer) {
    }

    public void onWorldChange(TabPlayer changed, String from, String to) {
    }

    public void onServerChange(TabPlayer changed, String from, String to) {
    }

    public void onDisplayObjective(TabPlayer receiver, PacketPlayOutScoreboardDisplayObjective packet) {
    }

    public void onLoginPacket(TabPlayer packetReceiver) {
    }

    public void onObjective(TabPlayer receiver, PacketPlayOutScoreboardObjective packet) {
    }

    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
    }

    public boolean onPacketReceive(TabPlayer sender, Object packet) throws ReflectiveOperationException {
        return false;
    }

    public void onPacketSend(TabPlayer receiver, Object packet) throws ReflectiveOperationException {
    }

    public void refresh(TabPlayer refreshed, boolean force) {
    }

    public void onVanishStatusChange(TabPlayer player) {
    }

    public void addUsedPlaceholders(Collection<String> placeholders) {
        if (placeholders.isEmpty()) {
            return;
        }
        placeholders.forEach(p -> TabAPI.getInstance().getPlaceholderManager().addUsedPlaceholder((String)p, this));
    }

    public boolean isDisabled(String server, String world) {
        boolean contains = this.contains(this.disabledWorlds, world);
        if (this.worldWhitelistMode) {
            boolean bl = contains = !contains;
        }
        if (contains) {
            return true;
        }
        contains = this.contains(this.disabledServers, server);
        if (this.serverWhitelistMode) {
            contains = !contains;
        }
        return contains;
    }

    protected boolean contains(String[] list, String element) {
        if (element == null) {
            return false;
        }
        for (String s : list) {
            if (!(s.endsWith("*") ? element.toLowerCase().startsWith(s.substring(0, s.length() - 1).toLowerCase()) : element.equalsIgnoreCase(s))) continue;
            return true;
        }
        return false;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getRefreshDisplayName() {
        return this.refreshDisplayName;
    }

    public boolean overridesMethod(String method) {
        return this.methodOverrides.contains(method);
    }

    public boolean isDisabledPlayer(TabPlayer p) {
        return this.disabledPlayers.contains(p);
    }

    public void addDisabledPlayer(TabPlayer p) {
        if (this.disabledPlayers.contains(p)) {
            return;
        }
        this.disabledPlayers.add(p);
    }

    public void removeDisabledPlayer(TabPlayer p) {
        this.disabledPlayers.remove(p);
    }
}

