/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat;

import java.util.List;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.chat.ChatClickable;
import me.neznamy.tab.api.chat.ChatHoverable;
import me.neznamy.tab.api.chat.ChatModifier;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.chat.TextColor;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.libs.org.json.simple.JSONObject;
import me.neznamy.tab.libs.org.json.simple.parser.JSONParser;
import me.neznamy.tab.libs.org.json.simple.parser.ParseException;

public class DeserializedChatComponent
extends IChatBaseComponent {
    private final String json;
    private boolean deserialized;
    private boolean modified;

    public DeserializedChatComponent(String json) {
        Preconditions.checkNotNull(json, "json");
        this.json = json;
    }

    @Override
    public String toString() {
        if (this.modified) {
            return super.toString();
        }
        return this.json;
    }

    @Override
    public String toString(ProtocolVersion clientVersion) {
        if (this.modified) {
            return super.toString(clientVersion);
        }
        return this.json;
    }

    @Override
    public List<IChatBaseComponent> getExtra() {
        if (!this.deserialized) {
            this.deserialize();
        }
        return super.getExtra();
    }

    @Override
    public String getText() {
        if (!this.deserialized) {
            this.deserialize();
        }
        return super.getText();
    }

    @Override
    public ChatModifier getModifier() {
        if (!this.deserialized) {
            this.deserialize();
        }
        return super.getModifier();
    }

    @Override
    public IChatBaseComponent setExtra(List<IChatBaseComponent> components) {
        if (!this.deserialized) {
            this.deserialize();
        }
        this.modified = true;
        return super.setExtra(components);
    }

    @Override
    public void addExtra(IChatBaseComponent child) {
        if (!this.deserialized) {
            this.deserialize();
        }
        this.modified = true;
        super.addExtra(child);
    }

    @Override
    public void setModifier(ChatModifier modifier) {
        if (!this.deserialized) {
            this.deserialize();
        }
        this.modified = true;
        super.setModifier(modifier);
    }

    void deserialize() {
        String value;
        String action;
        JSONObject jsonObject;
        this.deserialized = true;
        if (this.json.startsWith("\"") && this.json.endsWith("\"") && this.json.length() > 1) {
            this.setText(this.json.substring(1, this.json.length() - 1));
            return;
        }
        try {
            jsonObject = (JSONObject)new JSONParser().parse(this.json);
        }
        catch (ParseException e) {
            TabAPI.getInstance().logError("Failed to deserialize json component " + this.json, e);
            return;
        }
        this.setText((String)jsonObject.get("text"));
        this.getModifier().setBold(DeserializedChatComponent.getBoolean(jsonObject, "bold"));
        this.getModifier().setItalic(DeserializedChatComponent.getBoolean(jsonObject, "italic"));
        this.getModifier().setUnderlined(DeserializedChatComponent.getBoolean(jsonObject, "underlined"));
        this.getModifier().setStrikethrough(DeserializedChatComponent.getBoolean(jsonObject, "strikethrough"));
        this.getModifier().setObfuscated(DeserializedChatComponent.getBoolean(jsonObject, "obfuscated"));
        this.getModifier().setColor(TextColor.fromString((String)jsonObject.get("color")));
        if (jsonObject.containsKey("clickEvent")) {
            JSONObject clickEvent = (JSONObject)jsonObject.get("clickEvent");
            action = (String)clickEvent.get("action");
            value = clickEvent.get("value").toString();
            this.getModifier().onClick(ChatClickable.EnumClickAction.valueOf(action.toUpperCase()), value);
        }
        if (jsonObject.containsKey("hoverEvent")) {
            JSONObject hoverEvent = (JSONObject)jsonObject.get("hoverEvent");
            action = (String)hoverEvent.get("action");
            value = (String)hoverEvent.get("value");
            this.getModifier().onHover(ChatHoverable.EnumHoverAction.valueOf(action.toUpperCase()), DeserializedChatComponent.deserialize(value));
        }
        if (jsonObject.containsKey("extra")) {
            List list = (List)jsonObject.get("extra");
            for (Object extra : list) {
                String string = extra.toString();
                if (!string.startsWith("{")) {
                    string = "\"" + string + "\"";
                }
                this.addExtra(IChatBaseComponent.deserialize(string));
            }
        }
    }

    private static Boolean getBoolean(JSONObject jsonObject, String key) {
        Preconditions.checkNotNull(jsonObject, "json object");
        Preconditions.checkNotNull(key, "key");
        String value = String.valueOf(jsonObject.getOrDefault(key, null));
        return "null".equals(value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }
}

