/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat;

import me.neznamy.tab.api.chat.rgb.RGBUtils;

public enum EnumChatFormat {
    BLACK('0', "000000"),
    DARK_BLUE('1', "0000AA"),
    DARK_GREEN('2', "00AA00"),
    DARK_AQUA('3', "00AAAA"),
    DARK_RED('4', "AA0000"),
    DARK_PURPLE('5', "AA00AA"),
    GOLD('6', "FFAA00"),
    GRAY('7', "AAAAAA"),
    DARK_GRAY('8', "555555"),
    BLUE('9', "5555FF"),
    GREEN('a', "55FF55"),
    AQUA('b', "55FFFF"),
    RED('c', "FF5555"),
    LIGHT_PURPLE('d', "FF55FF"),
    YELLOW('e', "FFFF55"),
    WHITE('f', "FFFFFF"),
    OBFUSCATED('k'),
    BOLD('l'),
    STRIKETHROUGH('m'),
    UNDERLINE('n'),
    ITALIC('o'),
    RESET('r');

    public static final EnumChatFormat[] VALUES;
    public static final char COLOR_CHAR = '\u00a7';
    public static final String COLOR_STRING;
    private final char character;
    private final short red;
    private final short green;
    private final short blue;
    private final String hexCode;
    private final String chatFormat;

    private EnumChatFormat(char character, String hexCode) {
        this.character = character;
        this.chatFormat = String.valueOf('\u00a7') + character;
        this.hexCode = hexCode;
        int hexColor = Integer.parseInt(hexCode, 16);
        this.red = (short)(hexColor >> 16 & 0xFF);
        this.green = (short)(hexColor >> 8 & 0xFF);
        this.blue = (short)(hexColor & 0xFF);
    }

    private EnumChatFormat(char character) {
        this.character = character;
        this.chatFormat = String.valueOf('\u00a7') + character;
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.hexCode = null;
    }

    public short getRed() {
        return this.red;
    }

    public short getGreen() {
        return this.green;
    }

    public short getBlue() {
        return this.blue;
    }

    public static EnumChatFormat getByChar(char c) {
        for (EnumChatFormat format : VALUES) {
            if (format.character != c) continue;
            return format;
        }
        return null;
    }

    public static EnumChatFormat lastColorsOf(String string) {
        if (string == null || string.length() == 0) {
            return WHITE;
        }
        String legacyText = RGBUtils.getInstance().convertRGBtoLegacy(string);
        String last = EnumChatFormat.getLastColors(legacyText);
        if (last.length() > 0) {
            char c = last.toCharArray()[1];
            for (EnumChatFormat e : VALUES) {
                if (e.character != c) continue;
                return e;
            }
        }
        return WHITE;
    }

    public String getFormat() {
        return this.chatFormat;
    }

    public char getCharacter() {
        return this.character;
    }

    public String getHexCode() {
        return this.hexCode;
    }

    public static EnumChatFormat fromRGBExact(int red, int green, int blue) {
        for (EnumChatFormat format : VALUES) {
            if (format.red != red || format.green != green || format.blue != blue) continue;
            return format;
        }
        return null;
    }

    public static String color(String textToTranslate) {
        if (textToTranslate == null) {
            return null;
        }
        if (!textToTranslate.contains("&")) {
            return textToTranslate;
        }
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String decolor(String text) {
        if (text == null) {
            return null;
        }
        if (!text.contains(COLOR_STRING)) {
            return text;
        }
        return text.replace('\u00a7', '&');
    }

    public static String getLastColors(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            char section = input.charAt(index);
            if (section != '\u00a7' && section != '&' || index >= length - 1 || !"0123456789AaBbCcDdEeFfKkLlMmNnOoRr".contains(String.valueOf(c = input.charAt(index + 1)))) continue;
            result.insert(0, '\u00a7');
            result.insert(1, c);
            if ("0123456789AaBbCcDdEeFfRr".contains(String.valueOf(c))) break;
        }
        return result.toString();
    }

    static {
        VALUES = EnumChatFormat.values();
        COLOR_STRING = String.valueOf('\u00a7');
    }
}

