/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import java.util.UUID;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.Preconditions;

public class PacketPlayOutBoss
implements TabPacket {
    private final UUID id;
    private final Action action;
    private String name;
    private float pct;
    private BarColor color;
    private BarStyle overlay;
    private boolean darkenScreen;
    private boolean playMusic;
    private boolean createWorldFog;

    public PacketPlayOutBoss(UUID id, String name, float pct, BarColor color, BarStyle overlay) {
        Preconditions.checkNotNull(id, "uuid");
        Preconditions.checkNotNull(name, "title");
        Preconditions.checkNotNull((Object)color, "color");
        Preconditions.checkNotNull((Object)overlay, "style");
        this.action = Action.ADD;
        this.id = id;
        this.name = name;
        this.pct = pct;
        this.color = color;
        this.overlay = overlay;
    }

    public PacketPlayOutBoss(UUID id) {
        Preconditions.checkNotNull(id, "uuid");
        this.action = Action.REMOVE;
        this.id = id;
    }

    public PacketPlayOutBoss(UUID id, float pct) {
        Preconditions.checkNotNull(id, "uuid");
        this.action = Action.UPDATE_PCT;
        this.id = id;
        this.pct = pct;
    }

    public PacketPlayOutBoss(UUID id, String name) {
        Preconditions.checkNotNull(id, "uuid");
        Preconditions.checkNotNull(name, "title");
        this.action = Action.UPDATE_NAME;
        this.id = id;
        this.name = name;
    }

    public PacketPlayOutBoss(UUID id, BarColor color, BarStyle overlay) {
        Preconditions.checkNotNull(id, "uuid");
        Preconditions.checkNotNull((Object)color, "color");
        Preconditions.checkNotNull((Object)overlay, "style");
        this.action = Action.UPDATE_STYLE;
        this.id = id;
        this.color = color;
        this.overlay = overlay;
    }

    public PacketPlayOutBoss(UUID id, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
        Preconditions.checkNotNull(id, "uuid");
        this.action = Action.UPDATE_PROPERTIES;
        this.id = id;
        this.darkenScreen = darkenScreen;
        this.playMusic = playMusic;
        this.createWorldFog = createWorldFog;
    }

    public byte getFlags() {
        byte value = 0;
        if (this.darkenScreen) {
            value = (byte)(value + 1);
        }
        if (this.playMusic) {
            value = (byte)(value + 2);
        }
        if (this.createWorldFog) {
            value = (byte)(value + 4);
        }
        return value;
    }

    @Override
    public String toString() {
        return String.format("PacketPlayOutBoss{id=%s,operation=%s,name=%s,pct=%s,color=%s,overlay=%s,darkenScreen=%s,playMusic=%s,createWorldFog=%s}", new Object[]{this.id, this.action, this.name, Float.valueOf(this.pct), this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog});
    }

    public BarColor getColor() {
        return this.color;
    }

    public BarStyle getOverlay() {
        return this.overlay;
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public float getPct() {
        return this.pct;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean isDarkenScreen() {
        return this.darkenScreen;
    }

    public boolean isCreateWorldFog() {
        return this.createWorldFog;
    }

    public boolean isPlayMusic() {
        return this.playMusic;
    }

    public void setDarkenScreen(boolean darkenScreen) {
        this.darkenScreen = darkenScreen;
    }

    public void setCreateWorldFog(boolean createWorldFog) {
        this.createWorldFog = createWorldFog;
    }

    public void setPlayMusic(boolean playMusic) {
        this.playMusic = playMusic;
    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE_PCT,
        UPDATE_NAME,
        UPDATE_STYLE,
        UPDATE_PROPERTIES;

    }
}

