/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.Preconditions;

public class PacketPlayOutScoreboardObjective
implements TabPacket {
    private final String objectiveName;
    private final String displayName;
    private final EnumScoreboardHealthDisplay renderType;
    private final int action;

    public PacketPlayOutScoreboardObjective(int action, String objectiveName, String displayName, EnumScoreboardHealthDisplay renderType) {
        Preconditions.checkRange(action, 0, 2, "action");
        Preconditions.checkNotNull(objectiveName, "objective name");
        Preconditions.checkMaxLength(objectiveName, 16, "objective name");
        Preconditions.checkNotNull((Object)renderType, "render type");
        this.objectiveName = objectiveName;
        this.displayName = displayName;
        this.renderType = renderType;
        this.action = action;
    }

    public PacketPlayOutScoreboardObjective(String objectiveName) {
        Preconditions.checkNotNull(objectiveName, "objective name");
        Preconditions.checkMaxLength(objectiveName, 16, "objective name");
        this.objectiveName = objectiveName;
        this.displayName = "";
        this.action = 1;
        this.renderType = null;
    }

    @Override
    public String toString() {
        return String.format("PacketPlayOutScoreboardObjective{objectiveName=%s,displayName=%s,renderType=%s,method=%s}", new Object[]{this.objectiveName, this.displayName, this.renderType, this.action});
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public EnumScoreboardHealthDisplay getRenderType() {
        return this.renderType;
    }

    public int getAction() {
        return this.action;
    }

    public static enum EnumScoreboardHealthDisplay {
        INTEGER,
        HEARTS;

    }
}

