/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.Preconditions;

public class PacketPlayOutScoreboardScore
implements TabPacket {
    private final Action action;
    private final String objectiveName;
    private final String player;
    private final int score;

    public PacketPlayOutScoreboardScore(Action action, String objectiveName, String player, int score) {
        Preconditions.checkNotNull((Object)action, "action");
        Preconditions.checkNotNull(objectiveName, "objective name");
        Preconditions.checkMaxLength(objectiveName, 16, "objective name");
        Preconditions.checkNotNull(player, "player");
        this.action = action;
        this.objectiveName = objectiveName;
        this.player = player;
        this.score = score;
    }

    @Override
    public String toString() {
        return String.format("PacketPlayOutScoreboardScore{action=%s,objectiveName=%s,player=%s,score=%s}", new Object[]{this.action, this.objectiveName, this.player, this.score});
    }

    public Action getAction() {
        return this.action;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public String getPlayer() {
        return this.player;
    }

    public int getScore() {
        return this.score;
    }

    public static enum Action {
        CHANGE,
        REMOVE;

    }
}

