/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.UUID;
import me.neznamy.tab.api.ArmorStand;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitArmorStandManager;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitNameTagX;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityDestroy;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityMetadata;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityTeleport;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutSpawnEntityLiving;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcher;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;

public class BukkitArmorStand
implements ArmorStand {
    private static int idCounter = 2000000000;
    private final BukkitNameTagX manager = (BukkitNameTagX)TabAPI.getInstance().getFeatureManager().getFeature("NameTagX");
    private final BukkitArmorStandManager asm;
    private final TabPlayer owner;
    private final Player player;
    private double yOffset;
    private final int entityId = idCounter++;
    private final UUID uuid = UUID.randomUUID();
    private boolean sneaking;
    private boolean visible;
    private final Property property;
    private final boolean staticOffset;
    private final PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(this.entityId);

    public BukkitArmorStand(BukkitArmorStandManager asm, TabPlayer owner, String propertyName, double yOffset, boolean staticOffset) {
        this.asm = asm;
        this.owner = owner;
        this.staticOffset = staticOffset;
        this.player = (Player)owner.getPlayer();
        this.yOffset = yOffset;
        this.property = owner.getProperty(propertyName);
        this.visible = this.getVisibility();
        this.sneaking = this.player.isSneaking();
    }

    @Override
    public void refresh() {
        this.visible = this.getVisibility();
        this.updateMetadata();
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public boolean hasStaticOffset() {
        return this.staticOffset;
    }

    @Override
    public double getOffset() {
        return this.yOffset;
    }

    @Override
    public void setOffset(double offset) {
        if (this.yOffset == offset) {
            return;
        }
        this.yOffset = offset;
        for (TabPlayer all : this.asm.getNearbyPlayers()) {
            all.sendCustomPacket((TabPacket)this.getTeleportPacket(all), "Unlimited NameTags (Changing offset)");
        }
    }

    @Override
    public void spawn(TabPlayer viewer) {
        for (TabPacket packet : this.getSpawnPackets(viewer)) {
            viewer.sendCustomPacket(packet, "Unlimited NameTags (Spawning)");
        }
    }

    @Override
    public void destroy() {
        for (TabPlayer all : this.asm.getNearbyPlayers()) {
            all.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Despawning)");
        }
    }

    @Override
    public void destroy(TabPlayer viewer) {
        viewer.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Despawning)");
    }

    @Override
    public void teleport() {
        for (TabPlayer all : this.asm.getNearbyPlayers()) {
            all.sendCustomPacket((TabPacket)this.getTeleportPacket(all), "Unlimited NameTags (Teleporting)");
        }
    }

    @Override
    public void teleport(TabPlayer viewer) {
        if (!this.asm.isNearby(viewer) && viewer != this.owner) {
            this.asm.spawn(viewer);
        } else {
            viewer.sendCustomPacket((TabPacket)this.getTeleportPacket(viewer), "Unlimited NameTags (Teleporting)");
        }
    }

    @Override
    public void sneak(boolean sneaking) {
        if (this.sneaking == sneaking) {
            return;
        }
        this.sneaking = sneaking;
        for (TabPlayer viewer : this.asm.getNearbyPlayers()) {
            if (viewer.getVersion().getMinorVersion() == 14 && !this.manager.isArmorStandsAlwaysVisible()) {
                if (sneaking) {
                    viewer.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Sneaking)");
                    continue;
                }
                this.spawn(viewer);
                continue;
            }
            this.respawn(viewer);
        }
    }

    @Override
    public void updateVisibility(boolean force) {
        boolean visibility = this.getVisibility();
        if (this.visible != visibility || force) {
            this.refresh();
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    public PacketPlayOutEntityTeleport getTeleportPacket(TabPlayer viewer) {
        return new PacketPlayOutEntityTeleport(this.entityId, this.getArmorStandLocationFor(viewer));
    }

    public void updateMetadata() {
        for (TabPlayer viewer : this.asm.getNearbyPlayers()) {
            viewer.sendCustomPacket((TabPacket)new PacketPlayOutEntityMetadata(this.entityId, this.createDataWatcher(this.property.getFormat(viewer), viewer)), "Unlimited NameTags (Metadata)");
        }
    }

    public boolean getVisibility() {
        if (this.manager.isArmorStandsAlwaysVisible()) {
            return true;
        }
        if (this.owner.isDisguised() || this.manager.getVehicleManager().isOnBoat(this.owner)) {
            return false;
        }
        return !this.owner.hasInvisibilityPotion() && this.owner.getGamemode() != 3 && !this.manager.hasHiddenNametag(this.owner) && this.property.get().length() > 0;
    }

    public Location getLocation(TabPlayer viewer) {
        double x = this.player.getLocation().getX();
        double y = this.getY() + this.yOffset;
        double z = this.player.getLocation().getZ();
        y = !this.player.isSleeping() ? (this.sneaking ? (viewer.getVersion().getMinorVersion() >= 15 ? (y += 1.37) : (viewer.getVersion().getMinorVersion() >= 9 ? (y += 1.52) : (y += 1.7))) : (y += viewer.getVersion().getMinorVersion() >= 9 ? 1.8 : 1.84)) : (y += viewer.getVersion().getMinorVersion() >= 9 ? 0.2 : 0.26);
        return new Location(null, x, y, z);
    }

    protected double getY() {
        Entity vehicle = this.player.getVehicle();
        if (vehicle != null) {
            if (vehicle.getType().toString().contains("HORSE")) {
                return vehicle.getLocation().getY() + 0.85;
            }
            if (vehicle.getType().toString().equals("DONKEY")) {
                return vehicle.getLocation().getY() + 0.525;
            }
            if (vehicle.getType() == EntityType.PIG) {
                return vehicle.getLocation().getY() + 0.325;
            }
            if (vehicle.getType().toString().equals("STRIDER")) {
                return vehicle.getLocation().getY() + 1.15;
            }
        }
        if (this.isSwimming() || TabAPI.getInstance().getServerVersion().getMinorVersion() >= 9 && this.player.isGliding()) {
            return this.player.getLocation().getY() - 1.22;
        }
        return this.player.getLocation().getY();
    }

    private boolean isSwimming() {
        if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 14 && this.player.getPose() == Pose.SWIMMING) {
            return true;
        }
        return TabAPI.getInstance().getServerVersion().getMinorVersion() == 13 && this.player.isSwimming();
    }

    public DataWatcher createDataWatcher(String displayName, TabPlayer viewer) {
        DataWatcher datawatcher = new DataWatcher();
        byte flag = 32;
        if (this.sneaking) {
            flag = (byte)(flag + 2);
        }
        datawatcher.helper().setEntityFlags(flag);
        datawatcher.helper().setCustomName(displayName, viewer.getVersion());
        boolean visibility = this.isNameVisiblyEmpty(displayName) || !((Player)viewer.getPlayer()).canSee(this.player) || this.manager.hasHiddenNametag(this.owner, viewer) || this.manager.hasHiddenNameTagVisibilityView(viewer) ? false : this.visible;
        datawatcher.helper().setCustomNameVisible(visibility);
        if (viewer.getVersion().getMinorVersion() > 8 || this.manager.isMarkerFor18x()) {
            datawatcher.helper().setArmorStandFlags((byte)16);
        }
        return datawatcher;
    }

    private boolean isNameVisiblyEmpty(String displayName) {
        if (displayName.length() == 0) {
            return true;
        }
        if (!(displayName.startsWith(EnumChatFormat.COLOR_STRING) || displayName.startsWith("&") || displayName.startsWith("#"))) {
            return false;
        }
        String text = IChatBaseComponent.fromColoredText(displayName).toRawText();
        if (text.contains(" ")) {
            text = text.replace(" ", "");
        }
        return text.length() == 0;
    }

    public TabPacket[] getSpawnPackets(TabPlayer viewer) {
        this.visible = this.getVisibility();
        DataWatcher dataWatcher = this.createDataWatcher(this.property.getFormat(viewer), viewer);
        if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 15) {
            return new TabPacket[]{new PacketPlayOutSpawnEntityLiving(this.entityId, this.uuid, EntityType.ARMOR_STAND, this.getArmorStandLocationFor(viewer), null), new PacketPlayOutEntityMetadata(this.entityId, dataWatcher)};
        }
        return new TabPacket[]{new PacketPlayOutSpawnEntityLiving(this.entityId, this.uuid, EntityType.ARMOR_STAND, this.getArmorStandLocationFor(viewer), dataWatcher)};
    }

    public Location getArmorStandLocationFor(TabPlayer viewer) {
        return viewer.getVersion().getMinorVersion() == 8 && !this.manager.isMarkerFor18x() ? this.getLocation(viewer).add(0.0, -2.0, 0.0) : this.getLocation(viewer);
    }

    @Override
    public void respawn(TabPlayer viewer) {
        viewer.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Despawning)");
        this.spawn(viewer);
    }
}

