/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitNameTagX;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VehicleRefresher
extends TabFeature {
    private final WeakHashMap<TabPlayer, Entity> playersInVehicle = new WeakHashMap();
    private final Map<Integer, List<Entity>> vehicles = new ConcurrentHashMap<Integer, List<Entity>>();
    private final Set<TabPlayer> playersOnBoats = Collections.newSetFromMap(new WeakHashMap());
    private final BukkitNameTagX feature;

    public VehicleRefresher(BukkitNameTagX feature) {
        super(feature.getFeatureName(), "Refreshing vehicles");
        this.feature = feature;
        TabAPI.getInstance().getThreadManager().startRepeatingMeasuredTask(50, this, "Processing player movement", () -> {
            for (TabPlayer inVehicle : this.playersInVehicle.keySet()) {
                if (!inVehicle.isOnline() || feature.getArmorStandManager(inVehicle) == null) continue;
                feature.getArmorStandManager(inVehicle).teleport();
            }
            for (TabPlayer p : TabAPI.getInstance().getOnlinePlayers()) {
                if (!feature.isPreviewingNametag(p)) continue;
                feature.getArmorStandManager(p).teleport(p);
            }
        });
        this.addUsedPlaceholders(Collections.singletonList("%vehicle%"));
        TabAPI.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%vehicle%", 100, p -> ((Player)p.getPlayer()).getVehicle() == null ? "" : ((Player)p.getPlayer()).getVehicle());
    }

    @Override
    public void load() {
        for (TabPlayer p : TabAPI.getInstance().getOnlinePlayers()) {
            Entity vehicle = ((Player)p.getPlayer()).getVehicle();
            if (vehicle == null) continue;
            this.vehicles.put(vehicle.getEntityId(), this.getPassengers(vehicle));
            this.playersInVehicle.put(p, vehicle);
            if (!this.feature.isDisableOnBoats() || !vehicle.getType().toString().contains("BOAT")) continue;
            this.playersOnBoats.add(p);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        Entity vehicle = ((Entity)connectedPlayer.getPlayer()).getVehicle();
        if (vehicle != null) {
            this.vehicles.put(vehicle.getEntityId(), this.getPassengers(vehicle));
        }
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        if (this.playersInVehicle.containsKey(disconnectedPlayer)) {
            this.vehicles.remove(this.playersInVehicle.get(disconnectedPlayer).getEntityId());
        }
        for (List<Entity> entities : this.vehicles.values()) {
            entities.remove((Player)disconnectedPlayer.getPlayer());
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (this.feature.isPlayerDisabled(p)) {
            return;
        }
        Entity vehicle = ((Player)p.getPlayer()).getVehicle();
        if (this.playersInVehicle.containsKey(p) && vehicle == null) {
            this.vehicles.remove(this.playersInVehicle.get(p).getEntityId());
            this.feature.getArmorStandManager(p).teleport();
            this.playersInVehicle.remove(p);
            if (this.feature.isDisableOnBoats() && this.playersOnBoats.contains(p)) {
                this.playersOnBoats.remove(p);
                this.feature.updateTeamData(p);
            }
        }
        if (!this.playersInVehicle.containsKey(p) && vehicle != null) {
            this.vehicles.put(vehicle.getEntityId(), this.getPassengers(vehicle));
            this.feature.getArmorStandManager(p).respawn();
            this.playersInVehicle.put(p, vehicle);
            if (this.feature.isDisableOnBoats() && vehicle.getType().toString().contains("BOAT")) {
                this.playersOnBoats.add(p);
                this.feature.updateTeamData(p);
            }
        }
    }

    public boolean isOnBoat(TabPlayer p) {
        return this.playersOnBoats.contains(p);
    }

    public Map<Integer, List<Entity>> getVehicles() {
        return this.vehicles;
    }

    public List<Entity> getPassengers(Entity vehicle) {
        if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 11) {
            return vehicle.getPassengers();
        }
        if (vehicle.getPassenger() != null) {
            return Collections.singletonList(vehicle.getPassenger());
        }
        return new ArrayList<Entity>();
    }
}

