/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.Skin;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.platforms.velocity.Main;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;

public class VelocityTabPlayer
extends ProxyTabPlayer {
    private final Map<Class<? extends TabPacket>, Consumer<TabPacket>> packetMethods = new HashMap<Class<? extends TabPacket>, Consumer<TabPacket>>(){
        {
            this.put(PacketPlayOutBoss.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutBoss)packet));
            this.put(PacketPlayOutChat.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutChat)packet));
            this.put(PacketPlayOutPlayerInfo.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutPlayerInfo)packet));
            this.put(PacketPlayOutPlayerListHeaderFooter.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutPlayerListHeaderFooter)packet));
            this.put(PacketPlayOutScoreboardDisplayObjective.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutScoreboardDisplayObjective)packet));
            this.put(PacketPlayOutScoreboardObjective.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutScoreboardObjective)packet));
            this.put(PacketPlayOutScoreboardScore.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutScoreboardScore)packet));
            this.put(PacketPlayOutScoreboardTeam.class, packet -> VelocityTabPlayer.this.handle((PacketPlayOutScoreboardTeam)packet));
        }
    };
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();

    public VelocityTabPlayer(Player p) {
        super(p, p.getUniqueId(), p.getUsername(), p.getCurrentServer().isPresent() ? ((ServerConnection)p.getCurrentServer().get()).getServerInfo().getName() : "-", p.getProtocolVersion().getProtocol(), TabAPI.getInstance().getConfig().getBoolean("use-online-uuid-in-tablist", true));
    }

    @Override
    public boolean hasPermission0(String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return (int)this.getPlayer().getPing();
    }

    @Override
    public void sendPacket(Object packet) {
        if (packet == null || !this.getPlayer().isActive()) {
            return;
        }
        this.packetMethods.get(packet.getClass()).accept((TabPacket)packet);
    }

    private void handle(PacketPlayOutChat packet) {
        if (packet.getType() == PacketPlayOutChat.ChatMessageType.GAME_INFO) {
            this.getPlayer().sendActionBar(Main.getInstance().convertComponent(packet.getMessage(), this.getVersion()));
        } else {
            this.getPlayer().sendMessage(Identity.nil(), Main.getInstance().convertComponent(packet.getMessage(), this.getVersion()), MessageType.valueOf((String)packet.getType().name()));
        }
    }

    private void handle(PacketPlayOutPlayerListHeaderFooter packet) {
        this.getPlayer().getTabList().setHeaderAndFooter(Main.getInstance().convertComponent(packet.getHeader(), this.getVersion()), Main.getInstance().convertComponent(packet.getFooter(), this.getVersion()));
    }

    private void handle(PacketPlayOutPlayerInfo packet) {
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            switch (packet.getAction()) {
                case ADD_PLAYER: {
                    if (this.getPlayer().getTabList().containsEntry(data.getUniqueId())) break;
                    this.getPlayer().getTabList().addEntry(TabListEntry.builder().tabList(this.getPlayer().getTabList()).displayName(Main.getInstance().convertComponent(data.getDisplayName(), this.getVersion())).gameMode(data.getGameMode().ordinal() - 1).profile(new GameProfile(data.getUniqueId(), data.getName(), data.getSkin() == null ? new ArrayList() : Collections.singletonList(new GameProfile.Property("textures", data.getSkin().getValue(), data.getSkin().getSignature())))).latency(data.getLatency()).build());
                    break;
                }
                case REMOVE_PLAYER: {
                    this.getPlayer().getTabList().removeEntry(data.getUniqueId());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    this.getEntry(data.getUniqueId()).setDisplayName(Main.getInstance().convertComponent(data.getDisplayName(), this.getVersion()));
                    break;
                }
                case UPDATE_LATENCY: {
                    this.getEntry(data.getUniqueId()).setLatency(data.getLatency());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    this.getEntry(data.getUniqueId()).setGameMode(data.getGameMode().ordinal() - 1);
                    break;
                }
            }
        }
    }

    private void handle(PacketPlayOutBoss packet) {
        switch (packet.getAction()) {
            case ADD: {
                if (this.bossBars.containsKey(packet.getId())) {
                    return;
                }
                BossBar bar = BossBar.bossBar((Component)Main.getInstance().convertComponent(IChatBaseComponent.optimizedComponent(packet.getName()), this.getVersion()), (float)packet.getPct(), (BossBar.Color)BossBar.Color.valueOf((String)packet.getColor().toString()), (BossBar.Overlay)BossBar.Overlay.valueOf((String)packet.getOverlay().toString()));
                if (packet.isCreateWorldFog()) {
                    bar.addFlag(BossBar.Flag.CREATE_WORLD_FOG);
                }
                if (packet.isDarkenScreen()) {
                    bar.addFlag(BossBar.Flag.DARKEN_SCREEN);
                }
                if (packet.isPlayMusic()) {
                    bar.addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
                }
                this.bossBars.put(packet.getId(), bar);
                this.getPlayer().showBossBar(bar);
                break;
            }
            case REMOVE: {
                this.getPlayer().hideBossBar(this.bossBars.get(packet.getId()));
                this.bossBars.remove(packet.getId());
                break;
            }
            case UPDATE_PCT: {
                this.bossBars.get(packet.getId()).progress(packet.getPct());
                break;
            }
            case UPDATE_NAME: {
                this.bossBars.get(packet.getId()).name(Main.getInstance().convertComponent(IChatBaseComponent.optimizedComponent(packet.getName()), this.getVersion()));
                break;
            }
            case UPDATE_STYLE: {
                BossBar bar = this.bossBars.get(packet.getId());
                bar.overlay(BossBar.Overlay.valueOf((String)packet.getOverlay().toString()));
                bar.color(BossBar.Color.valueOf((String)packet.getColor().toString()));
                break;
            }
            case UPDATE_PROPERTIES: {
                BossBar bar = this.bossBars.get(packet.getId());
                this.processFlag(bar, packet.isCreateWorldFog(), BossBar.Flag.CREATE_WORLD_FOG);
                this.processFlag(bar, packet.isDarkenScreen(), BossBar.Flag.DARKEN_SCREEN);
                this.processFlag(bar, packet.isPlayMusic(), BossBar.Flag.PLAY_BOSS_MUSIC);
                break;
            }
        }
    }

    private void handle(PacketPlayOutScoreboardDisplayObjective packet) {
        Main.getInstance().getPlatform().getPluginMessageHandler().sendMessage(this, "PacketPlayOutScoreboardDisplayObjective", packet.getSlot(), packet.getObjectiveName());
    }

    private void handle(PacketPlayOutScoreboardObjective packet) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("PacketPlayOutScoreboardObjective");
        args.add(packet.getObjectiveName());
        args.add(packet.getAction());
        if (packet.getAction() == 0 || packet.getAction() == 2) {
            args.add(this.getVersion().getMinorVersion() < 13 ? Main.getInstance().getPlatform().getPacketBuilder().cutTo(packet.getDisplayName(), 32) : packet.getDisplayName());
            args.add(IChatBaseComponent.optimizedComponent(packet.getDisplayName()).toString(this.getVersion()));
            args.add(packet.getRenderType().ordinal());
        }
        Main.getInstance().getPlatform().getPluginMessageHandler().sendMessage(this, args.toArray());
    }

    private void handle(PacketPlayOutScoreboardScore packet) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("PacketPlayOutScoreboardScore");
        args.add(packet.getObjectiveName());
        args.add(packet.getAction().ordinal());
        args.add(packet.getPlayer());
        args.add(packet.getScore());
        Main.getInstance().getPlatform().getPluginMessageHandler().sendMessage(this, args.toArray());
    }

    private void handle(PacketPlayOutScoreboardTeam packet) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("PacketPlayOutScoreboardTeam");
        args.add(packet.getName());
        args.add(packet.getAction());
        args.add(packet.getPlayers().size());
        args.addAll(packet.getPlayers());
        if (packet.getAction() == 0 || packet.getAction() == 2) {
            String prefix = this.getVersion().getMinorVersion() < 13 ? Main.getInstance().getPlatform().getPacketBuilder().cutTo(packet.getPlayerPrefix(), 16) : packet.getPlayerPrefix();
            String suffix = this.getVersion().getMinorVersion() < 13 ? Main.getInstance().getPlatform().getPacketBuilder().cutTo(packet.getPlayerSuffix(), 16) : packet.getPlayerSuffix();
            args.add(prefix);
            args.add(IChatBaseComponent.optimizedComponent(prefix).toString(this.getVersion()));
            args.add(suffix);
            args.add(IChatBaseComponent.optimizedComponent(suffix).toString(this.getVersion()));
            args.add(packet.getOptions());
            args.add(packet.getNameTagVisibility());
            args.add(packet.getCollisionRule());
            args.add((packet.getColor() != null ? packet.getColor() : EnumChatFormat.lastColorsOf(packet.getPlayerPrefix())).ordinal());
        }
        Main.getInstance().getPlatform().getPluginMessageHandler().sendMessage(this, args.toArray());
    }

    private void processFlag(BossBar bar, boolean targetValue, BossBar.Flag flag) {
        if (targetValue && !bar.hasFlag(flag)) {
            bar.addFlag(flag);
        }
        if (!targetValue && bar.hasFlag(flag)) {
            bar.removeFlag(flag);
        }
    }

    private TabListEntry getEntry(UUID id) {
        for (TabListEntry entry : this.getPlayer().getTabList().getEntries()) {
            if (!entry.getProfile().getId().equals(id)) continue;
            return entry;
        }
        return TabListEntry.builder().tabList(this.getPlayer().getTabList()).displayName((Component)Component.text((String)"")).gameMode(0).profile(new GameProfile(UUID.randomUUID(), "empty", new ArrayList())).latency(0).build();
    }

    @Override
    public Skin getSkin() {
        if (this.getPlayer().getGameProfile().getProperties().size() == 0) {
            return null;
        }
        return new Skin(((GameProfile.Property)this.getPlayer().getGameProfile().getProperties().get(0)).getValue(), ((GameProfile.Property)this.getPlayer().getGameProfile().getProperties().get(0)).getSignature());
    }

    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer().isActive();
    }

    @Override
    public int getGamemode() {
        return 0;
    }

    @Override
    public Object getProfilePublicKey() {
        try {
            return this.getPlayer().getIdentifiedKey();
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        Preconditions.checkNotNull(message, "message");
        try {
            Optional server = this.getPlayer().getCurrentServer();
            if (server.isPresent()) {
                ((ServerConnection)server.get()).sendPluginMessage((ChannelIdentifier)Main.getInstance().getMinecraftChannelIdentifier(), message);
                TAB.getInstance().getThreadManager().packetSent("Plugin Message (" + new String(message) + ")");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

