/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.permission.PermissionPlugin;

public class GroupManager
extends TabFeature {
    private final PermissionPlugin plugin;
    private final boolean groupsByPermissions = TAB.getInstance().getConfiguration().getConfig().getBoolean("assign-groups-by-permissions", false);
    private final List<String> primaryGroupFindingList = TAB.getInstance().getConfiguration().getConfig().getStringList("primary-group-finding-list", Arrays.asList("Owner", "Admin", "Helper", "default"));

    public GroupManager(PermissionPlugin plugin) {
        super("Permission group refreshing", null);
        this.plugin = plugin;
        TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(1000, this, "Refreshing groups", () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                ((ITabPlayer)all).setGroup(this.detectPermissionGroup(all));
            }
        });
    }

    public String detectPermissionGroup(TabPlayer player) {
        return this.groupsByPermissions ? this.getByPermission(player) : this.getByPrimary(player);
    }

    private String getByPrimary(TabPlayer player) {
        try {
            String group = this.plugin.getPrimaryGroup(player);
            return group == null ? "NONE" : group;
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to get permission group of " + player.getName() + " using " + this.plugin.getName() + " v" + this.plugin.getVersion(), e);
            return "NONE";
        }
    }

    private String getByPermission(TabPlayer player) {
        for (String group : this.primaryGroupFindingList) {
            if (!player.hasPermission("tab.group." + group)) continue;
            return group;
        }
        return "NONE";
    }

    public boolean isGroupsByPermissions() {
        return this.groupsByPermissions;
    }

    public PermissionPlugin getPlugin() {
        return this.plugin;
    }
}

