/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.shared.DynamicText;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.nametags.NameTag;

public class DebugCommand
extends SubCommand {
    public DebugCommand() {
        super("debug", "tab.debug");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        TabPlayer analyzed = null;
        if (args.length > 0 && (analyzed = TAB.getInstance().getPlayer(args[0])) == null) {
            this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[0]));
            return;
        }
        if (analyzed == null && sender != null) {
            analyzed = TAB.getInstance().getPlayer(sender.getUniqueId());
        }
        this.debug(sender, analyzed);
    }

    private void debug(TabPlayer sender, TabPlayer analyzed) {
        TAB tab = TAB.getInstance();
        String separator = "&7&m>-------------------------------<";
        this.sendMessage(sender, "&3[TAB] &a&lShowing debug information");
        this.sendMessage(sender, separator);
        this.sendMessage(sender, "&6Server version: &b" + tab.getServerVersionString());
        this.sendMessage(sender, "&6Plugin version: &b3.1.4");
        this.sendMessage(sender, "&6Permission plugin: &b" + TAB.getInstance().getGroupManager().getPlugin().getName());
        this.sendMessage(sender, "&6Permission group choice logic: &b" + this.getGroupChoiceLogic());
        this.sendMessage(sender, "&6Sorting system: &b" + this.getSortingType());
        this.sendMessage(sender, separator);
        if (analyzed == null) {
            return;
        }
        this.sendMessage(sender, "&ePlayer: &a" + analyzed.getName());
        this.sendMessage(sender, this.getGroup(analyzed));
        this.sendMessage(sender, this.getTeamName(analyzed));
        this.sendMessage(sender, this.getTeamNameNote(analyzed));
        if (tab.getFeatureManager().isFeatureEnabled("PlayerList")) {
            PlayerList playerlist = (PlayerList)tab.getFeatureManager().getFeature("PlayerList");
            boolean disabledPlayerlist = playerlist.isDisabled(analyzed.getServer(), analyzed.getWorld());
            this.showProperty(sender, analyzed, "tabprefix", disabledPlayerlist);
            this.showProperty(sender, analyzed, "tabsuffix", disabledPlayerlist);
            this.showProperty(sender, analyzed, "customtabname", disabledPlayerlist);
        } else {
            this.sendMessage(sender, "&atabprefix: &cDisabled");
            this.sendMessage(sender, "&atabsuffix: &cDisabled");
            this.sendMessage(sender, "&acustomtabname: &cDisabled");
        }
        if (tab.getTeamManager() != null) {
            boolean disabledNametags = ((TabFeature)((Object)tab.getTeamManager())).isDisabled(analyzed.getServer(), analyzed.getWorld());
            this.showProperty(sender, analyzed, "tagprefix", disabledNametags);
            this.showProperty(sender, analyzed, "tagsuffix", disabledNametags);
            for (String line : this.getExtraLines()) {
                this.showProperty(sender, analyzed, line, disabledNametags);
            }
        } else {
            this.sendMessage(sender, "&atagprefix: &cDisabled");
            this.sendMessage(sender, "&atagsuffix: &cDisabled");
        }
        this.sendMessage(sender, separator);
    }

    private String getGroupChoiceLogic() {
        if (TAB.getInstance().getGroupManager().isGroupsByPermissions()) {
            return "Permissions";
        }
        return "Primary group";
    }

    private String getSortingType() {
        NameTag nametag = (NameTag)TAB.getInstance().getTeamManager();
        if (nametag != null) {
            return nametag.getSorting().typesToString();
        }
        return "&cDISABLED";
    }

    private String getGroup(TabPlayer analyzed) {
        if (TAB.getInstance().getGroupManager().isGroupsByPermissions()) {
            return "&eHighest group permission: &8tab.group.&a" + analyzed.getGroup();
        }
        return "&ePrimary permission group: &a" + analyzed.getGroup();
    }

    private String getTeamName(TabPlayer analyzed) {
        if (TAB.getInstance().getTeamManager() != null) {
            if (((TabFeature)((Object)TAB.getInstance().getTeamManager())).isDisabled(analyzed.getServer(), analyzed.getWorld())) {
                return "&eTeam name: &cSorting is disabled in player's world/server";
            }
            return "&eTeam name: &a" + analyzed.getTeamName();
        }
        return "";
    }

    private String getTeamNameNote(TabPlayer analyzed) {
        if (TAB.getInstance().getTeamManager() != null && !((TabFeature)((Object)TAB.getInstance().getTeamManager())).isDisabled(analyzed.getServer(), analyzed.getWorld()) && analyzed.getTeamNameNote() != null) {
            return "&eTeam name note: &r" + analyzed.getTeamNameNote();
        }
        return "";
    }

    public List<String> getExtraLines() {
        if (!TAB.getInstance().getFeatureManager().isFeatureEnabled("NameTagX")) {
            return new ArrayList<String>();
        }
        ArrayList<String> lines = new ArrayList<String>(TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.dynamic-lines"));
        Map staticLines = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("scoreboard-teams.unlimited-nametag-mode.static-lines");
        lines.addAll(staticLines.keySet());
        lines.remove("nametag");
        lines.add("customtagname");
        return lines;
    }

    private void showProperty(TabPlayer sender, TabPlayer analyzed, String property, boolean disabled) {
        if (disabled) {
            this.sendMessage(sender, "&a" + property + ": &cDisabled in player's world/server");
        } else {
            DynamicText pr = (DynamicText)analyzed.getProperty(property);
            String rawValue = EnumChatFormat.decolor(pr.getCurrentRawValue());
            String value = String.format(EnumChatFormat.color("&a%s: &e\"&r%s&r&e\" &7(%s) &7(Source: %s)"), property, rawValue, rawValue.length(), pr.getSource());
            this.sendRawMessage(sender, value);
        }
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        return arguments.length == 1 ? this.getOnlinePlayers(arguments[0]) : new ArrayList<String>();
    }
}

