/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.team.TeamManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;

public class NameTagCommand
extends SubCommand {
    public NameTagCommand() {
        super("nametag", null);
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (args.length != 1) {
            this.sendMessages(sender, this.getMessages().getNameTagHelpMenu());
            return;
        }
        switch (args[0].toLowerCase(Locale.US)) {
            case "preview": {
                this.preview(sender);
                break;
            }
            case "toggle": {
                this.toggle(sender);
                break;
            }
            default: {
                this.sendMessages(sender, this.getMessages().getNameTagHelpMenu());
            }
        }
    }

    private void preview(TabPlayer sender) {
        if (sender == null) {
            this.sendMessage(null, this.getMessages().getCommandOnlyFromGame());
            return;
        }
        if (!this.hasPermission(sender, "tab.nametag.preview")) {
            this.sendMessage(sender, this.getMessages().getNoPermission());
            return;
        }
        NameTagX nameTagX = (NameTagX)TAB.getInstance().getFeatureManager().getFeature("NameTagX");
        if (nameTagX == null) {
            this.sendMessage(sender, this.getMessages().getUnlimitedNametagModeNotEnabled());
            return;
        }
        if (nameTagX.hasDisabledArmorStands(sender)) {
            this.sendMessage(sender, this.getMessages().getArmorStandsDisabledCannotPreview());
            return;
        }
        nameTagX.toggleNametagPreview(sender);
    }

    private void toggle(TabPlayer sender) {
        if (sender == null) {
            this.sendMessage(null, this.getMessages().getCommandOnlyFromGame());
            return;
        }
        if (!this.hasPermission(sender, "tab.nametag.toggle")) {
            this.sendMessage(sender, this.getMessages().getNoPermission());
            return;
        }
        TeamManager teams = TAB.getInstance().getTeamManager();
        if (teams == null) {
            this.sendMessage(sender, this.getMessages().getNameTagFeatureNotEnabled());
            return;
        }
        teams.toggleNameTagVisibilityView(sender, true);
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        return this.getStartingArgument(Arrays.asList("preview", "toggle"), arguments[0]);
    }
}

