/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.PropertyCommand;

public class PlayerCommand
extends PropertyCommand {
    public PlayerCommand() {
        super("player");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (args.length <= 1) {
            this.help(sender);
            return;
        }
        String player = args[0];
        String type = args[1].toLowerCase();
        String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        String world = null;
        String server = null;
        if (args[args.length - 2].equals("-w")) {
            world = args[args.length - 1];
            String string = value = value.startsWith("-w") ? "" : value.substring(0, value.length() - world.length() - 4);
        }
        if (args[args.length - 2].equals("-s")) {
            server = args[args.length - 1];
            String string = value = value.startsWith("-s") ? "" : value.substring(0, value.length() - server.length() - 4);
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if ("remove".equals(type)) {
            if (this.hasPermission(sender, "tab.remove")) {
                TAB.getInstance().getConfiguration().getUsers().remove(player);
                TabPlayer pl = TAB.getInstance().getPlayer(player);
                if (pl != null) {
                    pl.forceRefresh();
                }
                this.sendMessage(sender, this.getMessages().getPlayerDataRemoved(player));
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
            return;
        }
        for (String property : PlayerCommand.getAllProperties()) {
            if (!type.equals(property)) continue;
            if (this.hasPermission(sender, "tab.change." + property)) {
                this.savePlayer(sender, player, type, value, server, world);
                if (this.extraProperties.contains(property) && !TAB.getInstance().getFeatureManager().isFeatureEnabled("NameTagX")) {
                    this.sendMessage(sender, this.getMessages().getUnlimitedNametagModeNotEnabled());
                }
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
            return;
        }
        this.help(sender);
    }

    public void savePlayer(TabPlayer sender, String player, String type, String value, String server, String world) {
        if (value.length() > 0) {
            this.sendMessage(sender, this.getMessages().getPlayerValueAssigned(type, value, player));
        } else {
            this.sendMessage(sender, this.getMessages().getPlayerValueRemoved(type, player));
        }
        String[] property = TAB.getInstance().getConfiguration().getUsers().getProperty(player, type, server, world);
        if (property.length > 0 && String.valueOf(value.length() == 0 ? null : value).equals(String.valueOf(property[0]))) {
            return;
        }
        TAB.getInstance().getConfiguration().getUsers().setProperty(player, type, server, world, value.length() == 0 ? null : value);
        TabPlayer pl = TAB.getInstance().getPlayer(player);
        if (pl != null) {
            pl.forceRefresh();
        }
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        if (arguments.length == 1) {
            return this.getOnlinePlayers(arguments[0]);
        }
        return super.complete(sender, arguments);
    }
}

