/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.AnnounceCommand;
import me.neznamy.tab.shared.command.BossBarCommand;
import me.neznamy.tab.shared.command.CpuCommand;
import me.neznamy.tab.shared.command.DebugCommand;
import me.neznamy.tab.shared.command.GroupCommand;
import me.neznamy.tab.shared.command.GroupsCommand;
import me.neznamy.tab.shared.command.MySQLCommand;
import me.neznamy.tab.shared.command.NameTagCommand;
import me.neznamy.tab.shared.command.ParseCommand;
import me.neznamy.tab.shared.command.PlayerCommand;
import me.neznamy.tab.shared.command.PlayerUUIDCommand;
import me.neznamy.tab.shared.command.ReloadCommand;
import me.neznamy.tab.shared.command.ScoreboardCommand;
import me.neznamy.tab.shared.command.SendCommand;
import me.neznamy.tab.shared.command.SetCollisionCommand;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.command.WidthCommand;

public class TabCommand
extends SubCommand {
    public TabCommand() {
        super("tab", null);
        this.registerSubCommand(new AnnounceCommand());
        this.registerSubCommand(new BossBarCommand());
        this.registerSubCommand(new CpuCommand());
        this.registerSubCommand(new DebugCommand());
        this.registerSubCommand(new GroupCommand());
        this.registerSubCommand(new GroupsCommand());
        this.registerSubCommand(new MySQLCommand());
        this.registerSubCommand(new NameTagCommand());
        this.registerSubCommand(new ParseCommand());
        this.registerSubCommand(new PlayerCommand());
        this.registerSubCommand(new PlayerUUIDCommand());
        this.registerSubCommand(new ReloadCommand());
        this.registerSubCommand(new SendCommand());
        this.registerSubCommand(new SetCollisionCommand());
        this.registerSubCommand(new ScoreboardCommand());
        this.registerSubCommand(new WidthCommand());
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"tabprefix", "tabsuffix", "tagprefix", "tagsuffix", "customtabname", "abovename", "belowname", "customtagname"});
        properties.addAll(((DebugCommand)this.getSubcommands().get("debug")).getExtraLines());
        SubCommand.setAllProperties(properties.toArray(new String[0]));
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (args.length > 0) {
            String arg0 = args[0];
            SubCommand command = this.getSubcommands().get(arg0.toLowerCase());
            if (command != null) {
                if (command.hasPermission(sender)) {
                    command.execute(sender, Arrays.copyOfRange(args, 1, args.length));
                } else {
                    this.sendMessage(sender, this.getMessages().getNoPermission());
                }
            } else {
                this.help(sender);
            }
        } else {
            this.help(sender);
        }
    }

    private void help(TabPlayer sender) {
        if (this.hasPermission(sender, "tab.admin")) {
            if (sender != null) {
                IChatBaseComponent component = new IChatBaseComponent(EnumChatFormat.color("&3TAB v") + "3.1.4");
                component.getModifier().onHoverShowText(new IChatBaseComponent(EnumChatFormat.color("&aClick to visit plugin's page")));
                component.getModifier().onClickOpenUrl("https://www.mc-market.org/resources/14009/");
                component.addExtra(new IChatBaseComponent(EnumChatFormat.color("&0 by _NEZNAMY_")));
                sender.sendMessage(component);
            } else {
                TAB.getInstance().sendConsoleMessage("&3TAB v3.1.4", true);
            }
            for (String message : this.getMessages().getHelpMenu()) {
                if (TAB.getInstance().getServerVersion() == ProtocolVersion.PROXY) {
                    message = message.replace("/tab", "/btab");
                }
                this.sendMessage(sender, message);
            }
        }
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        if (!this.hasPermission(sender, "tab.tabcomplete")) {
            return new ArrayList<String>();
        }
        return super.complete(sender, arguments);
    }
}

