/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;

public class WidthCommand
extends SubCommand {
    public WidthCommand() {
        super("width", "tab.width");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (sender == null) {
            this.sendMessage(null, this.getMessages().getCommandOnlyFromGame());
            return;
        }
        if (args.length == 1) {
            char character;
            try {
                int i = Integer.parseInt(args[0]);
                if (i > 65535) {
                    this.sendMessage(sender, "&cCharacter ID out of range: 0-65535");
                    return;
                }
                character = i < 10 ? args[0].charAt(0) : (char)i;
            }
            catch (NumberFormatException e) {
                if (args[0].length() == 1) {
                    character = args[0].charAt(0);
                }
                this.sendInputCharacterIDs(sender, args[0]);
                return;
            }
            this.sendWidth(sender, character, 10);
        } else if (args.length == 2) {
            char character;
            int amount;
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ignored) {
                this.sendUsage(sender);
                return;
            }
            try {
                int i = Integer.parseInt(args[0]);
                if (i > 65535) {
                    this.sendMessage(sender, "&cCharacter ID out of range: 0-65535");
                    return;
                }
                character = i < 10 ? args[0].charAt(0) : (char)i;
            }
            catch (NumberFormatException e) {
                if (args[0].length() == 1) {
                    character = args[0].charAt(0);
                }
                this.sendInputCharacterIDs(sender, args[0]);
                return;
            }
            this.sendWidth(sender, character, amount);
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("set")) {
                int width;
                char character;
                try {
                    int i = Integer.parseInt(args[1]);
                    if (i > 65535) {
                        this.sendMessage(sender, "&cCharacter ID out of range: 0-65535");
                        return;
                    }
                    character = i < 10 ? args[1].charAt(0) : (char)i;
                }
                catch (NumberFormatException e) {
                    if (args[1].length() == 1) {
                        character = args[1].charAt(0);
                    }
                    this.sendInputCharacterIDs(sender, args[1]);
                    return;
                }
                try {
                    width = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    this.sendMessage(sender, "&cError: The last argument must be a number.");
                    this.sendUsage(sender);
                    return;
                }
                TAB.getInstance().getConfig().getConfigurationSection("tablist-name-formatting.character-width-overrides").put(Integer.valueOf(character), width);
                TAB.getInstance().getConfig().save();
                this.sendMessage(sender, "&2[TAB] Successfully set width of &6" + (char)character + " &2(&6" + character + "&2) to &6" + width + "&2 pixels.");
                if (TAB.getInstance().getConfiguration().isDebugMode()) {
                    this.execute(sender, new String[]{String.valueOf(character + '\u0001')});
                }
            } else {
                this.sendUsage(sender);
            }
        } else {
            this.sendUsage(sender);
        }
    }

    public void sendInputCharacterIDs(TabPlayer sender, String input) {
        this.sendMessage(sender, "The provided input consists of following characters:");
        char[] chars = input.toCharArray();
        int[] ints = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            ints[i] = chars[i];
        }
        this.sendMessage(sender, Arrays.toString(ints));
    }

    public void sendUsage(TabPlayer sender) {
        this.sendMessage(sender, "&cUsage 1: &f/tab width &7<character>");
        this.sendMessage(sender, "&cUsage 2: &f/tab width &7<character / character ID if > 10 > <amount>");
        this.sendMessage(sender, "&cUsage 3: &f/tab width set &7<character / character ID  if > 10> <new width>");
    }

    public void sendWidth(TabPlayer sender, char character, int amount) {
        ArrayList<IChatBaseComponent> messages = new ArrayList<IChatBaseComponent>();
        IChatBaseComponent charMessage = new IChatBaseComponent(EnumChatFormat.color("|&2" + character + " &d|"));
        messages.add(new IChatBaseComponent(EnumChatFormat.color("&b[TAB] Click the line with closest width &7(ID: &f" + character + "&7)")));
        for (int i = 1; i <= amount; ++i) {
            messages.add(this.getText(i, character));
            if (i % 2 == 0) continue;
            messages.add(charMessage);
        }
        for (IChatBaseComponent message : messages) {
            sender.sendMessage(message);
        }
    }

    private IChatBaseComponent getText(int width, int c) {
        StringBuilder text = new StringBuilder();
        int pixelsRemaining = width + 1;
        while (pixelsRemaining % 2 != 0) {
            pixelsRemaining -= 3;
            text.append('l');
        }
        while (pixelsRemaining > 0) {
            pixelsRemaining -= 2;
            text.append('i');
        }
        IChatBaseComponent component = new IChatBaseComponent(EnumChatFormat.color("|&b&k" + text + " &e|&b (" + width + " pixels) &7&l[Click to apply]"));
        component.getModifier().onClickRunCommand("/tab width set " + c + " " + width);
        component.getModifier().onHoverShowText(new IChatBaseComponent("Click to set width to " + width + " pixels"));
        return component;
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (arguments.length == 1) {
            suggestions.add("set");
            suggestions.add("<character (ID)>");
        } else if (arguments.length == 2) {
            if (arguments[0].equalsIgnoreCase("set")) {
                suggestions.add("<character (ID)>");
            } else {
                suggestions.add("<amount>");
            }
        } else if (arguments.length == 3 && arguments[0].equalsIgnoreCase("set")) {
            suggestions.add("<new width>");
        }
        return this.getStartingArgument(suggestions, arguments[arguments.length - 1]);
    }
}

