/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.config.ConfigurationFile;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.Converter;
import me.neznamy.tab.shared.config.MessageFile;
import me.neznamy.tab.shared.config.MySQL;
import me.neznamy.tab.shared.config.file.YamlPropertyConfigurationFile;
import me.neznamy.tab.shared.config.mysql.MySQLGroupConfiguration;
import me.neznamy.tab.shared.config.mysql.MySQLUserConfiguration;
import org.yaml.snakeyaml.error.YAMLException;

public class Configs {
    private final ConfigurationFile config = new YamlConfigurationFile(this.getClass().getClassLoader().getResourceAsStream(TAB.getInstance().getPlatform().getConfigName()), new File(TAB.getInstance().getDataFolder(), "config.yml"));
    private final boolean bukkitPermissions = TAB.getInstance().getServerVersion() == ProtocolVersion.PROXY && this.config.getBoolean("use-bukkit-permissions-manager", false);
    private final boolean debugMode = this.config.getBoolean("debug", false);
    private final boolean removeGhostPlayers = this.getSecretOption("remove-ghost-players", false);
    private final boolean pipelineInjection = this.getSecretOption("pipeline-injection", true) != false && TAB.getInstance().getServerVersion().getMinorVersion() >= 8;
    private final ConfigurationFile animation = new YamlConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("animations.yml"), new File(TAB.getInstance().getDataFolder(), "animations.yml"));
    private final MessageFile messages = new MessageFile();
    private ConfigurationFile playerdata;
    private final ConfigurationFile layout = new YamlConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("layout.yml"), new File(TAB.getInstance().getDataFolder(), "layout.yml"));
    private PropertyConfiguration groupFile;
    private PropertyConfiguration userFile;
    private MySQL mysql;

    public Configs() throws YAMLException, IOException {
        Converter converter = new Converter();
        converter.convertToV3(this.config);
        converter.removeOldOptions(this.config);
        converter.convertAnimationFile(this.animation);
        if (this.config.getBoolean("mysql.enabled", false)) {
            try {
                this.mysql = new MySQL(this.config.getString("mysql.host", "127.0.0.1"), this.config.getInt("mysql.port", 3306), this.config.getString("mysql.database", "tab"), this.config.getString("mysql.username", "user"), this.config.getString("mysql.password", "password"));
                this.groupFile = new MySQLGroupConfiguration(this.mysql);
                this.userFile = new MySQLUserConfiguration(this.mysql);
                return;
            }
            catch (SQLException e) {
                TAB.getInstance().getErrorManager().criticalError("Failed to connect to MySQL", e);
            }
        }
        this.groupFile = new YamlPropertyConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("groups.yml"), new File(TAB.getInstance().getDataFolder(), "groups.yml"));
        this.userFile = new YamlPropertyConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("users.yml"), new File(TAB.getInstance().getDataFolder(), "users.yml"));
    }

    public <T> T getSecretOption(String path, T defaultValue) {
        Object value = this.config.getObject(path);
        return (T)(value == null ? defaultValue : value);
    }

    public MessageFile getMessages() {
        return this.messages;
    }

    public ConfigurationFile getConfig() {
        return this.config;
    }

    public boolean isRemoveGhostPlayers() {
        return this.removeGhostPlayers;
    }

    public ConfigurationFile getLayout() {
        return this.layout;
    }

    public ConfigurationFile getAnimationFile() {
        return this.animation;
    }

    public boolean isBukkitPermissions() {
        return this.bukkitPermissions;
    }

    public boolean isPipelineInjection() {
        return this.pipelineInjection;
    }

    public ConfigurationFile getPlayerDataFile() {
        if (this.playerdata == null) {
            File file = new File(TAB.getInstance().getDataFolder(), "playerdata.yml");
            try {
                if (file.exists() || file.createNewFile()) {
                    this.playerdata = new YamlConfigurationFile(null, file);
                }
            }
            catch (IOException e) {
                TAB.getInstance().getErrorManager().criticalError("Failed to load playerdata.yml", e);
            }
        }
        return this.playerdata;
    }

    public PropertyConfiguration getGroups() {
        return this.groupFile;
    }

    public PropertyConfiguration getUsers() {
        return this.userFile;
    }

    public MySQL getMysql() {
        return this.mysql;
    }

    public String getGroup(List<Object> serverGroups, String element) {
        if (serverGroups.isEmpty() || element == null) {
            return element;
        }
        for (Object worldGroup : serverGroups) {
            for (String definedWorld : worldGroup.toString().split(";")) {
                if (!(definedWorld.endsWith("*") ? element.toLowerCase().startsWith(definedWorld.substring(0, definedWorld.length() - 1).toLowerCase()) : element.equalsIgnoreCase(definedWorld))) continue;
                return worldGroup.toString();
            }
        }
        return element;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }
}

