/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.mysql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.CachedRowSet;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.MySQL;

public class MySQLGroupConfiguration
implements PropertyConfiguration {
    private final MySQL mysql;
    private final Map<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Map<String, Object>>> perWorld = new HashMap<String, Map<String, Map<String, Object>>>();
    private final Map<String, Map<String, Map<String, Object>>> perServer = new HashMap<String, Map<String, Map<String, Object>>>();

    public MySQLGroupConfiguration(MySQL mysql) throws SQLException {
        this.mysql = mysql;
        mysql.execute("create table if not exists tab_groups (`group` varchar(64), `property` varchar(16), `value` varchar(1024), world varchar(64), server varchar(64))", new Object[0]);
        CachedRowSet crs = mysql.getCRS("select * from tab_groups", new Object[0]);
        while (crs.next()) {
            String group = crs.getString("group");
            if (!group.equals("_DEFAULT_")) {
                group = group.toLowerCase(Locale.US);
            }
            String property = crs.getString("property");
            String value = crs.getString("value");
            String world = crs.getString("world");
            String server = crs.getString("server");
            this.setProperty0(group, property, server, world, value);
        }
    }

    @Override
    public void setProperty(String group, String property, String server, String world, String value) {
        String lowercaseGroup = group.equals("_DEFAULT_") ? group : group.toLowerCase(Locale.US);
        try {
            if (this.getProperty(lowercaseGroup, property, server, world) != null) {
                this.mysql.execute("delete from `tab_groups` where `group` = ? and `property` = ? and world " + this.querySymbol(world == null) + " ? and server " + this.querySymbol(server == null) + " ?", lowercaseGroup, property, world, server);
            }
            this.setProperty0(lowercaseGroup, property, server, world, value);
            if (value != null) {
                this.mysql.execute("insert into `tab_groups` (`group`, `property`, `value`, `world`, `server`) values (?, ?, ?, ?, ?)", lowercaseGroup, property, value, world, server);
            }
        }
        catch (SQLException e) {
            TAB.getInstance().getErrorManager().printError("Failed to execute MySQL query", e);
        }
    }

    private String querySymbol(boolean isNull) {
        return isNull ? "is" : "=";
    }

    private void setProperty0(String group, String property, String server, String world, String value) {
        if (world != null) {
            this.perWorld.computeIfAbsent(world, w -> new HashMap()).computeIfAbsent(group, g -> new HashMap()).put(property, value);
        } else if (server != null) {
            this.perServer.computeIfAbsent(server, s -> new HashMap()).computeIfAbsent(group, g -> new HashMap()).put(property, value);
        } else {
            this.values.computeIfAbsent(group, g -> new HashMap()).put(property, value);
        }
    }

    @Override
    public String[] getProperty(String group, String property, String server, String world) {
        String lowercaseGroup = group.equals("_DEFAULT_") ? group : group.toLowerCase(Locale.US);
        Object value = ((Map)((Map)this.perWorld.getOrDefault(world, new HashMap())).getOrDefault(lowercaseGroup, new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,world=%s", lowercaseGroup, world)};
        }
        value = ((Map)((Map)this.perWorld.getOrDefault(world, new HashMap())).getOrDefault("_DEFAULT_", new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,world=%s", "_DEFAULT_", world)};
        }
        value = ((Map)((Map)this.perServer.getOrDefault(server, new HashMap())).getOrDefault(lowercaseGroup, new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,server=%s", lowercaseGroup, server)};
        }
        value = ((Map)((Map)this.perServer.getOrDefault(server, new HashMap())).getOrDefault("_DEFAULT_", new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s,server=%s", "_DEFAULT_", server)};
        }
        value = ((Map)this.values.getOrDefault(lowercaseGroup, new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s", lowercaseGroup)};
        }
        value = ((Map)this.values.getOrDefault("_DEFAULT_", new HashMap())).get(property);
        if (value != null) {
            return new String[]{this.toString(value), String.format("group=%s", "_DEFAULT_")};
        }
        return new String[0];
    }

    @Override
    public void remove(String group) {
        ((Map)this.values.getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, null, null, null));
        this.perWorld.keySet().forEach(world -> ((Map)this.perWorld.get(world).getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, null, (String)world, null)));
        this.perServer.keySet().forEach(server -> ((Map)this.perServer.get(server).getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, (String)server, null, null)));
    }

    @Override
    public Map<String, Object> getGlobalSettings(String name) {
        return this.values.getOrDefault(name, Collections.emptyMap());
    }

    @Override
    public Map<String, Map<String, Object>> getPerWorldSettings(String name) {
        return this.convertMap(this.perWorld, name);
    }

    @Override
    public Map<String, Map<String, Object>> getPerServerSettings(String name) {
        return this.convertMap(this.perServer, name);
    }

    @Override
    public Set<String> getAllEntries() {
        HashSet<String> set = new HashSet<String>(this.values.keySet());
        this.perWorld.values().forEach(map -> set.addAll(map.keySet()));
        this.perServer.values().forEach(map -> set.addAll(map.keySet()));
        return set;
    }
}

