/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.TablistFormatManager;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.Layout;
import me.neznamy.tab.shared.features.layout.LayoutManager;
import me.neznamy.tab.shared.features.layout.PlayerSlot;
import me.neznamy.tab.shared.features.redis.RedisSupport;

public class PlayerList
extends TabFeature
implements TablistFormatManager {
    protected final boolean antiOverrideTabList = TAB.getInstance().getConfiguration().getConfig().getBoolean("tablist-name-formatting.anti-override", true);
    private boolean disabling = false;

    public PlayerList() {
        super("TabList prefix/suffix", "Updating TabList format", "tablist-name-formatting");
        TAB.getInstance().debug(String.format("Loaded PlayerList feature with parameters disabledWorlds=%s, disabledServers=%s, antiOverrideTabList=%s", Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers), this.antiOverrideTabList));
    }

    public UUID getTablistUUID(TabPlayer p, TabPlayer viewer) {
        PlayerSlot slot;
        Layout layout;
        LayoutManager manager = (LayoutManager)TAB.getInstance().getFeatureManager().getFeature("layout");
        if (manager != null && (layout = manager.getPlayerViews().get(viewer)) != null && (slot = layout.getSlot(p)) != null) {
            return slot.getUUID();
        }
        return p.getTablistUUID();
    }

    protected boolean updateProperties(TabPlayer p) {
        boolean changed = p.loadPropertyFromConfig(this, "tabprefix");
        if (p.loadPropertyFromConfig(this, "customtabname", p.getName())) {
            changed = true;
        }
        if (p.loadPropertyFromConfig(this, "tabsuffix")) {
            changed = true;
        }
        return changed;
    }

    protected void updatePlayer(TabPlayer p, boolean format) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            viewer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.getTablistUUID(p, viewer), format ? this.getTabFormat(p, viewer) : null)), this);
        }
        RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        if (redis != null) {
            redis.updateTabFormat(p, p.getProperty("tabprefix").get() + p.getProperty("customtabname").get() + p.getProperty("tabsuffix").get());
        }
    }

    public IChatBaseComponent getTabFormat(TabPlayer p, TabPlayer viewer) {
        Property prefix = p.getProperty("tabprefix");
        Property name = p.getProperty("customtabname");
        Property suffix = p.getProperty("tabsuffix");
        if (prefix == null || name == null || suffix == null) {
            return null;
        }
        return IChatBaseComponent.optimizedComponent(prefix.getFormat(viewer) + name.getFormat(viewer) + suffix.getFormat(viewer));
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabled(all.getServer(), all.getWorld())) {
                this.addDisabledPlayer(all);
                this.updateProperties(all);
                continue;
            }
            this.refresh(all, true);
        }
    }

    @Override
    public void unload() {
        this.disabling = true;
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> updatedPlayers = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(p)) continue;
            updatedPlayers.add(new PacketPlayOutPlayerInfo.PlayerInfoData(this.getTablistUUID(p, p)));
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all.getVersion().getMinorVersion() < 8) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, updatedPlayers), this);
        }
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("injection")) {
            return;
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (p.getVersion().getMinorVersion() >= 8) {
                p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.getTablistUUID(all, p), this.getTabFormat(all, p))), this);
            }
            if (all.getVersion().getMinorVersion() < 8) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.getTablistUUID(p, all), this.getTabFormat(p, all))), this);
        }
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        boolean disabledBefore = this.isDisabledPlayer(p);
        boolean disabledNow = false;
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            disabledNow = true;
            this.addDisabledPlayer(p);
        } else {
            this.removeDisabledPlayer(p);
        }
        if (disabledNow) {
            if (!disabledBefore) {
                this.updatePlayer(p, false);
            }
        } else if (this.updateProperties(p)) {
            this.updatePlayer(p, true);
        }
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        boolean refresh;
        if (this.isDisabledPlayer(refreshed)) {
            return;
        }
        if (force) {
            this.updateProperties(refreshed);
            refresh = true;
        } else {
            boolean prefix = refreshed.getProperty("tabprefix").update();
            boolean name = refreshed.getProperty("customtabname").update();
            boolean suffix = refreshed.getProperty("tabsuffix").update();
            boolean bl = refresh = prefix || name || suffix;
        }
        if (refresh) {
            this.updatePlayer(refreshed, true);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        this.updateProperties(connectedPlayer);
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        Runnable r = () -> {
            this.refresh(connectedPlayer, true);
            if (connectedPlayer.getVersion().getMinorVersion() < 8) {
                return;
            }
            ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all == connectedPlayer) continue;
                list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(this.getTablistUUID(all, connectedPlayer), this.getTabFormat(all, connectedPlayer)));
            }
            if (!list.isEmpty()) {
                connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, list), this);
            }
        };
        r.run();
        if (!this.antiOverrideTabList || !TAB.getInstance().getFeatureManager().isFeatureEnabled("injection") || connectedPlayer.getVersion().getMinorVersion() == 8) {
            TAB.getInstance().getCPUManager().runTaskLater(300, this, "Player Join", r);
        }
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
        if (this.disabling || !this.antiOverrideTabList) {
            return;
        }
        if (info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME && info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
            TabPlayer packetPlayer = TAB.getInstance().getPlayerByTabListUUID(playerInfoData.getUniqueId());
            if (packetPlayer == null || this.isDisabledPlayer(packetPlayer)) continue;
            playerInfoData.setDisplayName(this.getTabFormat(packetPlayer, receiver));
        }
    }

    @Override
    public void setPrefix(TabPlayer player, String prefix) {
        Preconditions.checkLoaded(player);
        player.getProperty("tabprefix").setTemporaryValue(prefix);
        this.updatePlayer(player, true);
    }

    @Override
    public void setName(TabPlayer player, String customName) {
        Preconditions.checkLoaded(player);
        player.getProperty("customtabname").setTemporaryValue(customName);
        this.updatePlayer(player, true);
    }

    @Override
    public void setSuffix(TabPlayer player, String suffix) {
        Preconditions.checkLoaded(player);
        player.getProperty("tabsuffix").setTemporaryValue(suffix);
        this.updatePlayer(player, true);
    }

    @Override
    public void resetPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        player.getProperty("tabprefix").setTemporaryValue(null);
        this.updatePlayer(player, true);
    }

    @Override
    public void resetName(TabPlayer player) {
        Preconditions.checkLoaded(player);
        player.getProperty("customtabname").setTemporaryValue(null);
        this.updatePlayer(player, true);
    }

    @Override
    public void resetSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        player.getProperty("tabsuffix").setTemporaryValue(null);
        this.updatePlayer(player, true);
    }

    @Override
    public String getCustomPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tabprefix").getTemporaryValue();
    }

    @Override
    public String getCustomName(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("customtabname").getTemporaryValue();
    }

    @Override
    public String getCustomSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tabsuffix").getTemporaryValue();
    }

    @Override
    public String getOriginalPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tabprefix").getOriginalRawValue();
    }

    @Override
    public String getOriginalName(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("customtabname").getOriginalRawValue();
    }

    @Override
    public String getOriginalSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tabsuffix").getOriginalRawValue();
    }
}

