/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.alignedplayerlist;

import java.util.Map;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.alignedplayerlist.AlignedPlayerList;

public class PlayerView {
    private final AlignedPlayerList feature;
    private final TabPlayer viewer;
    private final boolean canSeeVanished;
    private final Map<TabPlayer, Integer> playerWidths = new WeakHashMap<TabPlayer, Integer>();
    private int maxWidth;
    private TabPlayer maxPlayer;

    public PlayerView(AlignedPlayerList feature, TabPlayer viewer) {
        this.feature = feature;
        this.viewer = viewer;
        this.canSeeVanished = viewer.hasPermission("tab.seevanished");
    }

    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.playerWidths.put(all, this.getPlayerNameWidth(all));
        }
        this.recalculateMaxWidth(null);
        if (this.viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        this.updateAllPlayers();
    }

    public void playerJoin(TabPlayer connectedPlayer) {
        if (this.viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        int width = this.getPlayerNameWidth(connectedPlayer);
        this.playerWidths.put(connectedPlayer, width);
        if (width > this.maxWidth && (!connectedPlayer.isVanished() || this.canSeeVanished)) {
            this.maxWidth = width;
            this.maxPlayer = connectedPlayer;
            this.updateAllPlayers();
        } else {
            this.viewer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.feature.getTablistUUID(connectedPlayer, this.viewer), this.formatName(connectedPlayer))), this.feature);
        }
    }

    public void worldChange(TabPlayer target) {
        int width = this.getPlayerNameWidth(target);
        if (this.playerWidths.getOrDefault(target, 0) != width) {
            this.playerWidths.put(target, width);
            if (this.recalculateMaxWidth(null)) {
                this.updateAllPlayers();
            } else {
                this.viewer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.feature.getTablistUUID(target, this.viewer), this.formatName(target))), this.feature);
            }
        }
    }

    private void updateAllPlayers() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.viewer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.feature.getTablistUUID(all, this.viewer), this.formatName(all))), this.feature);
        }
    }

    public synchronized IChatBaseComponent formatName(TabPlayer target) {
        Integer width = this.playerWidths.get(target);
        if (width == null) {
            return null;
        }
        String prefixAndName = target.getProperty("tabprefix").getFormat(this.viewer) + target.getProperty("customtabname").getFormat(this.viewer);
        String suffix = target.getProperty("tabsuffix").getFormat(this.viewer);
        if (suffix.length() == 0) {
            return IChatBaseComponent.optimizedComponent(prefixAndName);
        }
        if (target.isVanished() && !this.canSeeVanished || width > this.maxWidth) {
            return IChatBaseComponent.optimizedComponent(prefixAndName + suffix);
        }
        StringBuilder newFormat = new StringBuilder(prefixAndName).append(EnumChatFormat.RESET.getFormat());
        int length = this.maxWidth + 12 - width;
        try {
            newFormat.append(this.buildSpaces(length));
        }
        catch (IllegalArgumentException e) {
            TAB.getInstance().getErrorManager().printError("Could not build space consisting of " + length + " pixels", e);
        }
        return IChatBaseComponent.optimizedComponent(newFormat.append(EnumChatFormat.getLastColors(prefixAndName)).append(suffix).toString());
    }

    private String buildSpaces(int pixelWidth) {
        if (pixelWidth < 12) {
            throw new IllegalArgumentException("Cannot build space lower than 12 pixels wide");
        }
        int pixelsLeft = pixelWidth;
        StringBuilder output = new StringBuilder();
        while (pixelsLeft % 5 != 0) {
            pixelsLeft -= 4;
            output.append(' ');
        }
        output.append('\u00a7');
        output.append('l');
        while (pixelsLeft > 0) {
            pixelsLeft -= 5;
            output.append(' ');
        }
        output.append('\u00a7');
        output.append('r');
        return output.toString();
    }

    public void updatePlayer(TabPlayer target) {
        this.playerWidths.put(target, this.getPlayerNameWidth(target));
        if (this.recalculateMaxWidth(null)) {
            this.updateAllPlayers();
        } else {
            this.viewer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.feature.getTablistUUID(target, this.viewer), this.formatName(target))), this.feature);
        }
    }

    public void processPlayerQuit(TabPlayer disconnectedPlayer) {
        if (this.viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (disconnectedPlayer == this.maxPlayer && this.recalculateMaxWidth(disconnectedPlayer)) {
            this.updateAllPlayers();
        }
    }

    private int getPlayerNameWidth(TabPlayer p) {
        return this.getTextWidth(IChatBaseComponent.fromColoredText(p.getProperty("tabprefix").getFormat(this.viewer) + p.getProperty("customtabname").getFormat(this.viewer) + p.getProperty("tabsuffix").getFormat(this.viewer)));
    }

    private int getTextWidth(IChatBaseComponent component) {
        int width = 0;
        if (component.getText() != null) {
            for (char c : component.getText().toCharArray()) {
                width += this.feature.getWidths()[c] + 1;
                if (!component.getModifier().isBold()) continue;
                ++width;
            }
        }
        Object object = component.getExtra().iterator();
        while (object.hasNext()) {
            IChatBaseComponent extra = (IChatBaseComponent)object.next();
            width += this.getTextWidth(extra);
        }
        return width;
    }

    private boolean recalculateMaxWidth(TabPlayer ignoredPlayer) {
        int newMaxWidth = 0;
        TabPlayer newMaxPlayer = null;
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            int localWidth;
            if (all == ignoredPlayer || all.isVanished() && !this.canSeeVanished && all != this.viewer || (localWidth = this.playerWidths.get(all).intValue()) <= newMaxWidth) continue;
            newMaxWidth = localWidth;
            newMaxPlayer = all;
        }
        boolean changed = newMaxWidth != this.maxWidth;
        this.maxPlayer = newMaxPlayer;
        this.maxWidth = newMaxWidth;
        return changed;
    }

    public void onVanishChange(TabPlayer changed) {
        this.playerWidths.put(changed, this.getPlayerNameWidth(changed));
        if (this.recalculateMaxWidth(null)) {
            this.updateAllPlayers();
        }
    }
}

