/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabConstants;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.FixedSlot;
import me.neznamy.tab.shared.features.layout.Layout;
import me.neznamy.tab.shared.features.layout.LayoutLatencyRefresher;
import me.neznamy.tab.shared.features.layout.ParentGroup;
import me.neznamy.tab.shared.features.layout.skin.SkinManager;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public class LayoutManager
extends TabFeature {
    private final Direction direction = this.parseDirection(TAB.getInstance().getConfiguration().getLayout().getString("direction", "COLUMNS"));
    private final String defaultSkin = TAB.getInstance().getConfiguration().getLayout().getString("default-skin", "mineskin:1753261242");
    private final boolean enableRemainingPlayersText = TAB.getInstance().getConfiguration().getLayout().getBoolean("enable-remaining-players-text", true);
    private final String remainingPlayersText = EnumChatFormat.color(TAB.getInstance().getConfiguration().getLayout().getString("remaining-players-text", "... and %s more"));
    private final int emptySlotPing = TAB.getInstance().getConfiguration().getLayout().getInt("empty-slot-ping-value", 1000);
    private final SkinManager skinManager = new SkinManager(this.defaultSkin);
    private final Map<Integer, UUID> uuids = new HashMap<Integer, UUID>(){
        {
            for (int slot = 1; slot <= 80; ++slot) {
                this.put(slot, new UUID(0L, LayoutManager.this.translateSlot(slot)));
            }
        }
    };
    private final Map<String, Layout> layouts = this.loadLayouts();
    private final WeakHashMap<TabPlayer, Layout> playerViews = new WeakHashMap();
    private final Map<TabPlayer, String> sortedPlayers = Collections.synchronizedMap(new TreeMap(Comparator.comparing(TabPlayer::getTeamName)));

    public LayoutManager() {
        super("Layout", "Switching layouts");
        TAB.getInstance().getPlaceholderManager().addUsedPlaceholders(Collections.singletonList("%vanished%"));
        TAB.getInstance().getFeatureManager().registerFeature("layout-latency", new LayoutLatencyRefresher(this));
        TAB.getInstance().debug("Loaded Layout feature");
    }

    private Direction parseDirection(String value) {
        try {
            return Direction.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            TAB.getInstance().getErrorManager().startupWarn("\"&e" + value + "&c\" is not a valid type of layout direction. Valid options are: &e" + Arrays.deepToString((Object[])Direction.values()) + ". &bUsing COLUMNS");
            return Direction.COLUMNS;
        }
    }

    private Map<String, Layout> loadLayouts() {
        LinkedHashMap<String, Layout> layoutMap = new LinkedHashMap<String, Layout>();
        for (Map.Entry layout : TAB.getInstance().getConfiguration().getLayout().getConfigurationSection("layouts").entrySet()) {
            Map map = (Map)layout.getValue();
            Condition displayCondition = Condition.getCondition((String)map.get("condition"));
            if (displayCondition != null) {
                this.addUsedPlaceholders(Collections.singletonList(TabConstants.Placeholder.condition(displayCondition.getName())));
            }
            HashMap<Integer, FixedSlot> fixedSlots = new HashMap<Integer, FixedSlot>();
            ArrayList<Integer> emptySlots = new ArrayList<Integer>();
            ArrayList<ParentGroup> parentGroups = new ArrayList<ParentGroup>();
            Layout l = new Layout(layout.getKey().toString(), this, displayCondition, fixedSlots, emptySlots, parentGroups);
            for (int slot = 1; slot <= 80; ++slot) {
                emptySlots.add(slot);
            }
            for (String fixedSlot : map.getOrDefault("fixed-slots", Collections.emptyList())) {
                String[] array = fixedSlot.split("\\|");
                int slot = Integer.parseInt(array[0]);
                String text = array[1];
                String skin = array.length > 2 ? array[2] : "";
                int ping = array.length > 3 ? TAB.getInstance().getErrorManager().parseInteger(array[3], this.emptySlotPing) : this.emptySlotPing;
                FixedSlot f = new FixedSlot(l, slot, text, skin, ping);
                fixedSlots.put(slot, f);
                emptySlots.remove((Object)slot);
                if (text.length() <= 0) continue;
                TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.layoutSlot(layout.getKey().toString(), slot), f);
            }
            Map groups = (Map)map.get("groups");
            if (groups != null) {
                for (Map.Entry group : groups.entrySet()) {
                    Condition condition = Condition.getCondition((String)((Map)group.getValue()).get("condition"));
                    ArrayList<Integer> positions = new ArrayList<Integer>();
                    for (String line : (List)((Map)group.getValue()).get("slots")) {
                        String[] arr = line.split("-");
                        int from = Integer.parseInt(arr[0]);
                        int to = Integer.parseInt(arr[1]);
                        for (int i2 = from; i2 <= to; ++i2) {
                            positions.add(i2);
                        }
                    }
                    parentGroups.add(new ParentGroup(l, condition, positions.stream().mapToInt(i -> i).toArray()));
                    emptySlots.removeAll(positions);
                }
            }
            layoutMap.put(layout.getKey().toString(), l);
            TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.layout(layout.getKey().toString()), l);
        }
        return layoutMap;
    }

    @Override
    public void onJoin(TabPlayer p) {
        this.sortedPlayers.put(p, p.getTeamName());
        Layout highest = this.getHighestLayout(p);
        if (highest != null) {
            highest.sendTo(p);
        }
        this.playerViews.put(p, highest);
        this.layouts.values().forEach(Layout::tick);
    }

    @Override
    public void onQuit(TabPlayer p) {
        this.sortedPlayers.remove(p);
        this.layouts.values().forEach(Layout::tick);
    }

    private int translateSlot(int slot) {
        if (this.direction == Direction.ROWS) {
            return (slot - 1) % 4 * 20 + (slot - (slot - 1) % 4) / 4 + 1;
        }
        return slot;
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        Layout highest = this.getHighestLayout(p);
        Layout current = this.playerViews.get(p);
        if (current != highest) {
            if (current != null) {
                current.removeFrom(p);
            }
            if (highest != null) {
                highest.sendTo(p);
            }
            this.playerViews.put(p, highest);
        }
    }

    @Override
    public void unload() {
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (UUID id : this.uuids.values()) {
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(id));
        }
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.getVersion().getMinorVersion() < 8 || p.isBedrockPlayer()) continue;
            p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, list), this);
        }
    }

    @Override
    public void onVanishStatusChange(TabPlayer p) {
        this.layouts.values().forEach(Layout::tick);
    }

    private Layout getHighestLayout(TabPlayer p) {
        for (Layout layout : this.layouts.values()) {
            if (!layout.isConditionMet(p)) continue;
            return layout;
        }
        return null;
    }

    public UUID getUUID(int slot) {
        return this.uuids.get(slot);
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    public void updateTeamName(TabPlayer p, String teamName) {
        this.sortedPlayers.remove(p);
        ((ITabPlayer)p).setTeamName(teamName);
        this.sortedPlayers.put(p, teamName);
        this.layouts.values().forEach(Layout::tick);
    }

    public boolean isRemainingPlayersTextEnabled() {
        return this.enableRemainingPlayersText;
    }

    public String getRemainingPlayersText() {
        return this.remainingPlayersText;
    }

    public Map<TabPlayer, String> getSortedPlayers() {
        return this.sortedPlayers;
    }

    public Map<Integer, UUID> getUuids() {
        return this.uuids;
    }

    public Map<TabPlayer, Layout> getPlayerViews() {
        return this.playerViews;
    }

    public int getEmptySlotPing() {
        return this.emptySlotPing;
    }

    public String getDefaultSkin() {
        return this.defaultSkin;
    }

    public static enum Direction {
        COLUMNS,
        ROWS;

    }
}

