/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout.skin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.api.protocol.Skin;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.skin.MineSkin;
import me.neznamy.tab.shared.features.layout.skin.PlayerSkin;
import me.neznamy.tab.shared.features.layout.skin.SkinSource;
import me.neznamy.tab.shared.features.layout.skin.Texture;

public class SkinManager {
    private final List<String> invalidSkins = new ArrayList<String>();
    private Skin defaultSkin;
    private final Map<String, SkinSource> sources = new HashMap<String, SkinSource>();

    public SkinManager(String defaultSkin) {
        try {
            File f = new File(TAB.getInstance().getDataFolder(), "skincache.yml");
            if (f.exists() || f.createNewFile()) {
                YamlConfigurationFile cache = new YamlConfigurationFile(null, f);
                this.sources.put("player", new PlayerSkin(cache));
                this.sources.put("mineskin", new MineSkin(cache));
                this.sources.put("texture", new Texture(cache));
                this.defaultSkin = this.getSkin(defaultSkin);
            } else {
                TAB.getInstance().getErrorManager().criticalError("Failed to load skin cache", null);
            }
        }
        catch (IOException e) {
            TAB.getInstance().getErrorManager().criticalError("Failed to load skin cache", e);
        }
    }

    public Skin getSkin(String skin) {
        if (this.invalidSkins.contains(skin)) {
            return this.defaultSkin;
        }
        for (Map.Entry<String, SkinSource> entry : this.sources.entrySet()) {
            if (!skin.startsWith(entry.getKey() + ":")) continue;
            List<String> value = entry.getValue().getSkin(skin.substring(entry.getKey().length() + 1));
            if (value.isEmpty()) {
                this.invalidSkins.add(skin);
                return this.defaultSkin;
            }
            return new Skin(value.get(0), value.get(1));
        }
        TAB.getInstance().getErrorManager().startupWarn("Invalid skin definition: \"" + skin + "\"");
        return null;
    }

    public Skin getDefaultSkin() {
        return this.defaultSkin;
    }
}

