/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout.skin;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.config.ConfigurationFile;
import me.neznamy.tab.libs.org.json.simple.JSONObject;
import me.neznamy.tab.libs.org.json.simple.parser.JSONParser;
import me.neznamy.tab.libs.org.json.simple.parser.ParseException;

public abstract class SkinSource {
    private final ConfigurationFile file;
    private final String path;
    private final Map<String, List<String>> cache;

    protected SkinSource(ConfigurationFile file, String path) {
        this.file = file;
        this.path = path;
        this.cache = file.getConfigurationSection(path);
    }

    public List<String> getSkin(String skin) {
        if (this.cache.containsKey(skin)) {
            return this.cache.get(skin);
        }
        List<String> properties = this.download(skin);
        if (!properties.isEmpty()) {
            this.cache.put(skin, properties);
            this.file.set(this.path, this.cache);
            return properties;
        }
        return properties;
    }

    public abstract List<String> download(String var1);

    protected JSONObject getResponse(String url) throws IOException, ParseException {
        try (InputStreamReader reader = new InputStreamReader(new URL(url).openStream());){
            JSONObject jSONObject = (JSONObject)new JSONParser().parse(reader);
            return jSONObject;
        }
    }
}

