/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.team.TeamManager;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.TabExpansion;
import me.neznamy.tab.shared.features.layout.LayoutManager;
import me.neznamy.tab.shared.features.nametags.CollisionManager;
import me.neznamy.tab.shared.features.nametags.VisibilityRefresher;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.sorting.Sorting;

public class NameTag
extends TabFeature
implements TeamManager {
    private final boolean invisibleNameTags = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.invisible-nametags", false);
    private final boolean collisionRule = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.enable-collision", true);
    private final Sorting sorting = new Sorting(this);
    private final CollisionManager collisionManager = new CollisionManager(this, this.collisionRule);
    private final Set<TabPlayer> hiddenNameTag = Collections.newSetFromMap(new WeakHashMap());
    protected final Set<TabPlayer> teamHandlingPaused = Collections.newSetFromMap(new WeakHashMap());
    protected final WeakHashMap<TabPlayer, List<TabPlayer>> hiddenNameTagFor = new WeakHashMap();
    private final WeakHashMap<TabPlayer, String> forcedTeamName = new WeakHashMap();
    protected final Set<TabPlayer> playersWithInvisibleNameTagView = Collections.newSetFromMap(new WeakHashMap());
    private final boolean accepting18x = TAB.getInstance().getServerVersion() == ProtocolVersion.PROXY || TAB.getInstance().getPlatform().getPluginVersion("ViaRewind") != null || TAB.getInstance().getPlatform().getPluginVersion("ProtocolSupport") != null || TAB.getInstance().getServerVersion().getMinorVersion() == 8;

    public NameTag() {
        super("NameTags", "Updating prefix/suffix", "scoreboard-teams");
        TAB.getInstance().getFeatureManager().registerFeature("sorting", this.sorting);
        if (this.accepting18x) {
            TAB.getInstance().getFeatureManager().registerFeature("NameTagVisibility", new VisibilityRefresher(this));
        }
        TAB.getInstance().getFeatureManager().registerFeature("NameTagCollision", this.collisionManager);
        TAB.getInstance().debug(String.format("Loaded NameTag feature with parameters collisionRule=%s, disabledWorlds=%s, disabledServers=%s, invisibleNameTags=%s", this.collisionRule, Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers), this.invisibleNameTags));
    }

    @Override
    public void load() {
        TabExpansion expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion();
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            ((ITabPlayer)all).setTeamName(this.getSorting().getTeamName(all));
            this.updateProperties(all);
            this.hiddenNameTagFor.put(all, new ArrayList());
            if (this.isDisabled(all.getServer(), all.getWorld())) {
                this.addDisabledPlayer(all);
                continue;
            }
            this.registerTeam(all);
            if (expansion == null) continue;
            expansion.setNameTagVisibility(all, true);
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(p)) continue;
            this.unregisterTeam(p);
        }
    }

    @Override
    public void onLoginPacket(TabPlayer packetReceiver) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!all.isLoaded() || this.isDisabledPlayer(all)) continue;
            this.registerTeam(all, packetReceiver);
        }
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        boolean refresh;
        if (this.isDisabledPlayer(refreshed)) {
            return;
        }
        if (force) {
            this.updateProperties(refreshed);
            refresh = true;
        } else {
            boolean prefix = refreshed.getProperty("tagprefix").update();
            boolean suffix = refreshed.getProperty("tagsuffix").update();
            boolean bl = refresh = prefix || suffix;
        }
        if (refresh) {
            this.updateTeam(refreshed);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        ((ITabPlayer)connectedPlayer).setTeamName(this.getSorting().getTeamName(connectedPlayer));
        this.updateProperties(connectedPlayer);
        this.hiddenNameTagFor.put(connectedPlayer, new ArrayList());
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == connectedPlayer || this.isDisabledPlayer(all)) continue;
            this.registerTeam(all, connectedPlayer);
        }
        TabExpansion expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion();
        if (expansion != null) {
            expansion.setNameTagVisibility(connectedPlayer, true);
        }
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        this.registerTeam(connectedPlayer);
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        if (!this.isDisabledPlayer(disconnectedPlayer) && !this.hasTeamHandlingPaused(disconnectedPlayer)) {
            PacketPlayOutScoreboardTeam packet = new PacketPlayOutScoreboardTeam(disconnectedPlayer.getTeamName());
            TabPlayer[] tabPlayerArray = TAB.getInstance().getOnlinePlayers();
            int n = tabPlayerArray.length;
            for (int i = 0; i < n; ++i) {
                TabPlayer viewer = tabPlayerArray[i];
                if (viewer == disconnectedPlayer) continue;
                viewer.sendCustomPacket((TabPacket)packet, "NameTags (Team unregister)");
            }
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            List<TabPlayer> list;
            if (all == disconnectedPlayer || (list = this.hiddenNameTagFor.get(all)) == null) continue;
            list.remove(disconnectedPlayer);
        }
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        boolean disabledBefore = this.isDisabledPlayer(p);
        boolean disabledNow = false;
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            disabledNow = true;
            this.addDisabledPlayer(p);
        } else {
            this.removeDisabledPlayer(p);
        }
        boolean changed = this.updateProperties(p);
        if (disabledNow && !disabledBefore) {
            this.unregisterTeam(p);
        } else if (!disabledNow && disabledBefore) {
            this.registerTeam(p);
        } else if (changed) {
            this.updateTeam(p);
        }
    }

    @Override
    public void hideNametag(TabPlayer player) {
        if (this.hiddenNameTag.contains(player)) {
            return;
        }
        this.hiddenNameTag.add(player);
        this.updateTeamData(player);
    }

    @Override
    public void hideNametag(TabPlayer player, TabPlayer viewer) {
        if (this.hiddenNameTagFor.get(player).contains(viewer)) {
            return;
        }
        this.hiddenNameTagFor.get(player).add(viewer);
        this.updateTeamData(player, viewer);
    }

    @Override
    public void showNametag(TabPlayer player) {
        if (!this.hiddenNameTag.contains(player)) {
            return;
        }
        this.hiddenNameTag.remove(player);
        this.updateTeamData(player);
    }

    @Override
    public void showNametag(TabPlayer player, TabPlayer viewer) {
        if (!this.hiddenNameTagFor.get(player).contains(viewer)) {
            return;
        }
        this.hiddenNameTagFor.get(player).remove(viewer);
        this.updateTeamData(player, viewer);
    }

    @Override
    public boolean hasHiddenNametag(TabPlayer player) {
        return this.hiddenNameTag.contains(player);
    }

    @Override
    public boolean hasHiddenNametag(TabPlayer player, TabPlayer viewer) {
        return this.hiddenNameTagFor.containsKey(player) && this.hiddenNameTagFor.get(player).contains(viewer);
    }

    @Override
    public void pauseTeamHandling(TabPlayer player) {
        if (this.teamHandlingPaused.contains(player)) {
            return;
        }
        if (!this.isDisabledPlayer(player)) {
            this.unregisterTeam(player);
        }
        this.teamHandlingPaused.add(player);
    }

    @Override
    public void resumeTeamHandling(TabPlayer player) {
        if (!this.teamHandlingPaused.contains(player)) {
            return;
        }
        this.teamHandlingPaused.remove(player);
        if (!this.isDisabledPlayer(player)) {
            this.registerTeam(player);
        }
    }

    @Override
    public boolean hasTeamHandlingPaused(TabPlayer player) {
        return this.teamHandlingPaused.contains(player);
    }

    @Override
    public void forceTeamName(TabPlayer player, String name) {
        RedisSupport redis;
        if (Objects.equals(this.forcedTeamName.get(player), name)) {
            return;
        }
        if (name != null && name.length() > 16) {
            throw new IllegalArgumentException("Team name cannot be more than 16 characters long.");
        }
        this.unregisterTeam(player);
        this.forcedTeamName.put(player, name);
        this.registerTeam(player);
        if (name != null) {
            ((ITabPlayer)player).setTeamNameNote("Set using API");
        }
        if ((redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee")) != null) {
            redis.updateTeamName(player, player.getTeamName());
        }
    }

    @Override
    public String getForcedTeamName(TabPlayer player) {
        return this.forcedTeamName.get(player);
    }

    @Override
    public void setCollisionRule(TabPlayer player, Boolean collision) {
        this.collisionManager.setCollisionRule(player, collision);
    }

    @Override
    public Boolean getCollisionRule(TabPlayer player) {
        return this.collisionManager.getCollisionRule(player);
    }

    @Override
    public void updateTeamData(TabPlayer p) {
        Property tagPrefix = p.getProperty("tagprefix");
        Property tagSuffix = p.getProperty("tagsuffix");
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            String currentPrefix = tagPrefix.getFormat(viewer);
            String currentSuffix = tagSuffix.getFormat(viewer);
            boolean visible = this.getTeamVisibility(p, viewer);
            viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(p.getTeamName(), currentPrefix, currentSuffix, this.translate(visible), this.translate(this.collisionManager.getCollision(p)), 2), "NameTags (Team update)");
        }
        RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        if (redis != null) {
            redis.updateNameTag(p, p.getProperty("tagprefix").get(), p.getProperty("tagsuffix").get());
        }
    }

    public void updateTeamData(TabPlayer p, TabPlayer viewer) {
        boolean visible = this.getTeamVisibility(p, viewer);
        String currentPrefix = p.getProperty("tagprefix").getFormat(viewer);
        String currentSuffix = p.getProperty("tagsuffix").getFormat(viewer);
        viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(p.getTeamName(), currentPrefix, currentSuffix, this.translate(visible), this.translate(this.collisionManager.getCollision(p)), 2), "NameTags (Team update)");
    }

    public void unregisterTeam(TabPlayer p) {
        if (this.hasTeamHandlingPaused(p) || p.getTeamName() == null) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(p.getTeamName()), "NameTags (Team unregister)");
        }
    }

    public void registerTeam(TabPlayer p) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.registerTeam(p, viewer);
        }
    }

    private void registerTeam(TabPlayer p, TabPlayer viewer) {
        if (this.hasTeamHandlingPaused(p)) {
            return;
        }
        String replacedPrefix = p.getProperty("tagprefix").getFormat(viewer);
        String replacedSuffix = p.getProperty("tagsuffix").getFormat(viewer);
        viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(p.getTeamName(), replacedPrefix, replacedSuffix, this.translate(this.getTeamVisibility(p, viewer)), this.translate(this.collisionManager.getCollision(p)), Collections.singletonList(p.getNickname()), 2), "NameTags (Team register)");
    }

    private void updateTeam(TabPlayer p) {
        if (p.getTeamName() == null) {
            return;
        }
        String newName = this.getSorting().getTeamName(p);
        if (p.getTeamName().equals(newName)) {
            this.updateTeamData(p);
        } else {
            this.unregisterTeam(p);
            LayoutManager layout = (LayoutManager)TAB.getInstance().getFeatureManager().getFeature("layout");
            if (layout != null) {
                layout.updateTeamName(p, newName);
            }
            ((ITabPlayer)p).setTeamName(newName);
            this.registerTeam(p);
            RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
            if (redis != null) {
                redis.updateTeamName(p, p.getTeamName());
            }
        }
    }

    public String translate(boolean b) {
        return b ? "always" : "never";
    }

    protected boolean updateProperties(TabPlayer p) {
        boolean changed = p.loadPropertyFromConfig(this, "tagprefix");
        if (p.loadPropertyFromConfig(this, "tagsuffix")) {
            changed = true;
        }
        return changed;
    }

    public boolean getTeamVisibility(TabPlayer p, TabPlayer viewer) {
        return !this.hasHiddenNametag(p) && !this.hasHiddenNametag(p, viewer) && !this.invisibleNameTags && (!this.accepting18x || !p.hasInvisibilityPotion()) && !this.playersWithInvisibleNameTagView.contains(viewer);
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    @Override
    public void setPrefix(TabPlayer player, String prefix) {
        Preconditions.checkLoaded(player);
        player.getProperty("tagprefix").setTemporaryValue(prefix);
        this.updateTeamData(player);
    }

    @Override
    public void setSuffix(TabPlayer player, String suffix) {
        Preconditions.checkLoaded(player);
        player.getProperty("tagsuffix").setTemporaryValue(suffix);
        this.updateTeamData(player);
    }

    @Override
    public void resetPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        player.getProperty("tagprefix").setTemporaryValue(null);
        this.updateTeamData(player);
    }

    @Override
    public void resetSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        player.getProperty("tagsuffix").setTemporaryValue(null);
        this.updateTeamData(player);
    }

    @Override
    public String getCustomPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tagprefix").getTemporaryValue();
    }

    @Override
    public String getCustomSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tagsuffix").getTemporaryValue();
    }

    @Override
    public String getOriginalPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tagprefix").getOriginalRawValue();
    }

    @Override
    public String getOriginalSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("tagsuffix").getOriginalRawValue();
    }

    @Override
    public void toggleNameTagVisibilityView(TabPlayer player, boolean sendToggleMessage) {
        TabExpansion expansion;
        if (this.playersWithInvisibleNameTagView.contains(player)) {
            this.playersWithInvisibleNameTagView.remove(player);
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNameTagsShown(), true);
            }
        } else {
            this.playersWithInvisibleNameTagView.add(player);
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNameTagsHidden(), true);
            }
        }
        if ((expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion()) != null) {
            expansion.setNameTagVisibility(player, !this.playersWithInvisibleNameTagView.contains(player));
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.updateTeamData(all, player);
        }
    }

    @Override
    public boolean hasHiddenNameTagVisibilityView(TabPlayer player) {
        return this.playersWithInvisibleNameTagView.contains(player);
    }
}

