/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabConstants;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.api.scoreboard.ScoreboardManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PipelineInjector;
import me.neznamy.tab.shared.features.TabExpansion;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;

public class ScoreboardManagerImpl
extends TabFeature
implements ScoreboardManager {
    public static final String OBJECTIVE_NAME = "TAB-Scoreboard";
    public static final int DISPLAY_SLOT = 1;
    private final String toggleCommand = TAB.getInstance().getConfiguration().getConfig().getString("scoreboard.toggle-command", "/sb");
    private final boolean useNumbers = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard.use-numbers", false);
    private final boolean rememberToggleChoice = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard.remember-toggle-choice", false);
    private final boolean hiddenByDefault = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard.hidden-by-default", false);
    private final boolean respectOtherPlugins = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard.respect-other-plugins", true);
    private final int staticNumber = TAB.getInstance().getConfiguration().getConfig().getInt("scoreboard.static-number", 0);
    private final int joinDelay = TAB.getInstance().getConfiguration().getConfig().getInt("scoreboard.delay-on-join-milliseconds", 0);
    private final Map<String, Scoreboard> scoreboards = new LinkedHashMap<String, Scoreboard>();
    private Scoreboard[] definedScoreboards;
    private final String scoreboardOn = TAB.getInstance().getConfiguration().getMessages().getScoreboardOn();
    private final String scoreboardOff = TAB.getInstance().getConfiguration().getMessages().getScoreboardOff();
    private final List<String> sbOffPlayers;
    private Scoreboard announcement;
    private final Set<TabPlayer> joinDelayed = Collections.newSetFromMap(new WeakHashMap());
    private final WeakHashMap<TabPlayer, ScoreboardImpl> forcedScoreboard = new WeakHashMap();
    private final WeakHashMap<TabPlayer, ScoreboardImpl> activeScoreboard = new WeakHashMap();
    private final Set<TabPlayer> visiblePlayers = Collections.newSetFromMap(new WeakHashMap());
    private final WeakHashMap<TabPlayer, String> otherPluginScoreboard = new WeakHashMap();

    public ScoreboardManagerImpl() {
        super("Scoreboard", "Switching displayed scoreboard", "scoreboard");
        PipelineInjector inj;
        this.sbOffPlayers = this.rememberToggleChoice ? Collections.synchronizedList(new ArrayList<String>(TAB.getInstance().getConfiguration().getPlayerDataFile().getStringList("scoreboard-off", new ArrayList<String>()))) : Collections.emptyList();
        Map map = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("scoreboard.scoreboards");
        for (Map.Entry entry : map.entrySet()) {
            List<String> lines;
            String condition = (String)((Map)entry.getValue()).get("display-condition");
            String title = (String)((Map)entry.getValue()).get("title");
            if (title == null) {
                title = "<Title not defined>";
                TAB.getInstance().getErrorManager().missingAttribute(this.getFeatureName(), entry.getKey(), "title");
            }
            if ((lines = (List<String>)((Map)entry.getValue()).get("lines")) == null) {
                lines = Arrays.asList("scoreboard \"" + (String)entry.getKey() + "\" is missing \"lines\" keyword!", "did you forget to configure it or just your spacing is wrong?");
                TAB.getInstance().getErrorManager().missingAttribute(this.getFeatureName(), entry.getKey(), "lines");
            }
            ScoreboardImpl sb = new ScoreboardImpl(this, (String)entry.getKey(), title, lines, condition);
            this.scoreboards.put((String)entry.getKey(), sb);
            TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.scoreboardLine((String)entry.getKey()), sb);
        }
        this.definedScoreboards = this.scoreboards.values().toArray(new Scoreboard[0]);
        if (this.respectOtherPlugins && (inj = (PipelineInjector)TAB.getInstance().getFeatureManager().getFeature("injection")) != null) {
            inj.setByteBufDeserialization(true);
        }
        TAB.getInstance().debug(String.format("Loaded Scoreboard feature with parameters toggleCommand=%s, useNumbers=%s, disabledWorlds=%s, disabledServers=%s, rememberToggleChoice=%s, hiddenByDefault=%s, scoreboard_on=%s, scoreboard_off=%s, staticNumber=%s, joinDelay=%s", this.toggleCommand, this.useNumbers, Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers), this.rememberToggleChoice, this.hiddenByDefault, this.scoreboardOn, this.scoreboardOff, this.staticNumber, this.joinDelay));
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (this.forcedScoreboard.containsKey(p) || !this.hasScoreboardVisible(p) || this.announcement != null || this.otherPluginScoreboard.containsKey(p) || this.joinDelayed.contains(p)) {
            return;
        }
        this.sendHighestScoreboard(p);
    }

    @Override
    public void unload() {
        for (Scoreboard board : this.definedScoreboards) {
            board.unregister();
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            if (this.hiddenByDefault == this.sbOffPlayers.contains(connectedPlayer.getName())) {
                this.visiblePlayers.add(connectedPlayer);
            }
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        if (this.joinDelay > 0) {
            this.joinDelayed.add(connectedPlayer);
            TAB.getInstance().getCPUManager().runTaskLater(this.joinDelay, this, "Player Join", () -> {
                if (!this.otherPluginScoreboard.containsKey(connectedPlayer)) {
                    this.setScoreboardVisible(connectedPlayer, this.hiddenByDefault == this.sbOffPlayers.contains(connectedPlayer.getName()), false);
                }
                this.joinDelayed.remove(connectedPlayer);
            });
        } else {
            this.setScoreboardVisible(connectedPlayer, this.hiddenByDefault == this.sbOffPlayers.contains(connectedPlayer.getName()), false);
        }
    }

    public void sendHighestScoreboard(TabPlayer p) {
        ScoreboardImpl current;
        if (this.isDisabledPlayer(p) || !this.hasScoreboardVisible(p)) {
            return;
        }
        ScoreboardImpl scoreboard = (ScoreboardImpl)this.detectHighestScoreboard(p);
        if (scoreboard != (current = this.activeScoreboard.get(p))) {
            if (current != null) {
                current.removePlayer(p);
            }
            if (scoreboard != null) {
                scoreboard.addPlayer(p);
            }
        }
    }

    public void unregisterScoreboard(TabPlayer p) {
        if (this.activeScoreboard.containsKey(p)) {
            this.activeScoreboard.get(p).removePlayer(p);
            this.activeScoreboard.remove(p);
        }
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        boolean disabledBefore = this.isDisabledPlayer(p);
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            this.addDisabledPlayer(p);
            if (!disabledBefore) {
                this.unregisterScoreboard(p);
            }
        } else {
            this.removeDisabledPlayer(p);
            if (disabledBefore) {
                this.sendHighestScoreboard(p);
            }
        }
    }

    public boolean isUsingNumbers() {
        return this.useNumbers;
    }

    public int getStaticNumber() {
        return this.staticNumber;
    }

    public Scoreboard detectHighestScoreboard(TabPlayer p) {
        if (this.forcedScoreboard.containsKey(p)) {
            return this.forcedScoreboard.get(p);
        }
        for (Scoreboard sb : this.definedScoreboards) {
            if (!((ScoreboardImpl)sb).isConditionMet(p)) continue;
            return sb;
        }
        return null;
    }

    @Override
    public boolean onCommand(TabPlayer sender, String message) {
        if (this.isDisabledPlayer(sender)) {
            return false;
        }
        if (message.equals(this.toggleCommand) || message.startsWith(this.toggleCommand + " ")) {
            TAB.getInstance().getCommand().execute(sender, message.replace(this.toggleCommand, "scoreboard").split(" "));
            return true;
        }
        return false;
    }

    @Override
    public void onDisplayObjective(TabPlayer receiver, PacketPlayOutScoreboardDisplayObjective packet) {
        if (this.respectOtherPlugins && packet.getSlot() == 1 && !packet.getObjectiveName().equals(OBJECTIVE_NAME)) {
            TAB.getInstance().debug("Player " + receiver.getName() + " received scoreboard called " + packet.getObjectiveName() + ", hiding TAB one.");
            this.otherPluginScoreboard.put(receiver, packet.getObjectiveName());
            ScoreboardImpl sb = this.activeScoreboard.get(receiver);
            if (sb != null) {
                TAB.getInstance().getCPUManager().runMeasuredTask(this, "Checking for other plugins", () -> sb.removePlayer(receiver));
            }
        }
    }

    @Override
    public void onObjective(TabPlayer receiver, PacketPlayOutScoreboardObjective packet) {
        if (this.respectOtherPlugins && packet.getAction() == 1 && this.otherPluginScoreboard.containsKey(receiver) && this.otherPluginScoreboard.get(receiver).equals(packet.getObjectiveName())) {
            TAB.getInstance().debug("Player " + receiver.getName() + " no longer has another scoreboard, sending TAB one.");
            this.otherPluginScoreboard.remove(receiver);
            TAB.getInstance().getCPUManager().runMeasuredTask(this, "Checking for other plugins", () -> this.sendHighestScoreboard(receiver));
        }
    }

    @Override
    public Scoreboard createScoreboard(String name, String title, List<String> lines) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines cannot be null");
        }
        ScoreboardImpl sb = new ScoreboardImpl(this, name, title, lines, true);
        this.scoreboards.put(name, sb);
        this.definedScoreboards = this.scoreboards.values().toArray(new Scoreboard[0]);
        return sb;
    }

    @Override
    public Map<String, Scoreboard> getRegisteredScoreboards() {
        return this.scoreboards;
    }

    @Override
    public void showScoreboard(TabPlayer player, Scoreboard scoreboard) {
        if (player == null) {
            throw new IllegalArgumentException("player cannot be null");
        }
        if (scoreboard == null) {
            throw new IllegalArgumentException("scoreboard cannot be null");
        }
        if (this.forcedScoreboard.containsKey(player)) {
            this.forcedScoreboard.get(player).removePlayer(player);
        }
        if (this.activeScoreboard.containsKey(player)) {
            this.activeScoreboard.get(player).removePlayer(player);
            this.activeScoreboard.remove(player);
        }
        this.forcedScoreboard.put(player, (ScoreboardImpl)scoreboard);
        ((ScoreboardImpl)scoreboard).addPlayer(player);
    }

    @Override
    public void resetScoreboard(TabPlayer player) {
        if (!this.forcedScoreboard.containsKey(player)) {
            return;
        }
        this.forcedScoreboard.get(player).removePlayer(player);
        this.forcedScoreboard.remove(player);
        Scoreboard sb = this.detectHighestScoreboard(player);
        if (sb == null) {
            return;
        }
        this.activeScoreboard.put(player, (ScoreboardImpl)sb);
        ((ScoreboardImpl)sb).addPlayer(player);
        this.forcedScoreboard.remove(player);
    }

    @Override
    public boolean hasScoreboardVisible(TabPlayer player) {
        return this.visiblePlayers.contains(player);
    }

    @Override
    public boolean hasCustomScoreboard(TabPlayer player) {
        return this.forcedScoreboard.containsKey(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScoreboardVisible(TabPlayer player, boolean visible, boolean sendToggleMessage) {
        TabExpansion expansion;
        List<String> list;
        if (this.visiblePlayers.contains(player) == visible) {
            return;
        }
        if (visible) {
            this.visiblePlayers.add(player);
            this.sendHighestScoreboard(player);
            if (sendToggleMessage) {
                player.sendMessage(this.scoreboardOn, true);
            }
            if (this.rememberToggleChoice) {
                if (this.hiddenByDefault) {
                    if (!this.sbOffPlayers.contains(player.getName())) {
                        this.sbOffPlayers.add(player.getName());
                    }
                } else {
                    this.sbOffPlayers.remove(player.getName());
                }
                list = this.sbOffPlayers;
                synchronized (list) {
                    TAB.getInstance().getConfiguration().getPlayerDataFile().set("scoreboard-off", new ArrayList<String>(this.sbOffPlayers));
                }
            }
        } else {
            this.visiblePlayers.remove(player);
            this.unregisterScoreboard(player);
            if (sendToggleMessage) {
                player.sendMessage(this.scoreboardOff, true);
            }
            if (this.rememberToggleChoice) {
                if (this.hiddenByDefault) {
                    this.sbOffPlayers.remove(player.getName());
                } else if (!this.sbOffPlayers.contains(player.getName())) {
                    this.sbOffPlayers.add(player.getName());
                }
                list = this.sbOffPlayers;
                synchronized (list) {
                    TAB.getInstance().getConfiguration().getPlayerDataFile().set("scoreboard-off", new ArrayList<String>(this.sbOffPlayers));
                }
            }
        }
        if ((expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion()) != null) {
            expansion.setScoreboardVisible(player, visible);
        }
    }

    @Override
    public void toggleScoreboard(TabPlayer player, boolean sendToggleMessage) {
        this.setScoreboardVisible(player, !this.visiblePlayers.contains(player), sendToggleMessage);
    }

    public Map<TabPlayer, ScoreboardImpl> getActiveScoreboards() {
        return this.activeScoreboard;
    }

    public Map<TabPlayer, String> getOtherPluginScoreboards() {
        return this.otherPluginScoreboard;
    }

    @Override
    public void announceScoreboard(String scoreboard, int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Duration cannot be negative");
        }
        ScoreboardImpl sb = (ScoreboardImpl)this.scoreboards.get(scoreboard);
        if (sb == null) {
            throw new IllegalArgumentException("No registered scoreboard found with name " + scoreboard);
        }
        HashMap previous = new HashMap();
        TAB.getInstance().getCPUManager().runTask(() -> {
            this.announcement = sb;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!this.hasScoreboardVisible(all)) continue;
                previous.put(all, this.activeScoreboard.get(all));
                if (this.activeScoreboard.containsKey(all)) {
                    this.activeScoreboard.get(all).removePlayer(all);
                }
                sb.addPlayer(all);
            }
        });
        TAB.getInstance().getCPUManager().runTaskLater(duration * 1000, this, "Removing announced Scoreboard", () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!this.hasScoreboardVisible(all)) continue;
                sb.removePlayer(all);
                if (previous.get(all) == null) continue;
                ((ScoreboardImpl)previous.get(all)).addPlayer(all);
            }
            this.announcement = null;
        });
    }

    @Override
    public Scoreboard getActiveScoreboard(TabPlayer player) {
        return this.activeScoreboard.get(player);
    }

    @Override
    public void onLoginPacket(TabPlayer packetReceiver) {
        this.otherPluginScoreboard.remove(packetReceiver);
        ScoreboardImpl scoreboard = this.activeScoreboard.get(packetReceiver);
        if (scoreboard != null) {
            scoreboard.removePlayer(packetReceiver);
            scoreboard.addPlayer(packetReceiver);
        }
    }
}

