/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard.lines;

import me.neznamy.tab.api.TabConstants;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;

public class LongLine
extends ScoreboardLine {
    private final String textProperty;
    private final String nameProperty;

    public LongLine(ScoreboardImpl parent, int lineNumber, String text) {
        super(parent, lineNumber);
        this.text = text;
        this.nameProperty = TabConstants.Property.scoreboardName(parent.getName(), lineNumber);
        this.textProperty = parent.getName() + "-" + this.teamName;
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        if (!this.parent.getPlayers().contains(refreshed)) {
            return;
        }
        if (refreshed.getProperty(this.textProperty).update()) {
            if (refreshed.getVersion().getMinorVersion() >= 13) {
                refreshed.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(this.teamName, refreshed.getProperty(this.textProperty).get(), "", "always", "always", 0), "Scoreboard (Lines)");
            } else {
                this.removeLine(refreshed, refreshed.getProperty(this.nameProperty).get());
                String[] values = this.splitText(this.getPlayerName(this.lineNumber), RGBUtils.getInstance().convertRGBtoLegacy(refreshed.getProperty(this.textProperty).get()), refreshed.getVersion().getMinorVersion() >= 8 ? 40 : 16);
                this.addLine(refreshed, values[1], values[0], values[2]);
                refreshed.setProperty(this, this.nameProperty, values[1]);
            }
        }
    }

    @Override
    public void register(TabPlayer p) {
        p.setProperty(this, this.textProperty, this.text);
        String value = p.getProperty(this.textProperty).get();
        if (p.getVersion().getMinorVersion() >= 13) {
            this.addLine(p, this.playerName, value, "");
            p.setProperty(this, this.nameProperty, this.playerName);
        } else {
            String[] values = this.splitText(this.playerName, RGBUtils.getInstance().convertRGBtoLegacy(value), p.getVersion().getMinorVersion() >= 8 ? 40 : 16);
            this.addLine(p, values[1], values[0], values[2]);
            p.setProperty(this, this.nameProperty, values[1]);
        }
    }

    @Override
    public void unregister(TabPlayer p) {
        if (this.parent.getPlayers().contains(p)) {
            this.removeLine(p, p.getProperty(this.nameProperty).get());
        }
    }

    @Override
    public void setText(String text) {
        this.text = text;
        for (TabPlayer p : this.parent.getPlayers()) {
            p.setProperty(this, this.textProperty, text);
            this.refresh(p, true);
        }
    }

    @Override
    public String getPlayerName(TabPlayer viewer) {
        return viewer.getProperty(this.nameProperty).get();
    }
}

