/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.ArrayList;
import java.util.List;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.PlaceholderReplacementPattern;

public abstract class TabPlaceholder
implements Placeholder {
    private final int refresh;
    protected final String identifier;
    protected final PlaceholderReplacementPattern replacements;
    private boolean active;
    private Runnable onActivation;
    private Runnable onDisable;
    protected final List<String> parents = new ArrayList<String>();

    protected TabPlaceholder(String identifier, int refresh) {
        if (refresh % 50 != 0 && refresh != -1) {
            throw new IllegalArgumentException("Refresh interval must be divisible by 50");
        }
        if (!identifier.startsWith("%") || !identifier.endsWith("%")) {
            throw new IllegalArgumentException("Identifier must start and end with %");
        }
        this.identifier = identifier;
        this.refresh = refresh;
        this.replacements = new PlaceholderReplacementPattern(identifier, TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("placeholder-output-replacements." + identifier));
        for (String nested : this.getNestedPlaceholders("")) {
            TAB.getInstance().getPlaceholderManager().getPlaceholder(nested).addParent(identifier);
        }
        for (String nested : this.replacements.getNestedPlaceholders()) {
            TAB.getInstance().getPlaceholderManager().getPlaceholder(nested).addParent(identifier);
        }
    }

    public String set(String string, TabPlayer player) {
        return this.replace(string, this.identifier, this.setPlaceholders(this.getLastValue(player), player));
    }

    public List<String> getNestedPlaceholders(String output) {
        return TabAPI.getInstance().getPlaceholderManager().detectPlaceholders(output);
    }

    private String replace(String string, String original, String replacement) {
        if (!string.contains(original)) {
            return string;
        }
        if (string.equals(original)) {
            return replacement;
        }
        return string.replace(original, replacement);
    }

    protected String setPlaceholders(String text, TabPlayer p) {
        if (this.identifier.equals(text)) {
            return text;
        }
        String replaced = text;
        for (String s : this.getNestedPlaceholders(text)) {
            if (s.equals(this.identifier) || this.identifier.startsWith("%sync:") && ("%" + this.identifier.substring(6)).equals(s) || s.startsWith("%rel_")) continue;
            replaced = TAB.getInstance().getPlaceholderManager().getPlaceholder(s).set(replaced, p);
        }
        return replaced;
    }

    public PlaceholderReplacementPattern getReplacements() {
        return this.replacements;
    }

    public void markAsUsed() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (this.onActivation != null) {
            this.onActivation.run();
        }
    }

    public void addParent(String parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
        }
    }

    public void updateParents(TabPlayer player) {
        if (this.parents.isEmpty()) {
            return;
        }
        this.parents.stream().map(identifier -> TAB.getInstance().getPlaceholderManager().getPlaceholder((String)identifier)).forEach(placeholder -> placeholder.updateFromNested(player));
    }

    public abstract void updateFromNested(TabPlayer var1);

    public abstract String getLastValue(TabPlayer var1);

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getRefresh() {
        return this.refresh;
    }

    @Override
    public void unload() {
        if (this.onDisable != null && this.active) {
            this.onDisable.run();
        }
    }

    @Override
    public void enableTriggerMode(Runnable onActivation, Runnable onDisable) {
        this.onActivation = onActivation;
        this.onDisable = onDisable;
        if (this.active && onActivation != null) {
            onActivation.run();
        }
    }

    @Override
    public boolean isUsed() {
        return this.active;
    }
}

