/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions.simple;

import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.conditions.simple.SimpleCondition;

public abstract class NumericCondition
extends SimpleCondition {
    private boolean leftSideStatic;
    private float leftSideValue;
    private boolean rightSideStatic;
    private float rightSideValue;

    public double getLeftSide(TabPlayer p) {
        if (this.leftSideStatic) {
            return this.leftSideValue;
        }
        String value = this.parseLeftSide(p);
        if (value.contains(",")) {
            value = value.replace(",", "");
        }
        return TAB.getInstance().getErrorManager().parseDouble(value, 0.0);
    }

    public double getRightSide(TabPlayer p) {
        if (this.rightSideStatic) {
            return this.rightSideValue;
        }
        String value = this.parseRightSide(p);
        if (value.contains(",")) {
            value = value.replace(",", "");
        }
        return TAB.getInstance().getErrorManager().parseDouble(value, 0.0);
    }

    @Override
    protected void setSides(String leftSide, String rightSide) {
        super.setSides(leftSide, rightSide);
        try {
            this.leftSideValue = Float.parseFloat(leftSide);
            this.leftSideStatic = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.rightSideValue = Float.parseFloat(rightSide);
            this.rightSideStatic = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

