/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.permission.VaultBridge;
import me.neznamy.tab.shared.proxy.ProxyPlatform;

public abstract class ProxyTabPlayer
extends ITabPlayer {
    private boolean vanished;
    private boolean disguised;
    private boolean invisible;
    private boolean onBoat;
    private final Map<String, Boolean> permissions = new HashMap<String, Boolean>();

    protected ProxyTabPlayer(Object player, UUID uniqueId, String name, String server, int protocolVersion, boolean useRealId) {
        super(player, uniqueId, name, server, "N/A", protocolVersion, useRealId);
        this.sendJoinPluginMessage();
    }

    public void sendJoinPluginMessage() {
        ArrayList args = Lists.newArrayList((Object[])new Object[]{"PlayerJoin", this.getVersion().getNetworkId(), TAB.getInstance().getGroupManager().getPlugin() instanceof VaultBridge && !TAB.getInstance().getGroupManager().isGroupsByPermissions(), TAB.getInstance().getFeatureManager().isFeatureEnabled("PetFix"), TAB.getInstance().getPlaceholderManager().getTabExpansion() != null});
        ProxyPlatform platform = (ProxyPlatform)TAB.getInstance().getPlatform();
        Map<String, Integer> placeholders = platform.getBridgePlaceholders();
        args.add(placeholders.size());
        for (Map.Entry<String, Integer> entry : placeholders.entrySet()) {
            args.add(entry.getKey());
            args.add(entry.getValue());
        }
        NameTagX nametagx = (NameTagX)TAB.getInstance().getFeatureManager().getFeature("NameTagX");
        boolean enabled = nametagx != null && !nametagx.getDisabledUnlimitedServers().contains(this.getServer());
        args.add(enabled);
        if (enabled) {
            args.add(nametagx.isMarkerFor18x());
            args.add(0.26);
            args.add(nametagx.isDisableOnBoats());
            args.add(nametagx.isArmorStandsAlwaysVisible());
            args.add(nametagx.getDisabledUnlimitedWorlds().size());
            args.addAll(nametagx.getDisabledUnlimitedWorlds());
            args.add(nametagx.getDynamicLines().size());
            args.addAll(nametagx.getDynamicLines());
            args.add(nametagx.getStaticLines().size());
            for (Map.Entry<String, Object> entry : nametagx.getStaticLines().entrySet()) {
                args.add(entry.getKey());
                args.add(Double.valueOf(String.valueOf(entry.getValue())));
            }
        }
        ((ProxyPlatform)TAB.getInstance().getPlatform()).getPluginMessageHandler().sendMessage(this, args.toArray());
    }

    public void setVanished(boolean vanished) {
        this.vanished = vanished;
    }

    public void setDisguised(boolean disguised) {
        this.disguised = disguised;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void setOnBoat(boolean onBoat) {
        this.onBoat = onBoat;
    }

    public void setHasPermission(String permission, boolean value) {
        this.permissions.put(permission, value);
    }

    public boolean isOnBoat() {
        return this.onBoat;
    }

    public abstract boolean hasPermission0(String var1);

    public abstract void sendPluginMessage(byte[] var1);

    @Override
    public boolean isVanished() {
        return this.vanished;
    }

    @Override
    public boolean isDisguised() {
        return this.disguised;
    }

    @Override
    public boolean hasInvisibilityPotion() {
        return this.invisible;
    }

    @Override
    public boolean hasPermission(String permission) {
        if (TAB.getInstance().getConfiguration().isBukkitPermissions()) {
            ((ProxyPlatform)TAB.getInstance().getPlatform()).getPluginMessageHandler().sendMessage(this, "Permission", permission);
            return this.permissions != null && this.permissions.getOrDefault(permission, false) != false;
        }
        return this.hasPermission0(permission);
    }
}

